
uniform sampler2D texture;
uniform float texWidth, texHeight;
uniform float power;
uniform float metallic;

vec2 getDistortVec(sampler2D tex, vec3 o, vec2 xy) {
	// better version. makes everything looks metallic with high enough multiplier and works
	// almost on any material, especially if source material is not too noisy.
	o = -1.0+2.0*o;
	vec3 h = -1.0+2.0*texture2D(tex, xy+vec2(1.0/texWidth, 0.0)).rgb;
	vec3 v = -1.0+2.0*texture2D(tex, xy+vec2(0.0, 1.0/texHeight)).rgb;
	float oh = (o.x+o.y+o.z)/3.0;
	float hh = (h.x+h.y+h.z)/3.0;
	float vh = (v.x+v.y+v.z)/3.0;
	float dh = oh-hh;
	float dv = oh-vh;
	return vec2(dh, dv);
}

void main() {
	vec3 o = texture2D(texture, gl_TexCoord[0].xy).rgb;
	vec2 distort = power*getDistortVec(texture, o, gl_TexCoord[0].xy);
	vec3 dcol = texture2D(texture, gl_TexCoord[0].xy+distort).rgb;

	vec3 final = mix(o, dcol, metallic);

	gl_FragColor = vec4(final, 1.0);
}
