#include <gpgraphic16.h>
#include <gpmodplay.h>

#include "effects.h"
#include "precalcs.h"

int clockspeed = 133;

unsigned short *framebuffer[2];
GPDRAWSURFACE GP32Surface[2];

int flip=0;
int vsync=1;

extern unsigned char modfile1[];
MODPlay mymod;

unsigned int quit = 0;
extern int partime;

static void ClearScreen(int page, int c)
{
	unsigned short *vram = (unsigned short*)framebuffer[page];
	int i;
	for (i=0; i<76800; i++)
		*vram++=c;
}


void InitGraphics(int depth)
{
	GpGraphicModeSet(depth, NULL);

	GpLcdSurfaceGet(&GP32Surface[0], 0);
	GpLcdSurfaceGet(&GP32Surface[1], 1);
	GpSurfaceSet(&GP32Surface[0]);

	if (!(GpLcdStatusGet() & GPC_LCD_ON_BIT))
		GpLcdEnable();

	framebuffer[0] = (unsigned short*)GP32Surface[0].ptbuffer;
	framebuffer[1] = (unsigned short*)GP32Surface[1].ptbuffer;
}


static void InitMusic()
{
	MODPlay_Init (&mymod);
	MODPlay_SetMOD (&mymod, &modfile1);
	MODPlay_Start (&mymod);
}


static void Init()
{
	InitGraphics(16);
	ClearScreen(0, 0);
	ClearScreen(1, 0);

	InitFonts();
	precalcs();
	GpKeyInit();
	InitMusic();
	partime = Ticks();
}


void GpMain (void * arg)
{
	GpClockSpeedChange (132000000, 0x3a011, 3);
	Init();

	while (!quit)
	{
		Run();
		if (vsync) GpSurfaceFlip(&GP32Surface[flip]);
		flip=(flip+1) & 1;
	}
	GpAppExit ();
}
