
#include "fire.h"

cFireTorch::cFireTorch()
{
	m_pFlame=NULL;
	m_pSpark=NULL;
	m_pGfx_flame=NULL;
	m_pGfx_spark=NULL;

	m_intNumFlames=1000;
	m_intNumSparks=50;
	m_pFlame = new cFireParticle[m_intNumFlames];
	m_pSpark = new cFireParticle[m_intNumSparks];
	m_pGfx_flame = new CSurface;
	m_pGfx_spark = new CSurface;
	angx=0;
	angy=0;
	angz=0;
}

cFireTorch::~cFireTorch()
{
	if (m_pFlame!=NULL) delete [] m_pFlame;
	if (m_pSpark!=NULL) delete [] m_pSpark;
	if (m_pGfx_flame!=NULL) delete m_pGfx_flame;
	if (m_pGfx_spark!=NULL) delete m_pGfx_spark;
}


cFireTorch::Init(float x,float y,float z,char *file1,char *file2)
{
	int l1;


	m_pGfx_flame->LoadTGARAR(file1);
	Flameindex=GetFreeTextureIndex();
	m_pGfx_flame->Bind(Flameindex);

	m_pGfx_spark->LoadTGARAR(file2);
	Sparkindex=GetFreeTextureIndex();
	m_pGfx_spark->Bind(Sparkindex);

	for (l1=0; l1<m_intNumFlames; l1++)
	{
		m_pFlame[l1].xyz(x,y,z);
		m_pFlame[l1].life=rand()%120;
		m_pFlame[l1].accel((f2rand()-0.5)/50,
					   (f2rand()-0.5)/50,
					   (f2rand()-0.5)/50);
		m_pFlame[l1].spawn(x,y,z);
	}
	m_pFlame[0].xyz(0,0,0);

	for (l1=0; l1<m_intNumSparks; l1++)
	{
		m_pSpark[l1].xyz(x,y,z);
		m_pSpark[l1].life=rand()%120;
		m_pSpark[l1].accel((f2rand()-0.5)/50,
					   (f2rand()-0.5)/50,
					   (f2rand()-0.5)/50);
		m_pSpark[l1].spawn(x,y,z);
	}
}

cFireTorch::Pos(float x,float y,float z)
{
	xpos=x;
	ypos=y;
	zpos=z;
}


cFireTorch::UpdateFlame()
{
	int l1;
	for (l1=1; l1<m_intNumFlames; l1++)
	{
		m_pFlame[l1].move();//0,0,0);
		//m_pFlame[l1].life--;
		//if (m_pFlame[l1].life<=0) m_pFlame[l1].respawn();
		m_pFlame[l1].life=rand()%20;
		m_pFlame[l1].rotate(angx/4,angy/4,angz/4);
	}
}

cFireTorch::UpdateSpark()
{
	int l1;
	for (l1=0; l1<m_intNumSparks; l1++)
	{
		m_pSpark[l1].move();//0,0,0);
		//m_pSpark[l1].life--;
		//if (m_pSpark[l1].life<=0) m_pSpark[l1].respawn();
		m_pSpark[l1].life=rand()%40;
		m_pSpark[l1].rotate(angx/4,angy/4,angz/4);
	}
}


cFireTorch::DrawFire()
{
	int l1;

	//flames
	glBindTexture(GL_TEXTURE_2D, Flameindex);
	//m_pGfx_flame->DrawAsBackground();
	glEnable(GL_BLEND);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	for (l1=0; l1<m_intNumFlames; l1++)
		m_pGfx_flame->draw(m_pFlame[l1].rotx,m_pFlame[l1].roty,m_pFlame[l1].rotz*9);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
//	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
}

cFireTorch::DrawSparks()
{
	int l1;
	//sparks
	glBindTexture(GL_TEXTURE_2D, Sparkindex);
	glEnable(GL_BLEND);
	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	for (l1=0; l1<m_intNumSparks; l1++)
		m_pGfx_spark->draw(m_pSpark[l1].rotx,m_pSpark[l1].roty,m_pSpark[l1].rotz*9);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_BLEND);
//	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
}

cFireTorch::update(float time)
{
	angx+=time;
	angy+=3*time;
	angz+=2*time;
}

cFireTorch::Draw()
{
	glDisable(GL_CULL_FACE);
	glMatrixMode(GL_MODELVIEW);
	glColorMaterial(GL_FRONT,GL_AMBIENT);
	glLoadIdentity();

	/*
//	gluLookAt(cam[0],cam[1],cam[2],look[0],look[1],look[2],0,1,0);
	//printf("%f %f\n",look[0],look[1]);
	look[0]+=(mousex-mouseox)/5;
	look[1]+=(mousey-mouseoy)/5;
	look[2]=-100;
	//take my current coordinates
	//work out xyz angles based on angles between my pos and dest pos
	//those angles are my speed
/**
	float xdif,ydif,zdif;
	if (mouseb)
	{
		float r;
		if (mouseb==1) r=length3d(look[0],look[1],look[2],cam[0],cam[1],cam[2]);
			else r=-length3d(look[0],look[1],look[2],cam[0],cam[1],cam[2]);
		cam[0]+=(-cam[0]+look[0])/r;
		cam[1]+=(-cam[1]+look[1])/r;
		cam[2]+=(-cam[2]+look[2])/r;
	}
	if (fabs(mousex-mouseox)<2) mouseox=mousex;
	if (fabs(mousey-mouseoy)<2) mouseoy=mousey;
	gluLookAt(cam[0],cam[1],cam[2],
		look[0],look[1],look[2],
		0,1,0);
	glTranslatef(0,0,-30);

	//lb=move in direction currently facing
	//rb=move away from the direction currently facing
	//how to make facing?
	//rotate around X
	//rotate around Y
	//camx+=directionx
	//camy+=directiony
	//spherical mapping to calc XYZ
	//x = cos(theta) cos(phi)
	//y = cos(theta) sin(phi)
	//z = sin(theta) 
	//so i control phi and theta

	glutWireSphere(5,20,20);
	glutSolidCube(1);
*/
	
	glTranslatef(0,0,-2);
	glTranslatef(m_pFlame[0].rotx,m_pFlame[0].roty,m_pFlame[0].rotz);
	glColor3f(1,1,1);
	glRotatef(270,1.0f,0.0f,0.0f);
	glRotatef(angx/4,1.0f,0.0f,0.0f);
	glRotatef(angy/4,0.0f,1.0f,0.0f);
	glRotatef(angz/4,0.0f,0.0f,1.0f);
	glScalef(-1,-1,-1);
	//glutSolidCone(0.04,0.6,5,5);

	glDepthMask(GL_FALSE);
	UpdateFlame();
	//UpdateSpark();
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	DrawFire();
	//DrawSparks();
	//glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glDepthMask(GL_TRUE);
}
