// DLLInfoDlg.cpp : implementation file
//

#pragma warning( disable : 4786 )		// long names generated by STL

#include "stdafx.h"
#include "demopaja.h"
#include "DLLInfoDlg.h"
#include "FactoryC.h"
#include "ClassDescC.h"
#include "PajaTypes.h"
#include "HelpDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

using namespace PajaTypes;
using namespace PluginClass;


/////////////////////////////////////////////////////////////////////////////
// CDLLInfoDlg dialog


CDLLInfoDlg::CDLLInfoDlg(CWnd* pParent /*=NULL*/) :
	CDialog(CDLLInfoDlg::IDD, pParent),
	m_pApp( 0 )
{
	//{{AFX_DATA_INIT(CDLLInfoDlg)
	//}}AFX_DATA_INIT
}


void CDLLInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDLLInfoDlg)
	DDX_Control(pDX, IDC_EDIT_DLL, m_rEditDLL);
	DDX_Control(pDX, IDC_STATIC_DLL, m_rStaticDLL);
	DDX_Control(pDX, IDC_STATIC_AUTHOR, m_rStaticAuthor);
	DDX_Control(pDX, IDC_EDIT_AUTHOR, m_rEditAuthor);
	DDX_Control(pDX, IDC_STATIC_URL, m_rStaticUrl);
	DDX_Control(pDX, IDC_STATIC_NAME, m_rStaticName);
	DDX_Control(pDX, IDC_STATIC_DESC, m_rStaticDesc);
	DDX_Control(pDX, IDC_STATIC_COPY, m_rStaticCopy);
	DDX_Control(pDX, IDC_STATIC_CLASSTYPE, m_rStaticClassType);
	DDX_Control(pDX, IDC_STATIC_CLASSID, m_rStaticClassID);
	DDX_Control(pDX, IDC_EDIT_CLASSID, m_rEditClassID);
	DDX_Control(pDX, IDC_COMBO_CLASSLIST, m_rComboClassList);
	DDX_Control(pDX, IDC_EDIT_URL, m_rEditUrl);
	DDX_Control(pDX, IDC_EDIT_NAME, m_rEditName);
	DDX_Control(pDX, IDC_EDIT_DESC, m_rEditDesc);
	DDX_Control(pDX, IDC_EDIT_COPYRIGHT, m_rEditCopyright);
	DDX_Control(pDX, IDC_EDIT_CLASSTYPE, m_rEditClassType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDLLInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CDLLInfoDlg)
	ON_BN_CLICKED(IDC_BUTTON_GO, OnButtonGo)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	ON_CBN_SELCHANGE(IDC_COMBO_CLASSLIST, OnSelchangeComboClasslist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDLLInfoDlg message handlers

BOOL CDLLInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_pApp = (CDemopajaApp*)AfxGetApp();
	ASSERT( m_pApp );

	FactoryC*		pFac = m_pApp->GetFactory();


	m_rFont.CreateFont( 14, 0, 0, 0, FW_BOLD, 0, 0, 0,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY,
		DEFAULT_PITCH | FF_DONTCARE,
		"arial" );

	m_rStaticAuthor.SetFont( &m_rFont );
	m_rStaticClassID.SetFont( &m_rFont );
	m_rStaticClassType.SetFont( &m_rFont );
	m_rStaticCopy.SetFont( &m_rFont );
	m_rStaticDesc.SetFont( &m_rFont );
	m_rStaticName.SetFont( &m_rFont );
	m_rStaticUrl.SetFont( &m_rFont );
	m_rStaticUrl.SetFont( &m_rFont );
	m_rStaticDLL.SetFont( &m_rFont );

	m_rComboClassList.ResetContent();

	for( uint32 i = 0; i < pFac->get_classdesc_count(); i++ ) {
		ClassDescC*	pDesc = pFac->get_classdesc( i );

		int	iIdx = m_rComboClassList.AddString( pDesc->get_name() );

		if( iIdx != CB_ERR )
			m_rComboClassList.SetItemData( iIdx, i );
	}


	m_rComboClassList.SetCurSel( 0 );
	OnSelchangeComboClasslist();
	
	return TRUE;
}

LONG CDLLInfoDlg::GetRegKey( HKEY key, LPCTSTR subkey, LPTSTR retdata )
{
	HKEY hkey;
	LONG retval = RegOpenKeyEx( key, subkey, 0, KEY_QUERY_VALUE, &hkey );

	if( retval == ERROR_SUCCESS ) {
		long datasize = MAX_PATH;
		TCHAR data[MAX_PATH];
		RegQueryValue( hkey, NULL, data, &datasize );
		lstrcpy( retdata,data );
		RegCloseKey( hkey );
	}

	return retval;
}

void CDLLInfoDlg::OnButtonGo() 
{
	TCHAR key[MAX_PATH + MAX_PATH];

	CString	sUrl;
	m_rEditUrl.GetWindowText( sUrl );

	// First try ShellExecute()
	HINSTANCE result = ShellExecute( NULL, _T("open"), sUrl, NULL,NULL, SW_SHOW );

	// If it failed, get the .htm regkey and lookup the program
	if( (UINT)result <= HINSTANCE_ERROR ) {
		if( GetRegKey( HKEY_CLASSES_ROOT, _T(".htm"), key ) == ERROR_SUCCESS ) {
			lstrcat( key, _T("\\shell\\open\\command") );

			if( GetRegKey( HKEY_CLASSES_ROOT, key, key ) == ERROR_SUCCESS ) {
				TCHAR*	pos;
				pos = _tcsstr( key, _T("\"%1\"") );
				if( pos == NULL ) {                     // No quotes found
					pos = _tcsstr( key, _T("%1") );      // Check for %1, without quotes 
					if( pos == NULL )                   // No parameter at all...
						pos = key + lstrlen( key ) - 1;
					else
						*pos = '\0';                   // Remove the parameter
				}
				else
					*pos = '\0';                       // Remove the parameter

				lstrcat( pos, _T(" ") );
				lstrcat( pos, sUrl );

				result = (HINSTANCE)WinExec( T2A( key ), SW_SHOW );
			}
		}
	}
}

void CDLLInfoDlg::OnButtonHelp() 
{
	CHelpDlg	rDlg;

	rDlg.m_sURL = m_sHelpUrl;

	TRACE( "Doing: %s\n", rDlg.m_sURL );

	rDlg.DoModal();
}

void CDLLInfoDlg::OnSelchangeComboClasslist() 
{
	int	iIdx = m_rComboClassList.GetCurSel();

	m_sHelpUrl = "";

	if( iIdx != CB_ERR ) {
		// update data
		int32	i32Index = m_rComboClassList.GetItemData( iIdx );

		FactoryC*	pFac = m_pApp->GetFactory();
		ClassDescC*	pDesc = pFac->get_classdesc( i32Index );

		if( pDesc ) {
			m_rEditName.SetWindowText( pDesc->get_name() );
			m_rEditDesc.SetWindowText( pDesc->get_desc() );
			m_rEditAuthor.SetWindowText( pDesc->get_author_name() );
			m_rEditCopyright.SetWindowText( pDesc->get_copyright_message() );

			switch( pDesc->get_classtype() ) {
			case CLASS_TYPE_EFFECT:
				m_rEditClassType.SetWindowText( "Effect" ); break;
			case CLASS_TYPE_FILEIMPORT:
				m_rEditClassType.SetWindowText( "File Import" ); break;
			case CLASS_TYPE_DEVICEDRIVER:
				m_rEditClassType.SetWindowText( "Device Driver" ); break;
			case CLASS_TYPE_FILEPROCEDURAL:
				m_rEditClassType.SetWindowText( "Procedural File" ); break;
			case CLASS_TYPE_INTERNAL:
				m_rEditClassType.SetWindowText( "Internal" ); break;
			default:
				m_rEditClassType.SetWindowText( "<Unknown>" ); break;
			}

			CString	sClassID;
			sClassID.Format( "(0x%08X, 0x%08X)", pDesc->get_class_id().get_class_a(), pDesc->get_class_id().get_class_b() );
			m_rEditClassID.SetWindowText( sClassID );

			m_rEditUrl.SetWindowText( pDesc->get_url() );

			m_rEditDLL.SetWindowText( pFac->get_classdesc_dll_name( i32Index ) );

			// Set the help URL
			if( strncmp( "res://", pDesc->get_help_filename(), 6 ) == 0 ) {
				m_sHelpUrl = "res://";
				m_sHelpUrl += m_pApp->GetPluginDir();
				m_sHelpUrl += pFac->get_classdesc_dll_name( i32Index );
				m_sHelpUrl += "/";
				m_sHelpUrl += (pDesc->get_help_filename() + 6);
			}
			else {
				m_sHelpUrl = m_pApp->GetPluginDir();
				m_sHelpUrl += pDesc->get_help_filename();
			}

		}
	}
}
