/*
 * NapLink EE printf example
 *
 * for use with Gustavo Scotti's psx2lib-1.0b
 *
 *
 * Copyright (c) Andrew Kieschnick.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author(s) may not be used to endorse or promote products 
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdlib.h>
#include <tamtypes.h>
#include <sifcmd.h>
#include <kernel.h>
#include <sifrpc.h>
#include <stdarg.h>

#define NPM_PUTS     0x01
#define RPC_NPM_USER 0x014d704e

static struct t_rpc_client_data cd;
static int rpcSema;
static int putsInited = 0;

static int putsInit(void)
{
    unsigned int i;
    struct t_sema sp;
    
    sp.init_count = 0;
    sp.max_count = 1;
    sp.option = 0;
    rpcSema = k_CreateSema(&sp);

    while(1) {
	if (sif_bind_rpc(&cd, RPC_NPM_USER, 0) < 0) {
	    while(1);
	}
	if (cd.server != 0) break;
	i = 0x10000;
	while(i--);
    }
    
    k_SignalSema(rpcSema);

    putsInited = 1;

    return 0;
}

static char putsBuff[512] __attribute__ ((aligned(16)));

int npmPuts(char *buffer)
{
    int i = strlen(buffer) + 1;
    int ret;

    if (!putsInited)
	putsInit();

    k_WaitSema(rpcSema);

    while(i > 0) {

	if (i >= 511) {
	    memcpy(putsBuff, buffer, 511);
	    putsBuff[511] = 0;
	    i -= 511;
	    buffer += 511;
	} else {
	    memcpy(putsBuff, buffer, i);
	    i = 0;
	}

	ret = sif_call_rpc(&cd, NPM_PUTS, 0, putsBuff, 512, putsBuff, 512, 0, 0);
	
	if (ret != 0)
	    break;
    }

    k_SignalSema(rpcSema);

    if (ret != 0)
	return ret;
    else
	return 1;
}

int npmPrintf(char *format, ...)
{
    static char buff[4096];
    va_list args;
    int rv;

    va_start(args, format);
    rv = vsnprintf(buff, 4096, format, args);
    npmPuts(buff);

    return rv;
}

int main()
{
    sif_rpc_init(0);

    npmPrintf("NapLink EE printf test\n");
    npmPrintf("ADK / Napalm 2001\n");

    while(1);
    return 0;
}
