#ifndef _DMA_H_
#define _DMA_H_


#include "defines.h"


//---------------------------------------------------------------------------
// CHCR Register - Channel Control Register
//---------------------------------------------------------------------------
#define DMA_SET_CHCR(WHICH,DIR,MOD,ASP,TTE,TIE,STR,TAG) \
    *WHICH = \
    ((uint32)(DIR)  << 0)       | \
    ((uint32)(MOD)  << 2)       | \
    ((uint32)(ASP)  << 4)       | \
    ((uint32)(TTE)  << 6)       | \
    ((uint32)(TIE)  << 7)       | \
    ((uint32)(STR)  << 8)       | \
    ((uint32)(TAG)  << 16)

#define DMA_WAIT(WHICH) \
    while((*WHICH) & (1<<8))

//---------------------------------------------------------------------------
// MADR Register - Transfer Address Register
//---------------------------------------------------------------------------
#define DMA_SET_MADR(WHICH,ADDR,SPR) \
    *WHICH = \
    ((uint32)(ADDR) << 0)       | \
    ((uint32)(SPR)  << 31)

//---------------------------------------------------------------------------
// TADR Register - Tag Address Register
//---------------------------------------------------------------------------
#define DMA_SET_TADR(WHICH,ADDR,SPR) \
    *WHICH = \
    ((uint32)(ADDR) << 0)       | \
    ((uint32)(SPR)  << 31)

//---------------------------------------------------------------------------
// QWC Register - Transfer Data Size Register
//---------------------------------------------------------------------------
#define DMA_SET_QWC(WHICH,SIZE) \
    *WHICH = (uint32)(SIZE)


#endif // _DMA_H_
