#------------------------------------------------------------------------
.text
.set noreorder
#------------------------------------------------------------------------


#define zero $0
#define at  $1
#define v0  $2
#define v1  $3
#define a0  $4
#define a1  $5
#define a2  $6
#define a3  $7
#define t0  $8
#define t1  $9
#define t2  $10
#define t3  $11
#define t4  $12
#define t5  $13
#define t6  $14
#define t7  $15
#define s0  $16
#define s1  $17
#define s2  $18
#define s3  $19
#define s4  $20
#define s5  $21
#define s6  $22
#define s7  $23
#define t8  $24
#define t9  $25
#define k0  $26
#define k1  $27
#define gp  $gp
#define sp  $sp
#define s8  $30
#define ra  $31
#define pc  $pc


#------------------------------------------------------------------------
# void gs_reset_dma();
#------------------------------------------------------------------------
                .globl gs_reset_dma
                .ent gs_reset_dma
gs_reset_dma:   sw          $0, 0x1000a080
                sw          $0, 0x1000a000
                sw          $0, 0x1000a030
                sw          $0, 0x1000a010
                sw          $0, 0x1000a050
                sw          $0, 0x1000a040
                li          $2, 0xff1f
                sw          $2, 0x1000e010
                sw          $0, 0x1000e000
                sw          $0, 0x1000e020
                sw          $0, 0x1000e030
                sw          $0, 0x1000e050
                sw          $0, 0x1000e040
                lw          $2, 0x1000e000
                ori         $3, $2, 1
                nop
                sw          $3, 0x1000e000
                nop
                jr          $31
                nop
                .end gs_reset_dma
#------------------------------------------------------------------------


#------------------------------------------------------------------------
# void gs_send_gif(void *packet_ptr, uint32 packet_size);
#------------------------------------------------------------------------
                .globl gs_send_gif
                .ent gs_send_gif
                .set noat
gs_send_gif:    li          $1, 0x1000A000
gs_send_gif.lp: lw          $2, 0x00($1)
                andi        $2, 0x100
                bnez        $2, gs_send_gif.lp
                nop
                sw          $5, 0x20($1)
                sw          $4, 0x10($1)
                ori         $5, $0, 0x101
                sw          $5, 0x00($1)
                jr          $31
                nop
                .set at
                .end gs_send_gif
#------------------------------------------------------------------------


#------------------------------------------------------------------------
# void gs_wait_gif();
#------------------------------------------------------------------------
                .globl gs_wait_gif
                .ent gs_wait_gif
                .set noat
gs_wait_gif:    li          $1, 0x1000A000
gs_wait_gif.lp: lw          $2, 0x00($1)
                andi        $2, 0x100
                bnez        $2, gs_wait_gif.lp
                nop
                jr          $31
                nop
                .set at
                .end gs_wait_gif
#------------------------------------------------------------------------


#------------------------------------------------------------------------
# void gs_reset(uint8 int_mode, uint8 ntsc_pal, uint8 field_mode);
#------------------------------------------------------------------------
                .globl gs_reset
                .ent gs_reset
gs_reset:       subu        $29, 8
                sb          $4, 0($29)
                sb          $5, 1($29)
                sb          $6, 2($29)
                li          $3, 0x12001000  # reset gs
                li          $2, 1<<9
                sd          $2, 0($3)
                sync.p
                nop
                li          $4, 0x0000FF00  # set imr
                ld          $2, 0($3)
                dsrl        $2, 16
                andi        $2, 0xFF
                li          $3, 0x71
                syscall
                nop
                lbu         $4, 0($29)       # set gs crt
                lbu         $5, 1($29)
                lbu         $6, 2($29)
                addu        $29, 8
                li          $3, 2
                syscall
                nop
                jr          $31
                nop
                .end gs_reset
#------------------------------------------------------------------------


#------------------------------------------------------------------------
# void gs_vsync(void);
#------------------------------------------------------------------------
                .globl gs_vsync
                .ent gs_vsync
gs_vsync:       li          $3, 0x12001000
                ld          $2, 0($3)
                ori         $2, 8
                sd          $2, 0($3)
gs_vsync.lp:    ld          $2, 0($3)
                andi        $2, 8
                beqz        $2, gs_vsync.lp
                nop
                jr          $31
                nop
                .end gs_vsync
#------------------------------------------------------------------------


#------------------------------------------------------------------------
# void gs_hsync(void);
#------------------------------------------------------------------------
                .globl gs_hsync
                .ent gs_hsync
gs_hsync:       li          $3, 0x12001000
                ld          $2, 0($3)
                ori         $2, 4
                sd          $2, 0($3)
gs_hsync.lp:    ld          $2, 0($3)
                andi        $2, 4
                beqz        $2, gs_hsync.lp
                nop
                jr          $31
                nop
                .end gs_hsync
#------------------------------------------------------------------------


#------------------------------------------------------------------------
# void gs_install_vrh(void *funct);
#------------------------------------------------------------------------
                .globl gs_install_vrh
                .ent gs_install_vrh
gs_install_vrh: di
                move    $5, $4              # install handler
                addiu   $4, $0, 2
                addiu   $6, $0, 0
                addiu   $3, $0, 16
                syscall
                addiu   $4, $0, 2           # enable it
                addiu   $3, $0, 20
                syscall
                jr          $31
                ei
                .end gs_install_vrh
#------------------------------------------------------------------------
