// general includes
#include <tamtypes.h>
#include <defines.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <kernel.h>

// npm lib includes
#include <pad.h>

// gs lib includes
#include <gs.h>

// local includes
#include "main.h"
#include "display.h"
#include "menu.h"
#include "icon.h"
#include "./gfx/gfx.h"



static char _display_thread_stack[4096] __attribute__ ((aligned(128)));

ICON display_ico __attribute__((aligned (16)));
int16 th_sprites;

int display_thread = -1;
int display_sema_data = -1;
int display_sema_vsync = -1;

char display_msg_text[3][30] __attribute__((aligned (16)));
uint8 display_msg_flgs = 0;
uint8 display_msg_pressed = 0;
uint8 display_msg_released = 0;



// init screen
void display_init(void)
{
    //GIF_DECLARE_PACKET(gif_buf, 16)
    struct thread_attr  thread;
    struct t_sema       sema;


    if(gs_detect_mode() == NTSC) {
        gs_init_vmode(DISPLAY_VMODE_NTSC);
        gs_set_viewport(640, 480);
    } else {
        gs_init_vmode(DISPLAY_VMODE_PAL);
    }
    gs_init_zbuff(PSMZ16S, 0);

    /*GIF_BEGIN_PACKET(gif_buf);
    GIF_ADD_TAG(gif_buf, 4, 1, 0, 0, 0);
    GIF_ADD_DATA(gif_buf, GS_PRIM, GS_PRIM_SPRITE);
    GIF_ADD_DATA(gif_buf, GS_RGBAQ, _GS_RGBAQ(100,100,255,128,0));
    GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2((0x800)<<4,(0x800)<<4,0));
    GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2((0x800+gs_vmode.width)<<4,(0x800+gs_vmode.height)<<4,0));
    GIF_SEND_PACKET(gif_buf);*/

    gs_finish();


    memset(&display_ico, 0, sizeof(display_ico));
    menu[0].pos = menu[0].pelpos = menu[0].entries = 0;
    menu[1].pos = menu[1].pelpos = menu[1].entries = 0;


    sema.init_count = 1;
    sema.max_count = 1;
    sema.option = 0;
    display_sema_data = k_CreateSema(&sema);

    sema.init_count = 0;
    sema.max_count = 1;
    sema.option = 0;
    display_sema_vsync = k_CreateSema(&sema);


    thread.func = (void*)_display_thread;
    thread.stack = (void*)_display_thread_stack;
    thread.stack_size = 4096;
    thread.initial_priority = 1;//20;
    thread.gp_reg = &_gp;
    display_thread = k_CreateThread(&thread);
    k_StartThread(display_thread, NULL);

    gs_install_vrh((void*)_display_vsync);
}


// force the display to be drawn
void display_draw(void)
{
    //gs_vsync();
    k_SignalSema(display_sema_vsync);
}


// our vsync interrupt handler
void _display_vsync(void)
{
    k_iSignalSema(display_sema_vsync);
}


// display message box
void display_message(char *txt, uint8 flags)
{
    uint8 no = 0;
    uint8 pos = 0;


    k_WaitSema(display_sema_data);
    display_msg_flgs = flags;
    display_msg_pressed = 0;
    display_msg_released = 0;
    display_msg_text[0][0] = 0;
    display_msg_text[1][0] = 0;
    display_msg_text[2][0] = 0;

    while(1) {
        if(*txt == 13) {
            display_msg_text[no][pos] = 0;
            no++; pos=0;
        }
        if(pos >= 29) {
            display_msg_text[no][29] = 0;
            no++; pos=0;
        }
        if(no > 2) break;
        display_msg_text[no][pos++] = *txt;

        if(*txt == 0) break;
        txt++;
    }

    _command |= COMMAND_MESSAGE;
    if(flags != 0) _command |= COMMAND_MESSAGE_INPUT;
    k_SignalSema(display_sema_data);
}


// thread which updates screen on every vsync interrupt
void _display_thread(void)
{
    uint16 icon_delay_cntr = 0;
    uint8 pad_delay_cntr[8] = {0,0,0,0,0,0,0,0};
    uint16 pad_value = 0;


    loop:
    k_WaitSema(display_sema_vsync);         // wait till vsync interrupt signals us
    k_FlushCache(0);

    gs_swap_screen();
    gs_clear_zbuff();

    //GS_SET_BGCOLOR(255,0,0);

    if(gs_vmode.ntsc_pal == NTSC) {
        if(gs_vmode.visible == 1)
            gs_ee2vram(gs_vmode.fbp_2 << 5, 0, 0, gfx_mockup + GFX_MOCKUP_WIDTH*(GFX_MOCKUP_HEIGHT-448)/2, GFX_MOCKUP_WIDTH, 448, PSMCT32);
        else
            gs_ee2vram(gs_vmode.fbp_1 << 5, 0, 0, gfx_mockup + GFX_MOCKUP_WIDTH*(GFX_MOCKUP_HEIGHT-448)/2, GFX_MOCKUP_WIDTH, 448, PSMCT32);
    } else {
        if(gs_vmode.visible == 1)
            gs_ee2vram(gs_vmode.fbp_2 << 5, 0, 0, gfx_mockup, GFX_MOCKUP_WIDTH, GFX_MOCKUP_HEIGHT, PSMCT32);
        else
            gs_ee2vram(gs_vmode.fbp_1 << 5, 0, 0, gfx_mockup, GFX_MOCKUP_WIDTH, GFX_MOCKUP_HEIGHT, PSMCT32);
    }

    k_WaitSema(display_sema_data);          // wait for main thread to give us access on his data



    // --- do pad movement ---
    pad_value = pad_read();
    switch(_command) {

    case COMMAND_NOP:
        if(pad_value & PADtriangle) {
            _command |= COMMAND_ICON_ZOOM;
        }
        else if(pad_value & PADx) {
            switch(menu_pos) {
            case 0: // copy
                if(menu_sel_dir == MENU_SEL_MC) {
                    _command_pos = menu[1].pos;
                    _command |= COMMAND_COPY_TO_MC;
                } else {
                    _command_pos = menu[0].pos;
                    _command |= COMMAND_COPY_TO_HOST;
                }
                break;

            case 1: // move
                if(menu_sel_dir == MENU_SEL_MC) {
                    _command_pos = menu[1].pos;
                    _command |= COMMAND_MOVE_TO_MC;
                } else {
                    _command_pos = menu[0].pos;
                    _command |= COMMAND_MOVE_TO_HOST;
                }
                break;

            case 2: // delete
                if(menu_sel_dir == MENU_SEL_MC) {
                    _command_pos = menu[1].pos;
                    _command |= COMMAND_DEL_HOST;
                } else {
                    _command_pos = menu[0].pos;
                    _command |= COMMAND_DEL_MC;
                }
                break;
            }
        }
        //else if(pad_value & PADcircle) {
            // not used yet
        //}
        else if((pad_value & PADsquare)&&(pad_delay_cntr[4]==0)) {
            pad_delay_cntr[4] = MCSWAP_DELAY_VALUE;
            _command |= COMMAND_SWAP_MCPORT;
            if(menu_sel == MENU_SEL_MC) _command |= COMMAND_ICON_CHANGED;
        }

        if(pad_delay_cntr[4] > 0) pad_delay_cntr[4]--;

    default:
        if(_command & COMMAND_MESSAGE) break;
        if(_command & COMMAND_MESSAGE_INPUT) break;


        // default left
        if((pad_value & PADleft)&&(pad_delay_cntr[0]==0)) {
            pad_delay_cntr[0] = HORIZ_CURSOR_DELAY_VALUE;
            if(menu_sel > MENU_SEL_MC) {
                menu_sel--;
                if(menu_sel != MENU_SEL_MENU) {
                    if(menu_sel_dir != MENU_SEL_HOST) icon_delay_cntr = ICON_DELAY_VALUE; // delay till next icon is loaded
                    menu_sel_dir = MENU_SEL_HOST;  // we point right
                }
            }
        } else if(pad_delay_cntr[0]>0) pad_delay_cntr[0]--;


        // default right
        if((pad_value & PADright)&&(pad_delay_cntr[1]==0)) {
            pad_delay_cntr[1] = HORIZ_CURSOR_DELAY_VALUE;
            if(menu_sel < MENU_SEL_HOST) {
                menu_sel++;
                if(menu_sel != MENU_SEL_MENU) {
                    if(menu_sel_dir != MENU_SEL_MC) icon_delay_cntr = ICON_DELAY_VALUE; // delay till next icon is loaded
                    menu_sel_dir = MENU_SEL_MC;  // we point left
                }
            }
        } else if(pad_delay_cntr[1]>0) pad_delay_cntr[1]--;


        // default up
        if((pad_value & PADup)&&(pad_delay_cntr[2]==0)) {
            pad_delay_cntr[2] = CURSOR_DELAY_VALUE;
            switch(menu_sel) {
            case MENU_SEL_MC:
                if(menu[0].pos > 0) {
                    menu[0].pos--;
                    if(menu[0].pos >= menu[0].entries) menu[0].pos = menu[0].entries;
                    icon_delay_cntr = ICON_DELAY_VALUE; // delay till next icon is loaded
                }
                break;

            case MENU_SEL_HOST:
                if(menu[1].pos > 0) {
                    menu[1].pos--;
                    if(menu[1].pos >= menu[1].entries) menu[1].pos = menu[1].entries;
                    icon_delay_cntr = ICON_DELAY_VALUE; // delay till next icon is loaded
                }
                break;

            default:  //MENU_SEL_MENU
                if(menu_pos > 0) menu_pos--;
            }
        } else if(pad_delay_cntr[2]>0) pad_delay_cntr[2]--;


        // default down
        if((pad_value & PADdown)&&(pad_delay_cntr[3]==0)) {
            pad_delay_cntr[3] = CURSOR_DELAY_VALUE;
            switch(menu_sel) {
            case MENU_SEL_MC:
                if(menu[0].pos < menu[0].entries-1) {
                    menu[0].pos++;
                    if(menu[0].pos >= menu[0].entries) menu[0].pos = menu[0].entries;
                    icon_delay_cntr = ICON_DELAY_VALUE; // delay till next icon is loaded
                }
                break;

            case MENU_SEL_HOST:
                if(menu[1].pos < menu[1].entries-1) {
                    menu[1].pos++;
                    if(menu[1].pos >= menu[1].entries) menu[1].pos = menu[1].entries;
                    icon_delay_cntr = ICON_DELAY_VALUE; // delay till next icon is loaded
                }
                break;

            default:  //MENU_SEL_MENU
                if(menu_pos < 2) menu_pos++;
            }
        } else if(pad_delay_cntr[3]>0) pad_delay_cntr[3]--;
    }


    // --- reload if needed and display small icon ---
    if(icon_delay_cntr > 0) {
        icon_delay_cntr--;
        display_ico.loaded = 0; // unload our icon
        if(icon_delay_cntr == 0) _command |= COMMAND_ICON_CHANGED;
    }

    icon_draw(1, &display_ico, gs_vmode.tbp, 0);


    // --- load sprites ---
    gs_tbuf_reset();
    th_sprites = gs_tbuf_load((void*)gfx_sprites, GFX_SPRITES_WIDTH, GFX_SPRITES_HEIGHT, PSMCT32, NULL, 0, 1);
    //gs_tbuf_draw_texture(0, 0, 0x8000, 0x1000, 0x1000, 1, th_sprites[0]);


    // --- draw menu ---
    menu_draw();


    // --- draw message box ---
    if((_command & COMMAND_MESSAGE)||(_command & COMMAND_MESSAGE_INPUT)) {
        gs_tbuf_draw_sprite(180,185, 0, 288,118, 0,160, 288,118, th_sprites, GS_PRIM_BLENDING);   // message box

        display_text(180+24,185+32, display_msg_text[0], 30, 1);
      display_text(180+24,185+32, display_msg_text[0], 30, 1);
        display_text(180+24,185+48, display_msg_text[1], 30, 1);
      display_text(180+24,185+48, display_msg_text[1], 30, 1);
        display_text(180+24,185+64, display_msg_text[2], 30, 1);
      display_text(180+24,185+64, display_msg_text[2], 30, 1);

        switch(display_msg_flgs) {
        case MSG_OK:
            if(display_msg_pressed&MSG_OK) {
                gs_tbuf_draw_sprite(180+112,185+66, 0, 56,32, 448,128, 56,32, th_sprites, GS_PRIM_BLENDING);
                gs_tbuf_draw_sprite(180+112+5,185+66+8, 0, 64,12, 288,128, 64,12, th_sprites, 0);
                if(!(pad_value & PADx)) _command &= (COMMAND_MESSAGE_INPUT ^ 0xFFFFFFFF);
            } else {
                gs_tbuf_draw_sprite(180+112,185+66, 0, 56,32, 384,128, 56,32, th_sprites, GS_PRIM_BLENDING);
                gs_tbuf_draw_sprite(180+112+3,185+66+6, 0, 64,12, 288,128, 64,12, th_sprites, 0);
                if(!(pad_value & PADx)) display_msg_released |= MSG_OK;
                else {
                    if(display_msg_released&MSG_OK) display_msg_pressed |= MSG_OK;
                }
            }
            break;

        case MSG_CANCEL:
            if(display_msg_pressed&MSG_CANCEL) {
                gs_tbuf_draw_sprite(180+112,185+66, 0, 56,32, 448,128, 56,32, th_sprites, GS_PRIM_BLENDING);
                gs_tbuf_draw_sprite(180+112+5,185+66+8, 0, 64,12, 288,140, 64,12, th_sprites, 0);
                if(!(pad_value & PADcircle)) _command &= (COMMAND_MESSAGE_INPUT ^ 0xFFFFFFFF);
            } else {
                gs_tbuf_draw_sprite(180+112,185+66, 0, 56,32, 384,128, 56,32, th_sprites, GS_PRIM_BLENDING);
                gs_tbuf_draw_sprite(180+112+3,185+66+6, 0, 64,12, 288,140, 64,12, th_sprites, 0);
                if(!(pad_value & PADcircle)) display_msg_released |= MSG_CANCEL;
                else {
                    if(display_msg_released&MSG_CANCEL) display_msg_pressed |= MSG_CANCEL;
                }
            }
            break;

        //case MSG_OK|MSG_CANCEL:
        //    break;
        default:
        }
    }


    // --- if selected then display huge icon ---
    if( _command & COMMAND_ICON_ZOOM ) {
        _command &= (COMMAND_ICON_ZOOM ^ 0xFFFFFFFF);
        icon_draw(0, &display_ico, gs_vmode.tbp, 1);
    }



    k_SignalSema(display_sema_data);        // finished

    gs_finish();
    //GS_SET_BGCOLOR(0,0,0);

    goto loop;
}


// note: u have to load font data first...
// th_sprites = gs_tbuf_load((void*)gfx_sprites, GFX_SPRITES_WIDTH, GFX_SPRITES_HEIGHT, PSMCT32, NULL, 0, 1);
void display_text(int16 x, int16 y, char *txt, uint8 max, uint8 font_num  /*, uint32 rgba*/)
{
    int16 sx,sy;
    int16 tx,ty;
    int16 tw,th;

    switch(font_num) {
    case 2: tw=32; th=32; sx=0; sy=0; break;
    case 1: tw=8;  th=16; sx=512; sy=0; break;
    default: tw=8; th=8; sx=512; sy=96; font_num=0;
    }

    while(*txt != 0) {
        if(max-- == 0) break;
        if((*txt >= 'A')&&(*txt <= 'O')) {tx=tw*(*txt-'A'+1); ty=th*2;}
        else if((*txt >= 'P')&&(*txt <= 'Z')) {tx=tw*(*txt-'P'); ty=th*3;}

        else if((*txt >= 'a')&&(*txt <= 'o')) {tx=tw*(*txt-'a'+1); ty=th*4;}
        else if((*txt >= 'p')&&(*txt <= 'z')) {tx=tw*(*txt-'p'); ty=th*5;}

        else if((*txt >= '0')&&(*txt <= '9')) {tx=tw*(*txt-'0'); ty=th*1;}

        else switch(*txt) {
            case '!': tx=tw*1; ty=th*0; break;
            case '"': tx=tw*2; ty=th*0; break;
            case '#': tx=tw*3; ty=th*0; break;
            case '$': tx=tw*4; ty=th*0; break;
            case '%': tx=tw*5; ty=th*0; break;
            case '&': tx=tw*6; ty=th*0; break;
            case '\'': tx=tw*7; ty=th*0; break;
            case '(': tx=tw*8; ty=th*0; break;
            case ')': tx=tw*9; ty=th*0; break;
            case '*': tx=tw*10; ty=th*0; break;
            case '+': tx=tw*11; ty=th*0; break;
            case '.': tx=tw*12; ty=th*0; break;
            case '-': tx=tw*13; ty=th*0; break;
            case ',': tx=tw*14; ty=th*0; break;
            case '/': tx=tw*15; ty=th*0; break;

            case ':': tx=tw*10; ty=th*1; break;
            case ';': tx=tw*11; ty=th*1; break;
            case '<': tx=tw*12; ty=th*1; break;
            case '=': tx=tw*13; ty=th*1; break;
            case '>': tx=tw*14; ty=th*1; break;
            case '?': tx=tw*15; ty=th*1; break;

            case '[': tx=tw*11; ty=th*3; break;
            case '\\': tx=tw*12; ty=th*3; break;
            case ']': tx=tw*13; ty=th*3; break;
            case '^': tx=tw*14; ty=th*3; break;
            case '_': tx=tw*15; ty=th*3; break;

            default: tx=ty=-1;
        }

        //if(tx>=0 && ty>=0) gs_tbuf_draw_sprite_mod(x, y, 0x0000, tw, th, (uint16)sx+tx, (uint16)sy+ty, tw, th, th_sprites, rgba, GS_PRIM_BLENDING);
        if(tx>=0 && ty>=0) gs_tbuf_draw_sprite(x, y, 0x0000, tw, th, (uint16)sx+tx, (uint16)sy+ty, tw, th, th_sprites, GS_PRIM_BLENDING);
        x+=tw;
        txt++;
    }
}
