#ifndef _DISPLAY_H_
#define _DISPLAY_H_


#define DISPLAY_VMODE_PAL   PAL_640_512_32
#define DISPLAY_VMODE_NTSC  NTSC_640_448_32

#define ICON_DELAY_VALUE 22
#define MCSWAP_DELAY_VALUE 18
#define CURSOR_DELAY_VALUE 7
#define HORIZ_CURSOR_DELAY_VALUE 11

#define MSG_OK      1
#define MSG_CANCEL  2


#include "icon.h"
extern ICON display_ico;
extern int16 th_sprites;

extern int display_thread;
extern int display_sema_data;
extern int display_sema_vsync;


extern void _display_vsync(void);
extern void _display_thread(void);

extern void display_init(void);
extern void display_draw(void);
extern void display_text(int16 x, int16 y, char *txt, uint8 max, uint8 font_num  /*, uint32 rgba*/);

extern void display_message(char *txt, uint8 flags);

#endif
