// global includes
#include <tamtypes.h>
#include <defines.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <kernel.h>

// npm lib includes
#include <fileio.h>

// gs lib includes
#include <gs.h>

// local includes
#include "main.h"
#include "icon.h"
#include "vu0.h"
#include "display.h"
#include "index.h"
#include "sjis.h"
#include "npm_libmc.h"



char load_buffer[ sizeof(ICON) ] __attribute__((aligned (128)));
GIF_DECLARE_PACKET(gif_buf, ICON_MAX_VERTEX*7+16)





void icon_draw(int8 alpha, ICON *ico, uint32 tbp, uint8 size)
{
  uint32 prim;
  uint32 pos_x, pos_y;
  unsigned u;
  uint32 key, key_next;
  float time;


  VU0_TRNSFRM_TABLE tt;
  VERTEX_I32 v[3], next;
  VERTEX_F32 n[3];
  int16 light[3];


  if(ico->loaded == 0) return;
  if(tbp) gs_ee2vram(tbp, 0, 0, (void*)ico->it.u, 128, 128, PSMCT16);

  if(ico->iah.num == 0 || ico->iah.length == 0 || ico->iah.ns == 0) {
    key = key_next = 0;
    time = 0;
    tt.tx = 0<<4;
    tt.ty = 0<<4;
    tt.tz = 0<<4;
  } else {

    key = ico->ia[ico->key_pos].shape;
    if(key >= ico->imh.nks) key = 0;
    key_next = ico->ia[ico->key_next].shape;
    if(key_next >= ico->imh.nks) key_next = 0;

    time = ico->time;

    tt.tx = 0; //ico->ia[ico->key_pos].key[ico->sub_pos][0]>>8;
    tt.ty = 0; //ico->ia[ico->key_pos].key[ico->sub_pos][1]>>8;
    tt.tz = 0; //ico->ia[ico->key_pos].key[ico->sub_pos][2]>>8;

    if(size == 0) ico->time += ico->iah.speed/(ico->ia[ico->key_pos].nkf+1)/3;
    if(ico->time >= 1.0) {
      while(ico->time >= 1.0) ico->time -= 1.0;

      //ico->sub_pos++;
      //if(ico->sub_pos >= ico->ia[ico->key_pos].nkf) {
      //  ico->sub_pos = 0;
        ico->key_pos = ico->key_next;
        ico->key_next++;
        if(ico->key_next >= ico->iah.ns) ico->key_next = 0;
      //}
    }
  }

  tt.alpha = ico->alpha; //ico->alpha += alpha;
  tt.beta = ico->beta;     ico->beta  += alpha;
  tt.gamma = ico->gamma; //ico->gamma += alpha;
  if(size == 0) {   //small?
    prim = GS_PRIM_TRI|GS_PRIM_TEXTURE|GS_PRIM_TEXT_UV|GS_PRIM_FOGGING|GS_PRIM_BLENDING; //|GS_PRIM_ANTIALIAS|GS_PRIM_GOURAUD
    pos_x = ICON_SMALL_X_POS;
    pos_y = ICON_SMALL_Y_POS;
    tt.sx = tt.sy = tt.sz = ICON_SMALL_SCALE;
  } else {  //huge?
    prim = GS_PRIM_TRI|GS_PRIM_TEXTURE|GS_PRIM_TEXT_UV|GS_PRIM_FOGGING;  //|GS_PRIM_GOURAUD
    pos_x = ICON_HUGE_X_POS;
    pos_y = ICON_HUGE_Y_POS;
    tt.sx = tt.sy = tt.sz = ICON_HUGE_SCALE;

    // hide screen below
    GIF_BEGIN_PACKET(gif_buf);
    GIF_ADD_TAG(gif_buf, 1, 1, 0, 0, 0);
    GIF_ADD_DATA(gif_buf, GS_TEST_1, (3<<16)|(15<<0));  // zbuf off

    for(u=0; u<480; u++) {
      GIF_ADD_TAG(gif_buf, 4, 1, 0, 0, 0);
      GIF_ADD_DATA(gif_buf, GS_PRIM, GS_PRIM_LINE|GS_PRIM_BLENDING);
      GIF_ADD_DATA(gif_buf, GS_RGBAQ, _GS_RGBAQ(0,0,0,(u&2)?112:80,0));
      GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2((0x800)<<4, (0x800+u)<<4, 0x0000));
      GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2((0x800+gs_vmode.width)<<4, (0x800+u)<<4, 0x0000));
    }

    GIF_ADD_TAG(gif_buf, 1, 1, 0, 0, 0);
    GIF_ADD_DATA(gif_buf, GS_TEST_1, (5<<16)|(15<<0));  // zbuf on
    GIF_SEND_PACKET(gif_buf);
  }
  vu0_setup_gcc(&tt);

  GIF_BEGIN_PACKET(gif_buf);
  GIF_ADD_TAG(gif_buf, 4, 1, 0, 0, 0);
  GIF_ADD_DATA(gif_buf, GS_TEXFLUSH, 0);
  GIF_ADD_DATA(gif_buf, GS_FOGCOL, _GS_RGBAQ(0,0,0, 0,0));
  GIF_ADD_DATA(gif_buf, GS_TEX0_1, _GS_TEX0(tbp, gs_vmode.fbw, PSMCT16, 7, 7, 0, 1, 0,0,0,0,0));
  GIF_ADD_DATA(gif_buf, GS_ALPHA_1, ((1<<2)|(1<<4)|(1<<6)));      // blend with frame buffer alpha
  //GIF_ADD_DATA(gif_buf, GS_TEST_1, ((5<<16)|(3<<12)|(1<<0)));     // only update RGB (not A) inside frame buffer

  /*// draw texture
  GIF_ADD_TAG(gif_buf, 5, 1, 0, 0, 0);
  GIF_ADD_DATA(gif_buf, GS_PRIM, GS_PRIM_SPRITE|GS_PRIM_TEXTURE|GS_PRIM_TEXT_UV);
  //GIF_ADD_DATA(gif_buf, GS_RGBAQ, _GS_RGBAQ(128,128,128,128,0));
  GIF_ADD_DATA(gif_buf, GS_UV, _GS_UV(0,0));
  GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2(0x8000, 0x8000, 1));
  GIF_ADD_DATA(gif_buf, GS_UV, _GS_UV(0x800,0x800));
  GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2(0x8800, 0x8800, 1));
  */

  for(u=0; u<ico->imh.nv/3; u++) {


    // vertex #1
    v[0].x = ico->im[u*3+0].normal[0];
    v[0].y = ico->im[u*3+0].normal[1];
    v[0].z = ico->im[u*3+0].normal[2];
    vu0_normal_i12(&n[0], &v[0]);

    v[0].x = ico->im[u*3+0].vertex[key][0];
    v[0].y = ico->im[u*3+0].vertex[key][1];
    v[0].z = ico->im[u*3+0].vertex[key][2];
    next.x = ico->im[u*3+0].vertex[key_next][0];
    next.y = ico->im[u*3+0].vertex[key_next][1];
    next.z = ico->im[u*3+0].vertex[key_next][2];
    vu0_transform_ipol_i12(&v[0], &v[0], &next, time);


    // vertex #2
    v[1].x = ico->im[u*3+1].normal[0];
    v[1].y = ico->im[u*3+1].normal[1];
    v[1].z = ico->im[u*3+1].normal[2];
    vu0_normal_i12(&n[1], &v[1]);

    v[1].x = ico->im[u*3+1].vertex[key][0];
    v[1].y = ico->im[u*3+1].vertex[key][1];
    v[1].z = ico->im[u*3+1].vertex[key][2];
    next.x = ico->im[u*3+1].vertex[key_next][0];
    next.y = ico->im[u*3+1].vertex[key_next][1];
    next.z = ico->im[u*3+1].vertex[key_next][2];
    vu0_transform_ipol_i12(&v[1], &v[1], &next, time);


    // vertex #3
    v[2].x = ico->im[u*3+2].normal[0];
    v[2].y = ico->im[u*3+2].normal[1];
    v[2].z = ico->im[u*3+2].normal[2];
    vu0_normal_i12(&n[2], &v[2]);

    v[2].x = ico->im[u*3+2].vertex[key][0];
    v[2].y = ico->im[u*3+2].vertex[key][1];
    v[2].z = ico->im[u*3+2].vertex[key][2];
    next.x = ico->im[u*3+2].vertex[key_next][0];
    next.y = ico->im[u*3+2].vertex[key_next][1];
    next.z = ico->im[u*3+2].vertex[key_next][2];
    vu0_transform_ipol_i12(&v[2], &v[2], &next, time);


    // calc light value from each vertex, range 0..255 with 0=dark and 255=bright
    // cos(angle) = normal_vector_z * light_vector(0,0,1), range= -1..+1
    //light[0] = (int32)(abs((n[0].z)*255)); if(light[0] > 255) light[0] = 255;
    //light[1] = (int32)(abs((n[1].z)*255)); if(light[1] > 255) light[1] = 255;
    //light[2] = (int32)(abs((n[2].z)*255)); if(light[2] > 255) light[2] = 255;

    light[0] = (int16)(127+abs((n[0].z)*128)); if(light[0] > 255) light[0] = 255;
    light[1] = (int16)(127+abs((n[1].z)*128)); if(light[1] > 255) light[1] = 255;
    light[2] = (int16)(127+abs((n[2].z)*128)); if(light[2] > 255) light[2] = 255;

    // draw poly
    GIF_ADD_TAG(gif_buf, 7, 1, 0, 0, 0);
    GIF_ADD_DATA(gif_buf, GS_PRIM, prim);

    GIF_ADD_DATA(gif_buf, GS_UV, _GS_UV(ico->im[u*3+0].u>>1, ico->im[u*3+0].v>>1));
    //GIF_ADD_DATA(gif_buf, GS_RGBAQ, _GS_RGBAQ(light[0],light[0],light[0],128,0));
    GIF_ADD_DATA(gif_buf, GS_XYZF2, _GS_XYZF2(pos_x+v[0].x, pos_y+v[0].y, 0x8000-v[0].z, light[0]));

    GIF_ADD_DATA(gif_buf, GS_UV, _GS_UV(ico->im[u*3+1].u>>1, ico->im[u*3+1].v>>1));
    //GIF_ADD_DATA(gif_buf, GS_RGBAQ, _GS_RGBAQ(light[1],light[1],light[1],128,0));
    GIF_ADD_DATA(gif_buf, GS_XYZF2, _GS_XYZF2(pos_x+v[1].x, pos_y+v[1].y, 0x8000-v[1].z, light[1]));

    GIF_ADD_DATA(gif_buf, GS_UV, _GS_UV(ico->im[u*3+2].u>>1, ico->im[u*3+2].v>>1));
    //GIF_ADD_DATA(gif_buf, GS_RGBAQ, _GS_RGBAQ(light[2],light[2],light[2],128,0));
    GIF_ADD_DATA(gif_buf, GS_XYZF2, _GS_XYZF2(pos_x+v[2].x, pos_y+v[2].y, 0x8000-v[2].z, light[2]));


  }

  GIF_ADD_TAG(gif_buf, 1, 1, 0, 0, 0);
  GIF_ADD_DATA(gif_buf, GS_ALPHA_1, ((1<<2)|(1<<6)));
  //GIF_ADD_DATA(gif_buf, GS_TEST_1, ((5<<16)|(15<<0)));
  GIF_SEND_PACKET(gif_buf);
}





int icon_load_sys(char *name, ICON_SYS *is, int mc_port)
{
  char *c;
  int fh;
  ICON_SYS_FILE isf;
  INDEX_SUB_HEAD ih;


  k_WaitSema(display_sema_data);
  memset(is, 0, sizeof(ICON_SYS));
  k_SignalSema(display_sema_data);

  if(mc_port >= 0) {
    fh = _mc_open(mc_port, name, O_RDONLY);
    if(fh<0) return(-1);
    if(_mc_read(fh, &isf, sizeof(ICON_SYS_FILE)) < sizeof(ICON_SYS_FILE)) {
      _mc_close(fh);
      return(-2);
    }
    _mc_close(fh);
  } else {
    sprintf(load_buffer, FILENAME_INDEX_ENTRY, name);
    fh = npmOpen(load_buffer, O_RDONLY);
    if(fh<0) return(-1);
    if(npmRead(fh, &ih, sizeof(ih)) < sizeof(ih)) {
      npmClose(fh);
      return(-2);
    }
    if(ih.fofs_sys == 0) {
      npmClose(fh);
      return(-1);
    }
    npmLseek(fh, ih.fofs_sys, 0);
    if(npmRead(fh, &isf, sizeof(ICON_SYS_FILE)) < sizeof(ICON_SYS_FILE)) {
      npmClose(fh);
      return(-2);
    }
    npmClose(fh);
  }

  if(isf.id != 0x44325350) return(-3);

  if(isf.offs_2nd_title<68) {
    convertSJIStoASCII(is->title[1], (unsigned char*)isf.title +isf.offs_2nd_title,
      68-isf.offs_2nd_title);
    isf.title[isf.offs_2nd_title] = 0;
    convertSJIStoASCII(is->title[0],  (unsigned char*)isf.title, 68);
  } else {
    convertSJIStoASCII(is->title[0], (unsigned char*)isf.title, 68);
    is->title[1][0] = 0;
  }

  // convert unknown characters to underscores
  c=is->title[0]; while(*c!=0) {if(*c==(char)0xFF) *c='_'; c++;}
  c=is->title[1]; while(*c!=0) {if(*c==(char)0xFF) *c='_'; c++;}

  strncpy(is->icon[0], isf.ico_file[0], 64); is->icon[0][64] = 0;
  strncpy(is->icon[1], isf.ico_file[1], 64); is->icon[1][64] = 0;
  strncpy(is->icon[2], isf.ico_file[2], 64); is->icon[2][64] = 0;


  #ifdef _DEBUG
    printf("title1: \"%s\"\n", is->title[0]);
    printf("title2: \"%s\"\n", is->title[1]);
    printf("background:\n  alpha = 0x%02X\n", isf.bg_alpha);
    printf("  #1: color = 0x%02X%02X%02X\n", isf.bg_color[0].b, isf.bg_color[0].g, isf.bg_color[0].r);
    printf("  #2: color = 0x%02X%02X%02X\n", isf.bg_color[1].b, isf.bg_color[1].g, isf.bg_color[1].r);
    printf("  #3: color = 0x%02X%02X%02X\n", isf.bg_color[2].b, isf.bg_color[2].g, isf.bg_color[2].r);
    printf("  #4: color = 0x%02X%02X%02X\n", isf.bg_color[3].b, isf.bg_color[3].g, isf.bg_color[3].r);
    printf("light:\n");
    printf("  #1: color = 0x%02X%02X%02X  dir = %f,%f,%f\n", (int)(256*isf.light_color[0].b), (int)(256*isf.light_color[0].g), (int)(256*isf.light_color[0].r), (double)isf.light_dir[0].x, (double)isf.light_dir[0].y, (double)isf.light_dir[0].z );
    printf("  #2: color = 0x%02X%02X%02X  dir = %f,%f,%f\n", (int)(256*isf.light_color[1].b), (int)(256*isf.light_color[1].g), (int)(256*isf.light_color[1].r), (double)isf.light_dir[1].x, (double)isf.light_dir[1].y, (double)isf.light_dir[1].z );
    printf("  #3: color = 0x%02X%02X%02X  dir = %f,%f,%f\n", (int)(256*isf.light_color[2].b), (int)(256*isf.light_color[2].g), (int)(256*isf.light_color[2].r), (double)isf.light_dir[2].x, (double)isf.light_dir[2].y, (double)isf.light_dir[2].z );
    printf("ambient color: 0x%02X%02X%02X\n", (int)(256*isf.ambient_color.b), (int)(256*isf.ambient_color.g), (int)(256*isf.ambient_color.r) );
  #endif

  k_WaitSema(display_sema_data);
  is->loaded = 1;
  k_SignalSema(display_sema_data);
  return(0);
}





int icon_load(char *name, ICON *ico, int mc_port)
{
  int r;
  unsigned u,v;
  int fh, bsize;
  char *bptr;
  INDEX_SUB_HEAD ih;

  ICON_TEXTURE_HEAD *ith;  // used for compressed texture data
  ICON_TEXTURE *it;


  #ifdef _DEBUG
    printf("load buffer: ");
  #endif

  k_WaitSema(display_sema_data);
  memset(ico, 0, sizeof(ICON));
  k_SignalSema(display_sema_data);

  if(mc_port >= 0) {
    fh = _mc_open(mc_port, name, O_RDONLY);
    if(fh<0) return(-1);
    bsize = _mc_read(fh, &load_buffer, sizeof(load_buffer));
    _mc_close(fh);
  } else {
    sprintf(load_buffer, FILENAME_INDEX_ENTRY, name);
    fh = npmOpen(load_buffer, O_RDONLY);
    if(fh<0) return(-1);
    if(npmRead(fh, &ih, sizeof(ih)) < sizeof(ih)) {
      npmClose(fh);
      return(-2);
    }
    if(ih.fofs_ico == 0) {
      npmClose(fh);
      return(-1);
    }
    npmLseek(fh, ih.fofs_ico, 0);
    bsize = npmRead(fh, &load_buffer, sizeof(load_buffer));
    npmClose(fh);
  }
  bptr = (char*)&load_buffer;

  #ifdef _DEBUG
    printf("done\n");
  #endif

  // head
  if(bsize < sizeof(ICON_HEAD)) return(-2);
  memcpy(&ico->ih, bptr, sizeof(ICON_HEAD));
  bptr += sizeof(ICON_HEAD);
  bsize -= sizeof(ICON_HEAD);

  if(ico->ih.ver != 0x10000) return(-3);

  // model section
  if(bsize < sizeof(ICON_MODEL_HEAD)) return(-10);
  memcpy(&ico->imh, bptr, sizeof(ICON_MODEL_HEAD));
  bptr += sizeof(ICON_MODEL_HEAD);
  bsize -= sizeof(ICON_MODEL_HEAD);

  if(ico->imh.nks > ICON_MAX_NKS) return(-11);     // buffer overrun?
  if(ico->imh.nv > ICON_MAX_VERTEX) return(-12);   // buffer overrun?

  for(u=0; u<ico->imh.nv; u++) {  //read nv vertexes
    if(ico->imh.nks == 0) return(-13);
    if(bsize < (ico->imh.nks*8)) return(-14);
    memcpy(&ico->im[u].vertex, bptr, (ico->imh.nks*8));
    bptr += (ico->imh.nks*8);
    bsize -= (ico->imh.nks*8);

    if(bsize < (8+4+4)) return(-15);
    memcpy(&ico->im[u].normal, bptr, (8+4+4));
    bptr += (8+4+4);
    bsize -= (8+4+4);
  }

  // animation section
  if(bsize < sizeof(ICON_ANIMATION_HEAD)) return(-20);
  memcpy(&ico->iah, bptr, sizeof(ICON_ANIMATION_HEAD));
  bptr += sizeof(ICON_ANIMATION_HEAD);
  bsize -= sizeof(ICON_ANIMATION_HEAD);

  if(ico->iah.ns>ICON_MAX_ANIMATION) return(-21);   // buffer overrun?

  for(u=0; u<ico->iah.ns; u++) {  //read ns vertexes
    if(bsize < (2*4)) return(-22);
    memcpy(&ico->ia[u], bptr, (2*4));
    bptr += (2*4);
    bsize -= (2*4);

    if(ico->ia[u].nkf>0) {
      if(ico->ia[u].nkf>ICON_MAX_NKF) return(-23);  // buffer overrun?

      if(bsize < (ico->ia[u].nkf*8)) return(-24);
      memcpy(&ico->ia[u].key, bptr, (ico->ia[u].nkf*8));
      bptr += (ico->ia[u].nkf*8);
      bsize -= (ico->ia[u].nkf*8);
    }
  }

  // texture section
  if(ico->imh.attr & 8) {  // compressed texture (RLE aka PackBits)
    if(bsize < sizeof(ICON_TEXTURE_HEAD)) return(-30);
    ith = (ICON_TEXTURE_HEAD*)bptr;
    bptr += sizeof(ICON_TEXTURE_HEAD);
    bsize -= sizeof(ICON_TEXTURE_HEAD);

    if(ith->size > bsize) return(-31);   // buffer overrun?
    it = (ICON_TEXTURE*)bptr;
    bptr += ith->size;
    bsize -= ith->size;

    // decompress <it> to <ico->it>...
    memset(&ico->it, 0, sizeof(ICON_TEXTURE));
    ith->size = (ith->size+1)/2;
    for(u=v=0; u<ith->size;) {
      //printf("%04X\n", it->u[u]);
      if(it->s[u] < 0) {  // copy sequence

        r = (-it->s[u])+0;
        u++;
        for(; r>0; r--) {
          if(u>=ith->size) return(-34);
          if(v>=sizeof(ICON_TEXTURE)/2) return(-33);
          ico->it.u[v++] = it->u[u++];
        }

      } else {  // repeat sequence

        r = it->s[u]+0;
        u++;
        for(; r>0; r--) {
          if(v>=sizeof(ICON_TEXTURE)/2) return(-33);
          ico->it.u[v++] = it->u[u];
        }
        u++;

      }
    }

  } else {  // uncompressed 16bit texture

    if(bsize < sizeof(ICON_TEXTURE)) return(-40);
    memcpy(&ico->it, bptr, sizeof(ICON_TEXTURE));
    bptr += sizeof(ICON_TEXTURE);
    bsize -= sizeof(ICON_TEXTURE);

  }

  #ifdef _DEBUG
    printf("head: ver = 0x%X\n", ico->ih.ver);
    printf("model: nks = %u, attr = 0x%02X, bfcv = %f, nv = %u\n", ico->imh.nks, ico->imh.attr, (double)ico->imh.bfcv, ico->imh.nv);
    printf("animation: num = %u, length = %u, speed = %f, offs = 0x%X, ns = %u\n", ico->iah.num, ico->iah.length, (double)ico->iah.speed, ico->iah.offs, ico->iah.ns);
  #endif

  k_WaitSema(display_sema_data);
  ico->loaded = 1;
  k_SignalSema(display_sema_data);

  return(0);
}





/*int icon_unload(ICON *ico)
{
  k_WaitSema(display_sema_data);
  ico->loaded = 0;
  k_SignalSema(display_sema_data);
  return(0);
}*/