// general includes
#include <tamtypes.h>
#include <defines.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <kernel.h>

// npm lib includes
#include <sif.h>
#include <pad.h>
#include <loadmodule.h>
#include <fileio.h>

// gs lib includes
#include <gs.h>

// local includes
#include "main.h"
#include "icon.h"
#include "menu.h"
#include "index.h"
#include "display.h"
#include "npm_libmc.h"

// local defines



uint8 mc_port = 0;

char buf[512] __attribute__((aligned (128)));

static u_long128 padbuf1[16] __attribute__((aligned (128)));
static u_long128 padbuf2[16] __attribute__((aligned (128)));




int stricmp(const char *a, const char *b)
{
    while((*a != 0)&&(*b != 0)) {
        if(*a != *b) {
            if(*a >= 'A' && *a<='Z') {
                if(((*a)+'a'-'A') != *b) return(-1);
            } else if(*a >= 'a' && *a<='z') {
                if(((*a)+'A'-'a') != *b) return(-1);
            } else return(-1);
        }
        a++;
        b++;
    }
    return(0);
}



uint32 _command_pos = 0;
uint32 _command = COMMAND_ICON_CHANGED;  // use command_poll to retrieve this value from main thread

uint32 _command_poll(uint32 msk)
{
    uint32 cmd;

    k_WaitSema(display_sema_data);
    cmd = _command & msk;
    _command &= (msk ^ 0xFFFFFFFF);
    k_SignalSema(display_sema_data);

    return(cmd);
}

uint32 _command_get_pos()
{
    uint32 pos;

    k_WaitSema(display_sema_data);
    pos = _command_pos;
    k_SignalSema(display_sema_data);

    return(pos);
}



uint16 pad_read()
{
    uint16 pad_value;
    unsigned char pad_data[32];


    pad_value = 0;
    if(npmPadRead(1, 0, pad_data) >= 0) {
        if(pad_data[0] == 0) pad_value = (pad_data[3]|(pad_data[2]<<8)) ^ 0xffff;
    }
    if(npmPadRead(0, 0, pad_data) >= 0) {
	    if(pad_data[0] == 0) pad_value = (pad_data[3]|(pad_data[2]<<8)) ^ 0xffff;
    }

    if(pad_value == 0xffff) pad_value = 0;
    return(pad_value);
}



void do_error(int group, int rv)
{
    char *_buf = buf+7;


    sprintf(buf, "error: ");
    if((group == COMMAND_COPY_TO_HOST)||(group == COMMAND_COPY_TO_MC)) switch(rv) {

    case -1: sprintf(_buf, "savegame exists"); break;
    case -2: sprintf(_buf, "too many savegames"); break;
    case -3: sprintf(_buf, "savegame not found"); break;
    case -4: sprintf(_buf, "create file failed"); break;
    case -7: sprintf(_buf, "write index failed"); break;

    case -8: sprintf(_buf, "open file failed"); break;


    case -9:
    case -101:
    case -102:
    case -105:
    case -106:
    case -108:
    case -203:
    case -205:
        sprintf(_buf, "read savegame failed"); break;

    case -5:
    case -6:
    case -103:
    case -104:
    case -107:
    case -109:
    case -201:
    case -202:
    case -204:
    case -206:
    case -207:
        sprintf(_buf, "write savegame failed"); break;

    default: sprintf(_buf, "unknown (%i.%i)", group, -rv);

    } else if(group == COMMAND_DEL_HOST) switch(rv) {

    //case -1: sprintf(_buf, "savegame not found"); break;
    default: sprintf(_buf, "delete savegame failed");  //sprintf(_buf, "unknown (%i.%i)", group, -rv);

    } else if(group == COMMAND_DEL_MC) switch(rv) {

    default: sprintf(_buf, "delete savegame failed");

    } else {

        sprintf(_buf, "unknown (%i.%i)", group, -rv);

    }

    display_message(buf, MSG_OK);
}





int main()
{
    uint8 s;
    uint32 p;
    uint32 cmd;
    int rv;


    npmSifInitRpc(0);
    npmFsInit();
    mc_init();

    //npmSifLoadModule("rom0:SIO2MAN", 0, 0);  //allready done by mc init
    npmSifLoadModule("rom0:PADMAN", 0, 0);
    npmPadInit();
    npmPadPortOpen(0, 0, padbuf1);
    npmPadPortOpen(1, 0, padbuf2);

    display_init();



    // initial read root index
    rv = index_read();
    if(rv < 0) {
        dbgmsg(("error reading root index\n"));
    }



    while(1) {
        k_FlushCache(0);
        cmd = _command_poll(
            COMMAND_SWAP_MCPORT | COMMAND_ICON_CHANGED |
            COMMAND_COPY_TO_HOST | COMMAND_COPY_TO_MC |
            COMMAND_MOVE_TO_HOST | COMMAND_MOVE_TO_MC |
            COMMAND_DEL_HOST | COMMAND_DEL_MC |
            COMMAND_MESSAGE );


        // ---[ COMMAND_SWAP_MCPORT ]---

        if( cmd & COMMAND_SWAP_MCPORT ) {
            //k_WaitSema(display_sema_data);
            mc_port = mc_port ^ 1;
            //k_SignalSema(display_sema_data);

            menu_update(mc_port, 1);
        } else {
            menu_update(mc_port, 0);
        }


        // ---[ COMMAND_ICON_CHANGED ]---

        if( cmd & COMMAND_ICON_CHANGED ) {
            k_WaitSema(display_sema_data);
            display_ico.loaded = 0;
            s = menu_sel_dir; p=0;
            switch(s) {
            case MENU_SEL_HOST: p = menu[0].pos; break;
            case MENU_SEL_MC: p = menu[1].pos; break;
            }
            k_SignalSema(display_sema_data);

            switch(s) {
            case MENU_SEL_HOST:
                if((p < menu[0].entries)&&(menu[0].icon[ p ][0] != 0)) {
                    _mc_chdir(mc_port, menu[0].entry[ p ].filename);
                    icon_load(menu[0].icon[ p ], &display_ico, mc_port);
                    _mc_chdir(mc_port, "..");
                }
                break;
            case MENU_SEL_MC:
                if(p < menu[1].entries) {
                    icon_load(menu[1].entry[ p ].filename, &display_ico, -1);
                }
                break;
            }

            cmd = _command_poll(COMMAND_ICON_CHANGED);
        }


        // ---[ COMMAND_COPY_TO_HOST ]---

        if( cmd & COMMAND_COPY_TO_HOST ) {
            p = _command_get_pos();
            if((menu[0].entries > 0)&&(menu[0].entry[ p ].filename[0] != 0)) {
                sprintf(buf, "copy %s to host...", menu[0].entry[ p ].filename);
                display_message(buf, 0);

                rv = index_add(mc_port, menu[0].entry[ p ].filename, 0);
                if(rv < 0) do_error(COMMAND_COPY_TO_HOST, rv);
            }
            cmd = _command_poll(COMMAND_COPY_TO_HOST);
        }


        // ---[ COMMAND_COPY_TO_MC ]---

        if( cmd & COMMAND_COPY_TO_MC ) {
            p = _command_get_pos();
            if((menu[1].entries)&&(menu[1].entry[ p ].filename[0] != 0)) {
                sprintf(buf, "copy %s to mc%u...", menu[1].entry[ p ].filename, mc_port+1);
                display_message(buf, 0);

                rv = index_copy(mc_port, menu[1].entry[ p ].filename, 0);
                if(rv < 0) do_error(COMMAND_COPY_TO_MC, rv);
                else {
                    rv = menu_add_mc(mc_port, menu[1].entry[ p ].filename);
                    //if(rv < 0) do_error(xxx, rv);
                }
            }
            cmd = _command_poll(COMMAND_COPY_TO_MC);
        }


        // ---[ COMMAND_MOVE_TO_HOST ]---

        if( cmd & COMMAND_MOVE_TO_HOST ) {
            p = _command_get_pos();
            if((menu[0].entries > 0)&&(menu[0].entry[ p ].filename[0] != 0)) {
                sprintf(buf, "move %s to host...", menu[0].entry[ p ].filename);
                display_message(buf, 0);

                rv = index_add(mc_port, menu[0].entry[ p ].filename, 0);
                if(rv < 0) do_error(COMMAND_COPY_TO_HOST, rv);
                else {
                    rv = _mc_deltree(mc_port, menu[0].entry[ p ].filename);
                    if(rv < 0) do_error(COMMAND_DEL_MC, rv);
                    else {
                        rv = menu_del_mc(menu[0].entry[ p ].filename);
                        //if(rv < 0) do_error(xxx, rv);
                    }
                }
            }
            cmd = _command_poll(COMMAND_MOVE_TO_HOST);
        }


        // ---[ COMMAND_MOVE_TO_MC ]---

        if( cmd & COMMAND_MOVE_TO_MC ) {
            p = _command_get_pos();
            if((menu[1].entries)&&(menu[1].entry[ p ].filename[0] != 0)) {
                sprintf(buf, "move %s to mc%u...", menu[1].entry[ p ].filename, mc_port+1);
                display_message(buf, 0);

                rv = index_copy(mc_port, menu[1].entry[ p ].filename, 0);
                if(rv < 0) do_error(COMMAND_COPY_TO_MC, rv);
                else {
                    rv = menu_add_mc(mc_port, menu[1].entry[ p ].filename);
                    //if(rv < 0) do_error(xxx, rv); else {

                    rv = index_delete( menu[1].entry[ p ].filename );
                    if(rv < 0) do_error(COMMAND_DEL_HOST, rv);
                }
            }
            cmd = _command_poll(COMMAND_MOVE_TO_MC);
        }


        // ---[ COMMAND_DEL_HOST ]---

        if( cmd & COMMAND_DEL_HOST ) {
            p = _command_get_pos();
            sprintf(buf, "delete %s from host...", menu[1].entry[ p ].filename);
            display_message(buf, 0);

            rv = index_delete( menu[1].entry[ p ].filename );
            if(rv < 0) do_error(COMMAND_DEL_HOST, rv);
            cmd = _command_poll(COMMAND_DEL_HOST);
        }


        // ---[ COMMAND_DEL_MC ]---

        if( cmd & COMMAND_DEL_MC ) {
            p = _command_get_pos();
            sprintf(buf, "delete %s from mc%u...", menu[0].entry[ p ].filename, mc_port+1);
            display_message(buf, 0);

            rv = _mc_deltree(mc_port, menu[0].entry[ p ].filename);
            if(rv < 0) do_error(COMMAND_DEL_MC, rv);
            else {
                rv = menu_del_mc(menu[0].entry[ p ].filename);
                //if(rv < 0) do_error(xxx, rv);
            }
            cmd = _command_poll(COMMAND_DEL_MC);
        }
    }


    dbgmsg(("sleep\n"));
    k_SleepThread();
    return 0;
}
