#ifndef _MAIN_H_
#define _MAIN_H_


#include <defines.h>

#define MAX_FILENAME_SPACE 48
#define MAX_TITLE_SPACE 80


#define COMMAND_NOP              0
#define COMMAND_SWAP_MCPORT     (1<<0)
#define COMMAND_COPY_TO_HOST    (1<<1)
#define COMMAND_COPY_TO_MC      (1<<2)
#define COMMAND_MOVE_TO_HOST    (1<<3)
#define COMMAND_MOVE_TO_MC      (1<<4)
#define COMMAND_DEL_HOST        (1<<5)
#define COMMAND_DEL_MC          (1<<6)
#define COMMAND_ICON_CHANGED    (1<<7)
#define COMMAND_ICON_ZOOM       (1<<8)
#define COMMAND_MESSAGE         (1<<9)
#define COMMAND_MESSAGE_INPUT   (1<<10)

//#define _DEBUG
#ifdef _DEBUG
  #define dbgmsg(_x_) printf _x_ ;
#else
  #define dbgmsg(_x_)
#endif

extern void *_gp;

extern uint8 mc_port;

extern uint32 _command;    // use command_get/set to retrieve this value
extern uint32 _command_pos;
extern uint32 _command_poll(uint32 msk);

extern uint16 pad_read();
extern int stricmp(const char *a, const char *b);

#endif
