// general includes
#include <tamtypes.h>
#include <defines.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <kernel.h>

// npm lib includes
#include <sif.h>
#include <pad.h>
#include <loadmodule.h>
#include <fileio.h>

// gs lib includes
#include <gs.h>

// local includes
#include "main.h"
#include "menu.h"
#include "icon.h"
#include "index.h"
#include "display.h"
#include "npm_libmc.h"



uint8 menu_pos = 0;
uint8 menu_sel = MENU_SEL_HOST;
uint8 menu_sel_dir = MENU_SEL_MC;
MENU menu[2] __attribute__((aligned (16)));

mc_dirent dirent[MENU_MAX_ENTRIES] __attribute__((aligned (128)));


char _scrl_txt[] = "NPORT BY NAPALM - BETA 0.1 - TRANSFER SAVEGAMES BETWEEN MEMCARD AND HOST - ";

struct {
  char *ptr;
  uint16 mod;
} scrl = {_scrl_txt, 0};





int menu_add_mc(int port, char *filename)
{
    ICON_SYS is;
    uint32 j;
    int rv;


    for(j=0; j<menu[0].entries; j++) {
        if(stricmp(menu[0].entry[ j ].filename, filename) == 0) return(0);
    }

    if(menu[0].entries >= MENU_MAX_ENTRIES) return(-1);

    strncpy(menu[0].entry[ menu[0].entries ].filename, filename, MAX_FILENAME_SPACE);
    menu[0].entry[ menu[0].entries ].title[0][0] = 0;
    menu[0].entry[ menu[0].entries ].title[1][0] = 0;
    menu[0].icon[ menu[0].entries ][0] = 0;

    // load title
    _mc_getinfo(port, NULL, NULL);
    if(_mc_chdir(port, filename) < 0) return(-2);
    rv = icon_load_sys("icon.sys", &is, port);
    if((rv >= 0)&&(is.loaded != 0)) {

        strncpy(menu[0].entry[ menu[0].entries ].title[0], is.title[0], MAX_TITLE_SPACE);
        strncpy(menu[0].entry[ menu[0].entries ].title[1], is.title[1], MAX_TITLE_SPACE);
        strncpy(menu[0].icon[ menu[0].entries ], is.icon[0], MAX_FILENAME_SPACE);

        k_WaitSema(display_sema_data);
        menu[0].entries++;  // now it could get visible on calls to menu_draw()
        if(menu[0].pos >= menu[0].entries) menu[0].pos = menu[0].entries-1;
        k_SignalSema(display_sema_data);

    } else {  //otherwise corrupted data?

        strncpy(menu[0].entry[ menu[0].entries ].title[0], filename, MAX_TITLE_SPACE);
        //strncpy(menu[0].entry[ menu[0].entries ].title[1], is.title[1], MAX_TITLE_SPACE);
        //strncpy(menu[0].icon[ menu[0].entries ], is.icon[0], MAX_FILENAME_SPACE);

        k_WaitSema(display_sema_data);
        menu[0].entries++;  // now it could get visible on calls to menu_draw()
        if(menu[0].pos >= menu[0].entries) menu[0].pos = menu[0].entries-1;
        k_SignalSema(display_sema_data);

    }
    _mc_chdir(port, "..");

    return(0);
}


int menu_del_mc(char *filename)
{
    uint32 j;


    for(j=0; j<menu[0].entries; j++) {
        if(stricmp(menu[0].entry[ j ].filename, filename) == 0) {
            memcpy(&menu[0].entry[ j ], &menu[0].entry[ j+1 ], sizeof(MENU_ENTRY)*(MENU_MAX_ENTRIES-1-j));
            menu[0].entries--;
            if(menu[0].pos >= menu[0].entries) menu[0].pos = menu[0].entries-1;
            return(0);
        }
    }

    return(-1);
}



int menu_update(int port, uint8 force_update)
{
    int rv, type, free;
    uint32 i,j;


    // --- update host menu ---
    // index_root holds the host files
    k_WaitSema(display_sema_data);
    menu[1].entries = index_root.head.entries;
    memcpy(menu[1].entry, index_root.entry, sizeof(MENU_ENTRY)*menu[1].entries);
    if(menu[1].pos >= menu[1].entries) menu[1].pos = menu[1].entries-1;
    k_SignalSema(display_sema_data);

    // --- update memcard menu ---
    rv = _mc_getinfo(port, &type, &free);
    if((rv >= 0)&&(force_update == 0)) return(rv);

    // card swapped or update forced, reset menu #0
    k_WaitSema(display_sema_data);
    menu[0].entries = 0;
    menu[0].pos = 0;
    menu[0].pelpos = 0;
    if(menu_sel == MENU_SEL_MC) _command |= COMMAND_ICON_CHANGED;
    k_SignalSema(display_sema_data);

    if(rv < -1) return(rv);

    i = _mc_getdir(port, dirent, MENU_MAX_ENTRIES);
    for(j=0; j<i; j++) {
        dbgmsg(("%d: \"%s\", attr=0%Xh, size=%d\n", j+1, dirent[j].name, dirent[j].attr, dirent[j].size))

        if(dirent[j].name[0] == 0) goto next_one;
        if(dirent[j].name[0] == '.' && dirent[j].name[1] == 0) goto next_one;
        if(dirent[j].name[0] == '.' && dirent[j].name[1] == '.' && dirent[j].name[2] == 0) goto next_one;

        if((dirent[j].attr & MCATTR_SUBDIR) != 0)
        {
            menu_add_mc(port, dirent[j].name);
        } else {
            dbgmsg(("no subdir\n"))
        }

next_one:
    }
}



void menu_draw()
{
    GIF_DECLARE_PACKET(gif_buf, 16)
    char *chr=scrl.ptr;
    int32 ypos;
    uint32 u;



    // --- scroll menus ---
    if(menu[0].entries > 0) {
        ypos = menu[0].pos<<4;
        if((menu[0].pelpos) < (ypos-11*16)) menu[0].pelpos += 2;
        else if((menu[0].pelpos) > (ypos-3*16)) menu[0].pelpos -= 2;
        if((menu[0].pelpos) <  0                           ) menu[0].pelpos = 0;
        if((menu[0].pelpos) >= (menu[0].entries<<4)-(15*16)) menu[0].pelpos = (((menu[0].entries<<4)-(15*16)))-1;
    }

    if(menu[1].entries > 0) {
        ypos = menu[1].pos<<4;
        if((menu[1].pelpos) < (ypos-11*16)) menu[1].pelpos += 2;
        else if((menu[1].pelpos) > (ypos-3*16)) menu[1].pelpos -= 2;
        if((menu[1].pelpos) <  0                           ) menu[1].pelpos = 0;
        if((menu[1].pelpos) >= (menu[1].entries<<4)-(15*16)) menu[1].pelpos = (((menu[1].entries<<4)-(15*16)))-1;
    }




    // --- select new drawing params ---
    GIF_BEGIN_PACKET(gif_buf);
    GIF_ADD_TAG(gif_buf, 2, 1, 0, 0, 0);
    GIF_ADD_DATA(gif_buf, GS_ALPHA_1, ((1<<2)|(1<<4)|(1<<6)));      // blend with frame buffer alpha
    GIF_ADD_DATA(gif_buf, GS_TEST_1, (/*(5<<16)|*/(3<<12)|(1<<0)));     // only update RGB (not A) inside frame buffer


    // --- draw menu selectors ---
    if((menu_sel_dir == MENU_SEL_HOST)&&(menu[0].entries > 0)) {
        ypos = MENU_MC_YPOS+16*menu[0].pos-(menu[0].pelpos);
        if((ypos >= MENU_MC_YSTART)&&(ypos <= MENU_MC_YEND)) {
            GIF_ADD_TAG(gif_buf, 4, 1, 0, 0, 0);
            GIF_ADD_DATA(gif_buf, GS_PRIM, GS_PRIM_SPRITE|GS_PRIM_BLENDING);
            GIF_ADD_DATA(gif_buf, GS_RGBAQ, RGB_SELECT);
            GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2((0x800+16)<<4, (0x800+ypos)<<4, 0));
            GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2((0x800+280)<<4, (0x80F+ypos)<<4, 0));
        }
    } else if((menu_sel_dir == MENU_SEL_MC)&&(menu[1].entries > 0)) {
        ypos = MENU_MC_YPOS+16*menu[1].pos-(menu[1].pelpos);
        if((ypos >= MENU_MC_YSTART)&&(ypos <= MENU_MC_YEND)) {
            GIF_ADD_TAG(gif_buf, 4, 1, 0, 0, 0);
            GIF_ADD_DATA(gif_buf, GS_PRIM, GS_PRIM_SPRITE|GS_PRIM_BLENDING);
            GIF_ADD_DATA(gif_buf, GS_RGBAQ, RGB_SELECT);
            GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2((0x800+358)<<4, (0x800+ypos)<<4, 0));
            GIF_ADD_DATA(gif_buf, GS_XYZ2, _GS_XYZ2((0x800+625)<<4, (0x80F+ypos)<<4, 0));
        }
    }


    // --- select other drawing params and send whole package ---
    GIF_ADD_TAG(gif_buf, 1, 1, 0, 0, 0);
    GIF_ADD_DATA(gif_buf, GS_TEST_1, (/*(5<<16)|*/(15<<0)));
    GIF_SEND_PACKET(gif_buf);


    // --- draw small 2-line info text ---
    if((menu_sel_dir == MENU_SEL_HOST)&&(menu[0].entries > 0)) {
        if( menu[0].entry[ menu[0].pos ].title[0][0] != 0) {
            display_text(MENU_SMALL_INFO_XPOS, MENU_SMALL_INFO_YPOS+0, menu[0].entry[ menu[0].pos ].title[0], 32, 0);
            display_text(MENU_SMALL_INFO_XPOS, MENU_SMALL_INFO_YPOS+8, menu[0].entry[ menu[0].pos ].title[1], 32, 0);
        } else {
            display_text(MENU_SMALL_INFO_XPOS, MENU_SMALL_INFO_YPOS+0, menu[0].entry[ menu[0].pos ].filename, 32, 0);
        }
    } else if((menu_sel_dir == MENU_SEL_MC)&&(menu[1].entries > 0)) {
        if( menu[1].entry[ menu[1].pos ].title[0][0] != 0) {
            display_text(MENU_SMALL_INFO_XPOS, MENU_SMALL_INFO_YPOS+0, menu[1].entry[ menu[1].pos ].title[0], 32, 0);
            display_text(MENU_SMALL_INFO_XPOS, MENU_SMALL_INFO_YPOS+8, menu[1].entry[ menu[1].pos ].title[1], 32, 0);
        } else {
            display_text(MENU_SMALL_INFO_XPOS, MENU_SMALL_INFO_YPOS+0, menu[1].entry[ menu[1].pos ].filename, 32, 0);
        }
    }


    // --- draw mc menu ---
    for(u=0; u<menu[0].entries; u++) {
        ypos = MENU_MC_YPOS+16*u - (menu[0].pelpos);
        if((ypos >= MENU_MC_YSTART)&&(ypos <= MENU_MC_YEND)) {
            if(menu[0].entry[u].title[0][0] != 0) display_text(MENU_MC_XPOS, ypos, menu[0].entry[u].title[0], 32, 1);
            else display_text(MENU_MC_XPOS, ypos, menu[0].entry[u].filename, 32, 1);
        }
    }


    // --- draw host menu ---
    for(u=0; u<menu[1].entries; u++) {
        ypos = MENU_HOST_YPOS+16*u - (menu[1].pelpos);
        if((ypos >= MENU_HOST_YSTART)&&(ypos <= MENU_HOST_YEND)) {
            if(menu[1].entry[u].title[0][0] != 0) display_text(MENU_HOST_XPOS, ypos, menu[1].entry[u].title[0], 32, 1);
            else display_text(MENU_HOST_XPOS, ypos, menu[1].entry[u].filename, 32, 1);
        }
    }


    // --- draw scroller ---
    for(u=0; u<20; u++) {
        if(*chr == 0) chr = _scrl_txt;
        display_text(MENU_SCRL_XPOS+(u<<5)-(scrl.mod>>4), MENU_SCRL_YPOS, chr++, 1, 2);
    }

    scrl.mod+=28;
    if(scrl.mod >= (32<<4)) {
        scrl.mod -= (32<<4);
        scrl.ptr++;
        if(*scrl.ptr == 0) scrl.ptr = _scrl_txt;
    }


    // --- switch back to default drawing params ---
    GIF_BEGIN_PACKET(gif_buf);
    GIF_ADD_TAG(gif_buf, 1, 1, 0, 0, 0);
    GIF_ADD_DATA(gif_buf, GS_ALPHA_1, ((1<<2)|(1<<6)));
    GIF_SEND_PACKET(gif_buf);


    // --- draw titles MC1/MC2/MENU/HOST ---
    gs_tbuf_draw_sprite(296,120, 0, 56,32, 384,128, 56,32, th_sprites, GS_PRIM_BLENDING);
    if(mc_port == 0) {
        if(menu_sel == MENU_SEL_MC) gs_tbuf_draw_sprite_mod(99,115, 0, 128,12, 512,145, 128,12, th_sprites, RGB_SELECT, 0);   // memory card 1
        else gs_tbuf_draw_sprite(99,115, 0, 128,12, 512,145, 128,12, th_sprites, 0);
        if(menu_sel == MENU_SEL_MENU) gs_tbuf_draw_sprite_mod(296+7,120+6, 0, 128,12, 512,181, 128,12, th_sprites, RGB_SELECT, 0);   // M1-PC
        else gs_tbuf_draw_sprite(296+7,120+6, 0, 128,12, 512,181, 128,12, th_sprites, 0);
    } else {
        if(menu_sel == MENU_SEL_MC) gs_tbuf_draw_sprite_mod(99,115, 0, 128,12, 512,157, 128,12, th_sprites, RGB_SELECT, 0);   // memory card 2
        else gs_tbuf_draw_sprite(99,115, 0, 128,12, 512,157, 128,12, th_sprites, 0);
        if(menu_sel == MENU_SEL_MENU) gs_tbuf_draw_sprite_mod(296+7,120+6, 0, 128,12, 512,193, 128,12, th_sprites, RGB_SELECT, 0);   // M2-PC
        else gs_tbuf_draw_sprite(296+7,120+6, 0, 128,12, 512,193, 128,12, th_sprites, 0);
    }
    if(menu_sel == MENU_SEL_HOST) gs_tbuf_draw_sprite_mod(476,115, 0, 128,12, 512,169, 128,12, th_sprites, RGB_SELECT, 0);  // host
    else gs_tbuf_draw_sprite(476,115, 0, 128,12, 512,169, 128,12, th_sprites, 0);

    // --- draw direction arrow ---
    gs_tbuf_draw_sprite(296,160, 0, 56,32, 384,128, 56,32, th_sprites, GS_PRIM_BLENDING);
    if(menu_sel_dir <= MENU_SEL_MENU) {
        if(menu_sel == MENU_SEL_MENU) gs_tbuf_draw_sprite_mod(296+7,160+6, 0, 128,12, 512,217, 128,12, th_sprites, RGB_SELECT, 0);   // <-
        else gs_tbuf_draw_sprite(296+7,160+6, 0, 128,12, 512,217, 128,12, th_sprites, 0);
    }
    if(menu_sel_dir >= MENU_SEL_MENU) {
        if(menu_sel == MENU_SEL_MENU) gs_tbuf_draw_sprite_mod(296+7,160+6, 0, 128,12, 512,229, 128,12, th_sprites, RGB_SELECT, 0);   // ->
        else gs_tbuf_draw_sprite(296+7,160+6, 0, 128,12, 512,229, 128,12, th_sprites, 0);
    }

    // --- draw copy/move/delete buttons ---
    if(menu_pos == 0) {
        gs_tbuf_draw_sprite(296,240, 0, 56,32, 448,128, 56,32, th_sprites, GS_PRIM_BLENDING);
        gs_tbuf_draw_sprite(296+9,240+8, 0, 128,12, 512,241, 128,12, th_sprites, 0);
    } else {
        gs_tbuf_draw_sprite(296,240, 0, 56,32, 384,128, 56,32, th_sprites, GS_PRIM_BLENDING);
        gs_tbuf_draw_sprite(296+7,240+6, 0, 128,12, 512,241, 128,12, th_sprites, 0);
    }

    if(menu_pos == 1) {
        gs_tbuf_draw_sprite(296,280, 0, 56,32, 448,128, 56,32, th_sprites, GS_PRIM_BLENDING);
        gs_tbuf_draw_sprite(296+9,280+8, 0, 128,12, 512,253, 128,12, th_sprites, 0);
    } else {
        gs_tbuf_draw_sprite(296,280, 0, 56,32, 384,128, 56,32, th_sprites, GS_PRIM_BLENDING);
        gs_tbuf_draw_sprite(296+7,280+6, 0, 128,12, 512,253, 128,12, th_sprites, 0);
    }

    if(menu_pos == 2) {
        gs_tbuf_draw_sprite(296,320, 0, 56,32, 448,128, 56,32, th_sprites, GS_PRIM_BLENDING);
        gs_tbuf_draw_sprite(296+9,320+8, 0, 128,12, 512,265, 128,12, th_sprites, 0);
    } else {
        gs_tbuf_draw_sprite(296,320, 0, 56,32, 384,128, 56,32, th_sprites, GS_PRIM_BLENDING);
        gs_tbuf_draw_sprite(296+7,320+6, 0, 128,12, 512,265, 128,12, th_sprites, 0);
    }

    // --- draw sliders ---
    if(menu[0].entries > 0) {
        if(menu[0].entries <= 1) gs_tbuf_draw_sprite(274,144, 0, 24,32, 352,128, 24,32, th_sprites, GS_PRIM_BLENDING);   // left slider
        else gs_tbuf_draw_sprite(274,144 + (184*(menu[0].pos<<4))/((menu[0].entries<<4)-16), 0, 24,32, 352,128, 24,32, th_sprites, GS_PRIM_BLENDING);   // left slider
    }

    if(menu[1].entries > 0) {
        if(menu[1].entries <= 1) gs_tbuf_draw_sprite(618,144, 0, 24,32, 352,128, 24,32, th_sprites, GS_PRIM_BLENDING);   // right slider
        else gs_tbuf_draw_sprite(618,144 + (184*(menu[1].pos<<4))/((menu[1].entries<<4)-16), 0, 24,32, 352,128, 24,32, th_sprites, GS_PRIM_BLENDING);   // right slider
    }
}
