#ifndef _MENU_H_
#define _MENU_H_

#define RGB_SELECT _GS_RGBAQ(8,96,64,128, 0)


#define MENU_MAX_ENTRIES 1024

#define MENU_SEL_MC   0
#define MENU_SEL_MENU 1
#define MENU_SEL_HOST 2

#define MENU_SMALL_INFO_XPOS 88
#define MENU_SMALL_INFO_YPOS 72

#define MENU_SCRL_XPOS  16
#define MENU_SCRL_YPOS  408

#define MENU_MC_XPOS    (24)
#define MENU_MC_YSTART  (128-15)
#define MENU_MC_YPOS    (128)
#define MENU_MC_YEND    (128+15*16+15)

#define MENU_HOST_XPOS      (368)
#define MENU_HOST_YSTART    (128-15)
#define MENU_HOST_YPOS      (128)
#define MENU_HOST_YEND      (128+15*16+15)


#include "index.h"
typedef INDEX_ROOT_ENTRY MENU_ENTRY;


typedef struct {
    uint32 pos;
    int32  pelpos;
    uint32 entries;
    char icon[MENU_MAX_ENTRIES][MAX_FILENAME_SPACE];
    MENU_ENTRY entry[MENU_MAX_ENTRIES];
} MENU;

extern MENU menu[];

extern uint8 menu_pos;
extern uint8 menu_sel;
extern uint8 menu_sel_dir;

extern int menu_add_mc(int port, char *filename);
extern int menu_del_mc(char *filename);
extern int menu_update(int port, uint8 force_update);
extern void menu_draw();

#endif
