#include <tamtypes.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <kernel.h>
#include <sif.h>
#include <loadmodule.h>

#include "npm_libmc.h"

#ifndef NULL
#define NULL 0
#endif



#ifndef SIF_RPC_NOWAIT
#define SIF_RPC_NOWAIT 1
#endif

static char currentDir[1024] __attribute__ ((aligned(128)));
static int sif_param_Ord[16] __attribute__ ((aligned(128)));

static struct {
    int port, slot;
    int flags;
    int dummy0, dummy1;
    char name[1024];
} openBuf __attribute__ ((aligned(128)));

static struct {
    unsigned char fileInfo[32];
    char name[32];
} infoBuf __attribute__ ((aligned(128)));

static sif_client_t libmcCd __attribute__((aligned(16)));
static int mc_run_cmd_no = 0;
static int retval[0x40] __attribute__ ((aligned(128)));
static unsigned char sif_param_next[0xC0] __attribute__ ((aligned(128)));
static int *typePtr, *freePtr;

int mc_open(int port, int slot, const char *name, int mode)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (-100 + mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    strncpy(openBuf.name, name, 1024);
    openBuf.name[1023] = 0;

    openBuf.port = port;
    openBuf.slot = slot;
    openBuf.flags = mode;

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_OPEN, SIF_RPC_NOWAIT, &openBuf, 1024 + 0x14, retval, 4, 0, 0)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_OPEN;

    return (ret);
}

int mc_close(int fd)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (-100 + mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[0] = fd;
    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_CLOSE, SIF_RPC_NOWAIT, sif_param_Ord, 0x30, retval, 4, 0, 0)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_CLOSE;

    return (ret);
}

int mc_seek(int fd, int offset, int mode)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[0] = fd;
    sif_param_Ord[4] = offset;
    sif_param_Ord[5] = mode;

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_SEEK, SIF_RPC_NOWAIT, sif_param_Ord, 0x30, retval, 4, 0, 0)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_SEEK;

    return (ret);
}

int mc_write(int fd, void *buf, int size)
{
    int ret, i;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[0] = fd;

    if (size <= 16) {
	sif_param_Ord[3] = 0; /* number of bytes to copy from param 6 */
	sif_param_Ord[5] = size; /* number of bytes stored at param 8 */
	sif_param_Ord[6] = 0; /* ee address to copy from */
    } else {
	if ((int) buf & 0xf)
	    sif_param_Ord[5] = 16 - ((int) buf & 0xf);
	else
	    sif_param_Ord[5] = 0;
	sif_param_Ord[3] = size - sif_param_Ord[5];
	sif_param_Ord[6] = (int) buf + sif_param_Ord[5];
    }

    (int) buf |= 0x20000000;

    if (sif_param_Ord[5] != 0)
	for (i = 0; i < sif_param_Ord[5]; i++)
	    ((unsigned char *) &sif_param_Ord[8])[i] = ((unsigned char *) buf)[i];

    k_FlushCache(0);

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_WRITE, SIF_RPC_NOWAIT, sif_param_Ord, 0x30, retval, 4, NULL, NULL)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_WRITE;

    return (ret);
}

void mc_intr_read_fix_align(void *buf)
{
    int *b = (int *)((int) buf | 0x20000000);

    if (b[0] > 0)
	if (b[2])
	    memcpy((void *)b[2], &b[4], b[0]);

    if (b[1] > 0)
	if (b[3])
	    memcpy((void *)b[3], &b[8], b[1]);
}

int mc_read(int fd, void *buf, int size)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[0] = fd;
    sif_param_Ord[3] = size;
    sif_param_Ord[6] = (int) buf;
    sif_param_Ord[7] = (int) sif_param_next;

    npmSifWriteBackDCache(buf, size);

    npmSifWriteBackDCache(sif_param_next, 64);

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_READ, SIF_RPC_NOWAIT, sif_param_Ord, 0x30, retval, 4, mc_intr_read_fix_align, sif_param_next)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_READ;

    return (ret);
}

void mc_getinfo_cb(int *buf)
{
    (int) buf |= 0x20000000;

    if (typePtr != NULL)
	*typePtr = buf[0];

    if (freePtr != NULL)
	*freePtr = buf[1];
}

int mc_getinfo(int port, int slot, int *type, int *free)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[1] = port;
    sif_param_Ord[2] = slot;

    (void *) sif_param_Ord[7] = sif_param_next;

    if (type != NULL) {
	sif_param_Ord[3] = 1;
	typePtr = type;
    } else {
	sif_param_Ord[3] = 0;
	typePtr = NULL;
    }

    if (free != NULL) {
	sif_param_Ord[4] = 1;
	freePtr = free;
    } else {
	sif_param_Ord[4] = 0;
	freePtr = NULL;
    }

    npmSifWriteBackDCache(sif_param_next, 0x40);

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_GETINFO, SIF_RPC_NOWAIT, sif_param_Ord, 0x30, retval, 4, (npmSifEndFunc)mc_getinfo_cb, sif_param_next)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_GETINFO;

    return (ret);

}

int mc_flush(int fd)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[0] = fd;

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_FLUSH, SIF_RPC_NOWAIT, sif_param_Ord, 0x30, retval, 4, 0, 0)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_FLUSH;

    return (ret);
}

int mc_getdir(int port, int slot, const char *name, unsigned int mode, int maxent, mc_dirent * table)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    openBuf.port = port;
    openBuf.slot = slot;
    openBuf.flags = mode;
    openBuf.dummy0 = maxent;
    openBuf.dummy1 = (int) table;

    strncpy(openBuf.name, name, 1024);
    openBuf.name[1023] = 0;

    npmSifWriteBackDCache(table, maxent * 64);

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_GETDIR, SIF_RPC_NOWAIT, &openBuf, 1024 + 0x14, retval, 4, NULL, NULL)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_GETDIR;

    return (ret);
}

void mc_storepwd(void *buf)
{
    char *pwd;

    if (buf != NULL) {
	pwd = (char *) buf;
	strncpy(pwd, (char *) ((int) currentDir | 0x20000000), 1024);
	pwd[1023] = 0;
    }
}

int mc_chdir(int port, int slot, const char *path, char *pwd)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    openBuf.port = port;
    openBuf.slot = slot;
    openBuf.dummy1 = (int) currentDir;

    strncpy(openBuf.name, path, 1024);
    openBuf.name[1023] = 0;

    npmSifWriteBackDCache(currentDir, 1024);

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_CHDIR, SIF_RPC_NOWAIT, &openBuf, 1024 + 0x14, retval, 4, mc_storepwd, pwd)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_CHDIR;

    return (ret);
}

int mc_set_fileinfo(int port, int slot, const char *name, void *info, int flags)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    openBuf.port = port;
    openBuf.slot = slot;
    openBuf.flags = flags;

    strncpy(openBuf.name, name, 1024);
    openBuf.name[1023] = 0;

    memcpy(infoBuf.fileInfo, info, 0x40);

    openBuf.dummy1 = (int) &infoBuf;

    k_FlushCache(0);

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_SETINFO, SIF_RPC_NOWAIT, &openBuf, 1024 + 0x14, retval, 4, NULL, NULL)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_SETINFO;

    return (ret);
}

int mc_rename(int port, int slot, const char *oldName, const char *newName)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[1] = port;
    sif_param_Ord[2] = slot;
    sif_param_Ord[4] = (int) oldName;
    sif_param_Ord[5] = (int) newName;

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_RENAME, SIF_RPC_NOWAIT, sif_param_Ord, 48, retval, 4, NULL, NULL)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_RENAME;

    return (ret);
}

int mc_delete(int port, int slot, const char *name)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    openBuf.port = port;
    openBuf.slot = slot;
    openBuf.flags = 0;

    strncpy(openBuf.name, name, 1024);
    openBuf.name[1023] = 0;

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_DELETE, SIF_RPC_NOWAIT, &openBuf, 1024 + 0x14, retval, 4, NULL, NULL)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_DELETE;

    return (ret);
}

int mc_format(int port, int slot)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[1] = port;
    sif_param_Ord[2] = slot;

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_FORMAT, SIF_RPC_NOWAIT, sif_param_Ord, 0x30, retval, 4, 0, 0)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_FORMAT;

    return (ret);
}

int mc_unformat(int port, int slot)
{
    int ret;

    if (mc_run_cmd_no != 0)
	return (mc_run_cmd_no);

    if (libmcCd.serve == 0)
	return (-100);

    sif_param_Ord[1] = port;
    sif_param_Ord[2] = slot;

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_UNFORMAT, SIF_RPC_NOWAIT, sif_param_Ord, 0x30, retval, 4, 0, 0)) != 0)
	return (ret);

    mc_run_cmd_no = RPC_MCSERV_UNFORMAT;

    return (ret);
}

int mc_mkdir(int port, int slot, const char *name)
{
    int ret;

    if ((ret = mc_open(port, slot, name, 64)) == 0)
	mc_run_cmd_no = 11;

    return (ret);
}

int mc_init(void)
{
    int i, ret;


	if ((i  = npmSifLoadModule("rom0:SIO2MAN", 0, 0) < 0)) {} //return(-1);
	if ((i  = npmSifLoadModule("rom0:MCMAN", 0, 0) < 0)) {} //return(-1);
    if ((i  = npmSifLoadModule("rom0:MCSERV", 0, 0) < 0)) {} //return(-1);


    while (1) {
	if (npmSifBindRpc(&libmcCd, RPC_MCSERV, 0) < 0) {
        //return(-1);
	    while (1);
	}
	if (libmcCd.serve != 0)
	    break;
	i = 0x10000;
	while (i--);
    }

    sif_param_Ord[4] = 0xFFFFFF27;

    if ((ret = npmSifCallRpc(&libmcCd, RPC_MCSERV_INIT, 0, sif_param_Ord, 0x30, retval, 4, 0, 0)) <= 0)
	return (*retval);

    return (*retval - 100);
}

int mc_sync(int mode, int *cmd, int *result)
{
    int i, rpcstat;

    if (mc_run_cmd_no == 0)	// Return if idle
	return (-1);

    rpcstat = npmSifCheckStatRpc(&libmcCd.rpcd);

    if ((rpcstat != 0) && (mode == 0)) {
	while (npmSifCheckStatRpc(&libmcCd.rpcd) != 0)
	    for (i = 100000; i != 0; i--);

	rpcstat = 0;
    }

    if (cmd != NULL)
	*cmd = mc_run_cmd_no;

    if (rpcstat == 1)
	return (0);

    mc_run_cmd_no = 0;

    if (result != NULL)
	*result = *retval;

    return (1);
}





int _mc_getinfo(int port, int *type, int *free)
{
    int rv, result;
    int _type, _free;


    /*
    mc_getinfo

    0 means its the same card that was there at the last call
    -1 means its either the 1st call to getinfo, or the memcard has been switched
    -2 means its unformatted
    */

    if(type) *type = 0;
    if(free) *free = 0;

    rv = mc_getinfo(port, 0, &_type, &_free);
    if(rv == 0) {
        mc_sync(0, 0, &result);
        //printf("mc_getinfo()\n  result is %d\n", result);
        //printf("  type = %d\n", _type);
        //printf("  free = %d\n", _free);
        if(type) *type = _type;
        if(free) *free = _free;
        return(result);
    } else {
        return(rv-100);
    }
}

int _mc_chdir(int port, const char *name)
{
    int rv, result;


    rv = mc_chdir(port, 0, name, 0);
    if(rv == 0) {
        mc_sync(0, 0, &result);
        return(result);
    } else {
        return(rv-100);
    }
}

int _mc_mkdir(int port, const char *name)
{
    int rv, result;


    rv = mc_mkdir(port, 0, name);
    if(rv == 0) {
        mc_sync(0, 0, &result);
        return(result);
    } else {
        return(rv-100);
    }
}

int _mc_open(int port, const char *name, int mode)
{
    int rv, result;


    rv = mc_open(port, 0, name, mode);
    if(rv == 0) {
        mc_sync(0, 0, &result);
        return(result);
    } else {
        return(rv-100);
    }
}

int _mc_read(int fd, void *buff, int size)
{
    int rv, result;


    rv = mc_read(fd, buff, size);
    if(rv == 0) {
        mc_sync(0, 0, &result);
        return(result);
    } else {
        return(rv-100);
    }
}

int _mc_write(int fd, void *buff, int size)
{
    int rv, result;


    rv = mc_write(fd, buff, size);
    if(rv == 0) {
        mc_sync(0, 0, &result);
        return(result);
    } else {
        return(rv-100);
    }
}

int _mc_close(int fd)
{
    int rv, result;


    rv = mc_close(fd);
    if(rv == 0) {
        mc_sync(0, 0, &result);
        return(result);
    } else {
        return(rv-100);
    }
}

int _mc_getdir(int port, mc_dirent *dir, int entries)
{
    int rv, result;


    /*
    mc_getdir

    name could be ur id, eg. "BESCES-50008*" for yabasic
    sync_result = number of file-entries
    */

    rv = mc_getdir(port, 0, "*", 0, entries, dir);
    if(rv == 0) {
        mc_sync(0, 0, &result);
	    return(result);
    } else {
	    return(rv-100);
	}
}

int _mc_delete(int port, const char *name)
{
    int rv, result;


    //printf("\"%s\"\n", name);
    rv = mc_delete(port, 0, name);
    if(rv == 0) {
        mc_sync(0, 0, &result);
	    return(result);
    } else {
	    return(rv-100);
	}
}

int _mc_deltree(int port, const char *name)
{
    mc_dirent dirent[256];
    int rv, i, j;


    //printf("[%s]\n", name);
    if(_mc_chdir(port, name) >= 0) {
        i = _mc_getdir(port, dirent, 256);
        for(j=0; j<i; j++) {
            if((dirent[j].attr & MCATTR_SUBDIR) == 0) _mc_delete(port, dirent[j].name);
            else {
                if(dirent[j].name[0] == 0) goto next_one;
                if(dirent[j].name[0] == '.' && dirent[j].name[1] == 0) goto next_one;
                if(dirent[j].name[0] == '.' && dirent[j].name[1] == '.' && dirent[j].name[2] == 0) goto next_one;

                _mc_deltree(port, dirent[j].name);
next_one:
            }
        }
        _mc_chdir(port, "..");
    }

    rv = _mc_delete(port, name);
    return(rv);
}
