
////////////////////////////////////////////////////////////////////////////////
//
// FlapTro - a slightly average demo, which really needs the AWESOME CatFlap prg
//
// By Airia of Napalm!  Dec98
//
// CatFlap is a really SWEET comms prog for PAR/Caetla, if you haven't got it
// you oughtta!
//
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////

#include "Headers.h"


////////////////////////////////////////////////////////////////////////////////
// Defines
////////////////////////////////////////////////////////////////////////////////

#define	START_AS_NTSC				1

#define	OTSIZE						8

#define	SIZEOF_PRIMSPACE			0x4000

#define	SCREEN0_TLX					0
#define	SCREEN0_TLY					0

#define	SCREEN1_TLX					512
#define	SCREEN1_TLY					0

#define	PALETTE_BACKDROP			0
#define	PALETTE_DEFAULT				1

#define	OTPRI_LOWEST				(OTSIZE-1)
#define	OTPRI_HIGHEST				0
#define	OTPRI_STATUS				OTPRI_HIGHEST


#define	PC_KEYBOARD					0x80010000
#define	ARGUMENTS					0x80010004


////////////////////////////////////////////////////////////////////////////////

int   _ramsize = 0x00200000;		// 2MB for normal PSX
int _stacksize = 0x00002800;

////////////////////////////////////////////////////////////////////////////////

// We need to be able to see our assets file from the .asm source

extern assets;


#define	HUNK(w,x,y,z) ((z<<24)|(y<<16)|(x<<8)|(w))

struct PKX_Texture *MyTextures[256];

struct PKX_Texture *ConTextures[9];

int Num_Textures=0;


struct PKX_Binary *BackTim=NULL;


typedef struct Tim_FileHead {
	long	ID;
	long	Flag;
};

typedef struct Tim_ClutHead {
	long	bnum;
	short	dx,dy;
	short	w,h;
};

typedef struct Tim_DataHead {
	long	bnum;
	short	dx,dy;
	short	w,h;
};


////////////////////////////////////////////////////////////////////////////////

#define	NUM_BOBS	48

typedef struct Bob {
	int	x;
	int	y;
	int	xsin;
	int	ysin;
	int	xstep;
	int	ystep;
	int	anim;
	int	animstep;
};

struct Bob Bobs[NUM_BOBS];

struct PKX_Texture *MyBobs[16];

int	Num_Bobs=0;


////////////////////////////////////////////////////////////////////////////////

unsigned long	*Main_Primspace;						// dynamic ptr to graphic primitives
unsigned long	*Main_OT;								// ptr to current ordering table

typedef struct {
	DRAWENV			draw;								// drawing environment
	DISPENV			disp;								// display environment
	unsigned long	ot[OTSIZE];							// ordering table
	unsigned long	primspace[SIZEOF_PRIMSPACE];		// graphic primitive space
} DB;

DB		db[2];											// double buffer

DB		*Main_DB;										// ptr to current double buffer

int		Main_Raster=0;									// incremented in the VB callback
int		Main_Cycles=0;									// incremented in the display loop

#if		(START_AS_NTSC)
short	Main_DisplayMode=MODE_NTSC;						// current display mode, either MODE_PAL or MODE_NTSC
short	Main_DisplayHertz=60;							// current display mode, 50 or 60 Hz
#else
short	Main_DisplayMode=MODE_PAL;						// current display mode, either MODE_PAL or MODE_NTSC
short	Main_DisplayHertz=50;							// current display mode, 50 or 60 Hz
#endif
short	Main_DisplayWidth=512;							// current display width
short	Main_DisplayHeight=256;							// current display height

unsigned long	Main_DisplayR=0;						// current RGB setting for backdrop (which is automatically
unsigned long	Main_DisplayG=0;						// cleared by PutDrawEnv()
unsigned long	Main_DisplayB=80;

unsigned char PcKey;

short	*SinTab;


////////////////////////////////////////////////////////////////////////////////
// The VERTICAL BLANK CALLBACK
////////////////////////////////////////////////////////////////////////////////

void Main_vbCallback(void)
{
	Main_Raster++;
}


////////////////////////////////////////////////////////////////////////////////
// Our main() function
////////////////////////////////////////////////////////////////////////////////

void main()
{
	long *argv,argc;


// Init the PSX!

	Main_init();


// Check for arguments

	argv=(long *)ARGUMENTS;
	argc=*argv++;

	printf("# Args == %d\n",argc);

	if	( (argc>0) && (argc<=16) )
		{
		int a;
		for	(a=0;a<argc;a++)
			{
			printf("Argument %d is: %s\n",a,*argv++);
			}
		}


// Clear our 'keyboard' input to begin

	*((unsigned char *)PC_KEYBOARD)=0;

// Init the console...

	Main_InitConsole();

// Init the Bobs :)

	Main_InitBobs();


// Main loop...
										
	while(1)

		{

		Main_InitFrame();
		Main_Console();

		Main_SpriteFromAsset(256,Main_DisplayHeight-48,HUNK('L','O','G','O'),100);

		Main_DoBobs();

		Main_FancyLogo();

		Text_SetCursor(32,Main_DisplayHeight-48);
		Text_SetColor (0x00a0a0 | 0xff000000);
		Text_SetColor2(0x5020a0);

		prints("F1 toggles console\n");
		prints("Type HELP for info :)\n");

		Main_EndFrame();

		}
}



////////////////////////////////////////////////////////////////////////////////
// Initialise the PSX shell
////////////////////////////////////////////////////////////////////////////////


void Main_init(void)
{
	ResetCallback();

	ResetGraph(0);
	SetGraphDebug(0);

	Main_ClearVRAM(0,0,0);

	InitGeom();

	Main_SwapBuffer();
	Main_ResetFrame();

	Main_SetDisplay(Main_DisplayMode);

	SetDispMask(1);

	PCinit();

	DrawSync(0);
	VSync(0);
	VSyncCallback(&Main_vbCallback);	

	Main_SwapBuffer();
	Main_ResetFrame();
	Text_InitText(Main_OT);

	Main_SetupFont();
	Main_SetupAssets();
}


////////////////////////////////////////////////////////////////////////////////
// Swap the doublebuffer (logical)
////////////////////////////////////////////////////////////////////////////////

void Main_SwapLogical(void)
{
	Main_DB = (Main_DB==db)? db+1: db;	/* swap double buffer ID */
}


////////////////////////////////////////////////////////////////////////////////
// Swap the doublebuffer (full)
////////////////////////////////////////////////////////////////////////////////

void Main_SwapBuffer(void)
{
	Main_SwapLogical();

	PutDrawEnv(&Main_DB->draw);		/* update drawing environment */
	PutDispEnv(&Main_DB->disp);		/* update display environment */
}



////////////////////////////////////////////////////////////////////////////////
// Setup for the coming frame
////////////////////////////////////////////////////////////////////////////////


void Main_InitFrame(void)
{
	DrawSync(0);

	VSync(0);

	PutDrawEnv(&Main_DB->draw);		/* update drawing environment */
	PutDispEnv(&Main_DB->disp);		/* update display environment */

	Main_ShowBitmap();

	DrawOTag(Main_OT+OTSIZE-1);

	Main_SwapLogical();
	Main_ResetFrame();

	Main_Cycles++;
}


////////////////////////////////////////////////////////////////////////////////
// Complete the frame
////////////////////////////////////////////////////////////////////////////////

void Main_EndFrame(void)
{
	int	i,j;

	setRGB0(&db[0].draw, Main_DisplayR, Main_DisplayG, Main_DisplayB);
	setRGB0(&db[1].draw, Main_DisplayR, Main_DisplayG, Main_DisplayB);
}


////////////////////////////////////////////////////////////////////////////////
// Reset the frame
////////////////////////////////////////////////////////////////////////////////

void Main_ResetFrame(void)
{
	Main_OT = Main_DB->ot;
	ClearOTagR(Main_OT, OTSIZE);
	Main_Primspace = Main_DB->primspace;

	Text_InitText(Main_OT);
}



////////////////////////////////////////////////////////////////////////////////
// Setup Display parameters
////////////////////////////////////////////////////////////////////////////////

void Main_SetDisplay(long hertz)
{
	int	i;

	VSync(0);
	SetVideoMode(hertz);

	if	(hertz==MODE_NTSC)
		{
		Main_DisplayMode=MODE_NTSC;
		Main_DisplayHeight=256;
		Main_DisplayHertz=60;
		}
	else
		{
		Main_DisplayMode=MODE_PAL;
		Main_DisplayHeight=256;
		Main_DisplayHertz=50;
		}

		SetDefDrawEnv(&db[0].draw, SCREEN0_TLX, SCREEN0_TLY, \
									Main_DisplayWidth, Main_DisplayHeight);
		SetDefDrawEnv(&db[1].draw, SCREEN1_TLX, SCREEN1_TLY, \
									Main_DisplayWidth, Main_DisplayHeight);
		SetDefDispEnv(&db[1].disp, SCREEN0_TLX, SCREEN0_TLY, \
									Main_DisplayWidth, Main_DisplayHeight);
		SetDefDispEnv(&db[0].disp, SCREEN1_TLX, SCREEN1_TLY, \
									Main_DisplayWidth, Main_DisplayHeight);

		db[1].disp.screen.x = db[0].disp.screen.x = 0;

		if	(hertz==MODE_NTSC)
			db[1].disp.screen.y = db[0].disp.screen.y = 0;
		else
			db[1].disp.screen.y = db[0].disp.screen.y = 0;	//24;

		db[1].disp.screen.h = db[0].disp.screen.h = Main_DisplayHeight;


// Reset the double buffer structures

	for	(i=0;i<2;i++)
		{
		db[i].draw.isbg = 1;
		db[i].disp.isinter = 0;
		db[i].draw.dfe=0;
		db[i].draw.dtd=1;	//dithering off=0,on=1
		setRGB0(&db[i].draw, 0x0, 0x0, 0x0);
		ClearOTagR(db[i].ot, OTSIZE);
		}

}


////////////////////////////////////////////////////////////////////////////////
// Clear the VRAM
////////////////////////////////////////////////////////////////////////////////

void Main_ClearVRAM(int r, int g, int b)
{
        RECT                    vram;
        DRAWENV                 draw_env;
        LINE_F2                 line;

        /* Clear VRAM using ClearImage (foes not clear 512th and 1024th lines. */
        vram.x = vram.y = 0;
        vram.w = 1023;
        vram.h = 511;
        ClearImage(&vram, 0, 0, 0);

        /* Set up the draw env. */
        SetDefDrawEnv(&draw_env, 0, 0, 1024, 512);
        draw_env.dfe = 1;                               /* Allow drawing while VRAM is being displayed. */
        draw_env.isbg = 0;                              /* Don't clear the background. */
        PutDrawEnv(&draw_env);

        /* Init and draw lines to clear the rest of VRAM (i.e. 512th and 1024th	lines). */
        SetLineF2(&line);
        setRGB0(&line, 0, 0, 0);
        setXY2(&line, 0, 511, 1023, 511);
        DrawPrim(&line);                                                /* Clear 512th line of VRAM. */
        setXY2(&line, 1023, 0, 1023, 511);
        DrawPrim(&line);                                                /* Clear 1024th line of VRAM. */

        /* Ensure VRAM is cleared before exit. */
        DrawSync(0);

        /* Set up an invalid drawing area. */
        SetDefDrawEnv(&draw_env, 1024, 512, 0, 0);
        PutDrawEnv(&draw_env);
}


////////////////////////////////////////////////////////////////////////////////
// Clear the screen buffers in VRAM
////////////////////////////////////////////////////////////////////////////////

void Main_ClearScreens(int r, int g, int b)
{
	RECT	rect[]=	{
					{SCREEN0_TLX,SCREEN0_TLY,Main_DisplayWidth,Main_DisplayHeight},
					{SCREEN1_TLX,SCREEN1_TLY,Main_DisplayWidth,Main_DisplayHeight}
					};
	ClearImage(&rect[0],r,g,b);
	ClearImage(&rect[1],r,g,b);
}




////////////////////////////////////////////////////////////////////////////////
// Look for an asset from a HUNK
////////////////////////////////////////////////////////////////////////////////

long *Main_FindAsset(long hunk)
{
	unsigned long *ass,id,len;

	ass=(unsigned long)&assets;

	while(*ass)
		{
		len=*(ass+1);
		id=*(ass+2);
		if	(id==hunk)
			return(ass);
		ass+=(len/4)+2;
		}
	return(0);
}



////////////////////////////////////////////////////////////////////////////////
// Setup the Font
////////////////////////////////////////////////////////////////////////////////

void Main_SetupFont(void)
{
	struct PKX_Texture *tex;
	long	*font;

	PSXFontInit fonts[]= {
	{ 0, 0, 0, NULL, 1, 7, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~", 0 },
	};

	font=Main_FindAsset(HUNK('F','O','N','T'));

	if	(!font)
		{
		printf("Error: unable to find font in the assets data!\n");
		while(1) {};
		}

	tex=(struct PKX_Texture *)(font+2);

	fonts[0].x=tex->x;
	fonts[0].y=tex->y;
	fonts[0].fontdata=((unsigned char *)tex)+sizeof(struct PKX_Texture);

	Text_SetupFont(&fonts[0]);
	DrawSync(0);
}


////////////////////////////////////////////////////////////////////////////////
// Setup the Assets
////////////////////////////////////////////////////////////////////////////////

void Main_SetupAssets(void)
{
	unsigned long *ass,hunk,id,len;
	struct Tim_FileHead *timhead;
	struct Tim_ClutHead *timclut;
	struct Tim_DataHead *timdata;

	ass=(unsigned long)&assets;

	Num_Textures=0;

	while(*ass)
		{
		hunk=*(ass+0);
		len=*(ass+1);

		switch(hunk)
			{
			case HUNK('T','E','X','!'):
				{
				MyTextures[Num_Textures]=(struct PKX_Texture *)((unsigned long *)ass+2);

				if	(MyTextures[Num_Textures]->id!=HUNK('F','O','N','T'))
					{
					timhead=(struct Tim_FileHead *)((unsigned char *)MyTextures[Num_Textures]+sizeof(struct PKX_Texture));
					timclut=(struct Tim_ClutHead *)((unsigned char *)timhead+sizeof(struct Tim_FileHead));

					if	(timhead->ID!=0x10)
						{
						printf("Non-TIM texture asset found: %c%c%c%c\n",(hunk>>24)&0xff,(hunk>>16)&0xff,(hunk>>8)&0xff,(hunk)&0xff);
						}
					else
						{
						if	( !(timhead->Flag&(1<<3)) && ((timhead->Flag&3)!=0) && ((timhead->Flag&3)!=1) )
							{
							printf("Invalid TIM texture asset (bad depth or no CLUT): %c%c%c%c\n",(hunk>>24)&0xff,(hunk>>16)&0xff,(hunk>>8)&0xff,(hunk)&0xff);
							}
						else
							{
							if	((timhead->Flag&3)==0)
								{
								MyTextures[Num_Textures]->clut=LoadClut((unsigned long *)timclut+sizeof(struct Tim_ClutHead)/4, 0, 511-Num_Textures);
								MyTextures[Num_Textures]->tpage=LoadTPage((unsigned long *)timclut+sizeof(struct Tim_ClutHead)/4+(16*2)/4+sizeof(struct Tim_DataHead)/4, 0, 3, MyTextures[Num_Textures]->x,MyTextures[Num_Textures]->y,MyTextures[Num_Textures]->w,MyTextures[Num_Textures]->h);
								MyTextures[Num_Textures]->x=(MyTextures[Num_Textures]->x%64)*4;
								Num_Textures++;
								}
							else
							if	((timhead->Flag&3)==1)
								{
								MyTextures[Num_Textures]->clut=LoadClut((unsigned long *)timclut+sizeof(struct Tim_ClutHead)/4, 0, 511-Num_Textures);
								MyTextures[Num_Textures]->tpage=LoadTPage((unsigned long *)timclut+sizeof(struct Tim_ClutHead)/4+(256*2)/4+sizeof(struct Tim_DataHead)/4, 1, 3, MyTextures[Num_Textures]->x,MyTextures[Num_Textures]->y,MyTextures[Num_Textures]->w,MyTextures[Num_Textures]->h);
								MyTextures[Num_Textures]->x=(MyTextures[Num_Textures]->x%64)*2;
								Num_Textures++;
								}
							}
						}
					}
				else
					{
					printf("Ignoring Font asset...\n");
					}
				}
			break;

			case HUNK('B','I','N','!'):
				{
// Don't do anything for generic binary assets
				}
			break;

			default:
				{
				printf("Unknown Hunk: %c%c%c%c\n",(hunk>>24)&0xff,(hunk>>16)&0xff,(hunk>>8)&0xff,(hunk)&0xff);
				}
			break;

			}

		ass+=(len/4)+2;
		}


// Fast-track pointers to our Console Gfx assets

	ConTextures[0]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','T','L','F'))+2);
	ConTextures[1]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','T','O','P'))+2);
	ConTextures[2]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','T','R','I'))+2);
	ConTextures[3]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','L','F','T'))+2);
	ConTextures[4]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','M','I','D'))+2);
	ConTextures[5]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','R','G','T'))+2);
	ConTextures[6]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','B','L','F'))+2);
	ConTextures[7]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','B','O','T'))+2);
	ConTextures[8]=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('$','B','R','I'))+2);

	SinTab=(short *)((long *)Main_FindAsset(HUNK('S','I','N','E'))+2+sizeof(struct PKX_Binary)/4);
	BackTim=(struct PKX_Binary *)((long *)Main_FindAsset(HUNK('B','A','C','K'))+2);

}


////////////////////////////////////////////////////////////////////////////////
// Print a sprite
////////////////////////////////////////////////////////////////////////////////

void Main_Sprite(int x,int y,struct PKX_Texture *tex,int percent)
{
	int	np;
	POLY_FT4 *poly;

	poly=(POLY_FT4 *)Main_Primspace;
	SetPolyFT4(poly);
	if	(percent<100)
		SetSemiTrans(poly, 1);
	else
		SetSemiTrans(poly, 0);
	SetShadeTex(poly, 0);
	poly->x0=poly->x2=x;
	poly->y0=poly->y1=y;
	poly->x1=poly->x3=x+tex->w;
	poly->y2=poly->y3=y+tex->h;
	poly->u0=poly->u2=tex->x;
	poly->v0=poly->v1=tex->y%256;
	poly->u1=poly->u3=poly->u0+tex->w;
	poly->v2=poly->v3=poly->v0+tex->h;
	poly->tpage=tex->tpage;
	poly->clut=tex->clut;
	if	(percent<100)
		{
		poly->r0=(0xff*percent)/100;
		poly->g0=(0xff*percent)/100;
		poly->b0=(0xff*percent)/100;
		}
	else
		{
		poly->r0=0x80;
		poly->g0=0x80;
		poly->b0=0x80;
		}
	AddPrim(&Main_OT[1],poly);
	Main_Primspace+=sizeof(POLY_FT4)/4;

}


////////////////////////////////////////////////////////////////////////////////
// Print a sprite from a HUNK ID
////////////////////////////////////////////////////////////////////////////////

void Main_SpriteFromAsset(int x,int y,long id,int percent)
{
	struct PKX_Texture *tex;
	POLY_FT4 *poly;

	tex=(struct PKX_Texture *)((long *)Main_FindAsset(id)+2);

	if	(!tex)	return;

	Main_Sprite(x,y,tex,percent);
}





////////////////////////////////////////////////////////////////////////////////
// Basic Console
////////////////////////////////////////////////////////////////////////////////

struct console_command
{
	char *name;
	long *value;
	int  (*func)(char *cmdline, struct console_command *command);
};

////////////////////////////////////////////////////////////////////////////////

int Con_Callback_Pal(char *cmdline, struct console_command *command)
{
	Main_SetDisplay(MODE_PAL);
}

int Con_Callback_Ntsc(char *cmdline, struct console_command *command)
{
	Main_SetDisplay(MODE_NTSC);
}


int Con_Callback_Help(char *cmdline, struct console_command *command)
{
	struct	console_command *cmdcur;

	printf("\nWelcome to the cool console facility offered by CatFlap!\n");
	printf("In this example program, the following commands are accepted\n");
	printf("by the console:\n\n");

	for	(cmdcur=ConsoleCommands;cmdcur->name;cmdcur++)
		{
		printf("[%s]",cmdcur->name);
		if	(cmdcur->value)
			printf(" = value");
		printf("\n");
		}
}


#define	GAP_MIN		1
#define	GAP_MAX		128

int Con_GapX=0;
int Con_GapY=0;

int Con_Callback_GapX(char *cmdline, struct console_command *command)
{
	int	i;

	if	((Con_GapX<GAP_MIN) || (Con_GapX>GAP_MAX))
		{
		printf("Invalid Value: \"%s\" must be in the range of %d -> %d\n",command->name,GAP_MIN,GAP_MAX);
		return;
		}

	for	(i=0;i<NUM_BOBS;i++)
		{
		Bobs[i].xsin=i*Con_GapX*32;
		}
}

int Con_Callback_GapY(char *cmdline, struct console_command *command)
{
	int	i;

	if	((Con_GapY<GAP_MIN) || (Con_GapY>GAP_MAX))
		{
		printf("Invalid Value: \"%s\" must be in the range of %d -> %d\n",command->name,GAP_MIN,GAP_MAX);
		return;
		}

	for	(i=0;i<NUM_BOBS;i++)
		{
		Bobs[i].ysin=i*Con_GapY*32;
		}
}


#define	STEP_MIN	1
#define	STEP_MAX	128

int Con_StepX=0;
int Con_StepY=0;

int Con_Callback_StepX(char *cmdline, struct console_command *command)
{
	int	i;

	if	((Con_StepX<STEP_MIN) || (Con_StepX>STEP_MAX))
		{
		printf("Invalid Value: \"%s\" must be in the range of %d -> %d\n",command->name,STEP_MIN,STEP_MAX);
		return;
		}

	for	(i=0;i<NUM_BOBS;i++)
		{
		Bobs[i].xstep=Con_StepX*32;
		}
}

int Con_Callback_StepY(char *cmdline, struct console_command *command)
{
	int	i;

	if	((Con_StepY<STEP_MIN) || (Con_StepY>STEP_MAX))
		{
		printf("Invalid Value: \"%s\" must be in the range of %d -> %d\n",command->name,STEP_MIN,STEP_MAX);
		return;
		}

	for	(i=0;i<NUM_BOBS;i++)
		{
		Bobs[i].ystep=Con_StepY*32;
		}
}


////////////////////////////////////////////////////////////////////////////////

struct console_command ConsoleCommands[] = {
	{	"help",			0,						&Con_Callback_Help	},
	{	"red",			&Main_DisplayR,			NULL	},
	{	"green",		&Main_DisplayG,			NULL	},
	{	"blue",			&Main_DisplayB,			NULL	},
	{	"pal",			0,						&Con_Callback_Pal		},
	{	"ntsc",			0,						&Con_Callback_Ntsc		},

	{	"x-gap",		&Con_GapX,				&Con_Callback_GapX		},
	{	"x-step",		&Con_StepX,				&Con_Callback_StepX		},
	{	"y-gap",		&Con_GapY,				&Con_Callback_GapY		},
	{	"y-step",		&Con_StepY,				&Con_Callback_StepY		},

	{	0,				0,						0		}
};

////////////////////////////////////////////////////////////////////////////////

#define	CONSOLE_CMDLEN		56
#define	CONSOLE_NUMHISTORY	16
#define	CONSOLE_HGT			8

int console_on=0;
int console_curhistory=0;
int console_curpos=0;
char history[CONSOLE_NUMHISTORY][CONSOLE_CMDLEN];



////////////////////////////////////////////////////////////////////////////////
// Init the console
////////////////////////////////////////////////////////////////////////////////

void Main_InitConsole(void)
{
	int i;
	console_on=0;
	console_curhistory=0;
	console_curpos=1;
	for	(i=0;i<CONSOLE_NUMHISTORY;i++)
		{
		history[i][0]=0;
		history[i][1]=0;
		history[i][2]=0;
		}
	history[console_curhistory][0]='>';
	history[console_curhistory][1]='*';
	history[console_curhistory][2]=0;
}


////////////////////////////////////////////////////////////////////////////////
// Called every main loop
////////////////////////////////////////////////////////////////////////////////

void Main_Console(void)
{

// Bit of a bodge :(  Dimensions of console (in 24x24 blocks)
static	int	conX=(512-(16*24))/2;
static	int	conY=-100;
static	int conW=16;
static	int conH=2;

static	int desX=(512-(16*24))/2;
static	int desY=-100;

	int dx,dy;
	int oldmode;


	oldmode=console_on;

	if	(*((unsigned char *)PC_KEYBOARD)!=0)
		{
		PcKey=*((unsigned char *)PC_KEYBOARD);
		Main_GotKey(PcKey);
		*((unsigned char *)PC_KEYBOARD)=0;
		}

	if	(oldmode!=console_on)
		{
		if	(console_on)
			{
			desY=32;
			}
		else
			{
			desY=-100;
			}
		}

	dy=(desY-conY)/4;
	if	( (dy>0) && (dy>8) )	dy=8;
	if	( (dy<0) && (dy<-8) )	dy=-8;
	conY+=dy;

	if	((conY+(conH*24))<0)	return;

	{
	POLY_G4 *conback;
	int t,y;

	Main_Sprite(conX,conY,ConTextures[0],100);
	Main_Sprite(conX+(24*(conW-1)),conY,ConTextures[2],100);
	Main_Sprite(conX,conY+(24*(conH-1)),ConTextures[6],100);
	Main_Sprite(conX+(24*(conW-1)),conY+(24*(conH-1)),ConTextures[8],100);

	for	(y=1;y<conH-1;y++)
		{
		Main_Sprite(conX,conY+(24*y),ConTextures[3],100);
		Main_Sprite(conX+(24*(conW-1)),conY+(24*y),ConTextures[5],100);
		for	(t=1;t<conW-1;t++)
			Main_Sprite(conX+(24*t),conY+(24*y),ConTextures[4],100);
		}

	for	(t=1;t<conW-1;t++)
		{
		Main_Sprite(conX+(24*t),conY,ConTextures[1],100);
		Main_Sprite(conX+(24*t),conY+(24*(conH-1)),ConTextures[7],100);
		}

	Text_SetColor(0xff60e060);
	Text_SetColor2(0x0108010);

	for	(t=0;t<((conH-1)*24/6);t++)
		{
		Text_SetCursor(conX+24,conY+4+(conH*24)-24-(t*6));
		prints((char *)&history[(console_curhistory-t)%CONSOLE_NUMHISTORY][0]);
		}
	}

// Sort of a cursor :)
	{
	char curs[]="/-\\|";
	history[console_curhistory][console_curpos]=curs[(Main_Raster>>1)&3];
	}	


}


////////////////////////////////////////////////////////////////////////////////
// Process a keypress
////////////////////////////////////////////////////////////////////////////////

void Main_GotKey(char key)
{

	if(key==0x81)					//F1==0x81
		{
// toggle console on/off
		console_on=!console_on;
		return;
		}

	if(console_on)
		{

		switch(key)
			{
			case 0x08:		// 0x08 == backspace
				{
				if	(console_curpos>1)
					{
					history[console_curhistory][--console_curpos]='*';
					history[console_curhistory][console_curpos+1]=0;
					}
				}
			break;

			case 0x0d:		// 0x0d == enter
				{
				struct	console_command *cmdcur;
				char	cmd[64],param[64];
				int		valid=1;

// Make sure we 0-terminate what the user has typed in
				history[console_curhistory][console_curpos]=0;

// Check syntax for either 'command' or 'variable=value'
				if(wsscanf(&history[console_curhistory][1]," %[^=]=%s ",&cmd[0],&param[0])!=2)
					{
					if(wsscanf(&history[console_curhistory][1]," %s ",&cmd[0],&param[0])!=1)
						{
						valid=0;
						}
					}

				if	(valid)
					{
					valid=0;

// Traverse the commands list and see if what we've got is something we know about
					for	(cmdcur=ConsoleCommands;cmdcur->name;cmdcur++)
						{
						int i;
						char a,b;
						i=0;
						while (cmd[i] && cmdcur->name[i])
							{
							a=tolower(cmd[i]);
							b=tolower(cmdcur->name[i]);
							if	(a!=b)
								{
								i=-1;
								break;
								}
							i++;
							}
						if	(i!=-1)
							{
							valid=1;
							break;
							}
						}

					}

				if(valid)
					{
					if(param[0] && cmdcur->value)
						*((long *)cmdcur->value)=atoi(param);
					if(cmdcur->func)
						cmdcur->func((char *)&history[console_curhistory][1],cmdcur);
					}
				else
					{
// Any unknown commands, send them out to PC-side :)

					printf("CMD:%s\n",(char *)&history[console_curhistory][1]);

// wait for ACK from CatFlap (not totally essential)
#if	0
					while(1)
						{
						VSync(2);
						if	(*((unsigned char *)PC_KEYBOARD)==0x0a)
							break;
						}
#endif
					}

				console_curhistory=(console_curhistory+1)%CONSOLE_NUMHISTORY;
				history[console_curhistory][0]='>';
				history[console_curhistory][1]='*';
				history[console_curhistory][2]=0;

				console_curpos=1;
				}
			break;

			default:
				{
				if	( (key>=32) && (key<=127) )
					{
					if	(console_curpos<CONSOLE_CMDLEN-3)
						{
						history[console_curhistory][console_curpos++]=key;
						history[console_curhistory][console_curpos+0]='*';
						history[console_curhistory][console_curpos+1]=0;
						}
					}
				}
			break;

			}

		}

}





////////////////////////////////////////////////////////////////////////////////
// Init de bobs (heh - takes me back to the old amiga days :) )
////////////////////////////////////////////////////////////////////////////////

void Main_InitBobs(void)
{
	unsigned long *ass,id,len;

	int	i;

	for	(i=0;i<NUM_BOBS;i++)
		{
		Bobs[i].xsin=i*440;
		Bobs[i].ysin=i*370;
		Bobs[i].xstep=85;
		Bobs[i].ystep=118;
		Bobs[i].anim=i*2;
		Bobs[i].animstep=2;
		}

	ass=(unsigned long)&assets;

// Scan for any frames with IDs of 'BOBx'

	while(*ass)
		{
		len=*(ass+1);
		id=*(ass+2);
		if	((id&HUNK(0xff,0xff,0xff,0))==HUNK('B','O','B',0))
			{
			MyBobs[Num_Bobs++]=(struct PKX_Texture *)(ass+2);
			}
		ass+=(len/4)+2;
		}
}


////////////////////////////////////////////////////////////////////////////////
// Handle the bobs situation
////////////////////////////////////////////////////////////////////////////////

void Main_DoBobs(void)
{
	int	i,b;
	short sx,sy,al;

	for	(i=NUM_BOBS-1;i>=0;i--)
		{
		b=(Bobs[i].anim>>7)%Num_Bobs;
		al=(*(SinTab+(((Bobs[i].anim<<6)+(i<<9))%16384))>>9)+32;
		sx=*(SinTab+(Bobs[i].xsin%16384))>>7;
		sy=*(SinTab+(Bobs[i].ysin%16384))>>8;
		Bobs[i].x=(Main_DisplayWidth/2)+sx-(MyBobs[b]->w/2);
		Bobs[i].y=(Main_DisplayHeight/2)+sy-(MyBobs[b]->h/2)+24;
		Bobs[i].xsin=(Bobs[i].xsin+Bobs[i].xstep)%16384;
		Bobs[i].ysin=(Bobs[i].ysin+Bobs[i].ystep)%16384;
		Bobs[i].anim=Bobs[i].anim+Bobs[i].animstep;
		Main_Sprite(Bobs[i].x,Bobs[i].y,MyBobs[b],al);
		}
}


////////////////////////////////////////////////////////////////////////////////
// Some lame siney logo thing
////////////////////////////////////////////////////////////////////////////////

void Main_FancyLogo(void)
{
	struct PKX_Texture *tex;
	int	x,y,s,sw,u,v;
	short y1,y2,y3,y4,al;
	short rc,gc,bc;
	POLY_FT4 *poly;

	al=(*(SinTab+((Main_Raster<<6)%16384))>>8)+128;
	if	(al>255)	al=255;

	tex=(struct PKX_Texture *)((long *)Main_FindAsset(HUNK('L','O','G','O'))+2);

	y=16;
	x=(Main_DisplayWidth-(tex->w*2))/2;

	u=tex->x;
	v=tex->y%256;

	s=0;
	sw=4;

	poly=(POLY_FT4 *)Main_Primspace;

	while(s<tex->w)
		{

// Wow, look at all these hellish sine calcs :)  Doh
// In fact, the whole thing is ill thought-out & inefficient ;)  10 mins hehe

#if	0
		y1=( ( (*(SinTab+(((Main_Raster+(s/4))<<6)%16384))>>9)+
			(*(SinTab+((((Main_Raster*5/2)+2000+(s*2/3))<<6)%16384))>>9) ) /2 ) +64+16;
		y2=( ( (*(SinTab+(((Main_Raster+1+(s/4))<<6)%16384))>>9)+
			(*(SinTab+((((Main_Raster*5/2)+1+2000+(s*2/3))<<6)%16384))>>9) ) /2 ) +64+16;
		y3=( ( (*(SinTab+(((Main_Raster+2048+(s/4))<<6)%16384))>>9)+
			(*(SinTab+((((Main_Raster*5/2)+2048+2000+(s*2/3))<<6)%16384))>>9) ) /2 ) +24+8;
		y4=( ( (*(SinTab+(((Main_Raster+2048+1+(s/4))<<6)%16384))>>9)+
			(*(SinTab+((((Main_Raster*5/2)+2048+1+2000+(s*2/3))<<6)%16384))>>9) ) /2 ) +24+8;
#else
		y1=( ( (*(SinTab+(((Main_Raster+(s/4))<<6)%16384))>>9)+
			(*(SinTab+((((Main_Raster*5/2)+2000+(s*2/3))<<6)%16384))>>9) ) /2 ) +64+16;
		y2=( ( (*(SinTab+(((Main_Raster+1+(s/4))<<6)%16384))>>9)+
			(*(SinTab+((((Main_Raster*5/2)+1+2000+(s*2/3))<<6)%16384))>>9) ) /2 ) +64+16;
		y3=( ( (*(SinTab+(((Main_Raster+7048+(s/4))<<6)%16384))>>9)+
			(*(SinTab+((((Main_Raster*6/2)+7048+2000+(s*2/3))<<6)%16384))>>9) ) /2 ) +32+8;
		y4=( ( (*(SinTab+(((Main_Raster+7048+1+(s/4))<<6)%16384))>>9)+
			(*(SinTab+((((Main_Raster*6/2)+7048+1+2000+(s*2/3))<<6)%16384))>>9) ) /2 ) +32+8;
#endif
		rc=(*(SinTab+((((Main_Raster*3/3)+(s<<1))<<6)%16384))>>8)+128;
		gc=(*(SinTab+((((Main_Raster*5/3)+(s<<1))<<6)%16384))>>8)+128;
		bc=(*(SinTab+((((Main_Raster*7/3)+(s<<1))<<6)%16384))>>8)+128;

		SetPolyFT4(poly);
		SetSemiTrans(poly,1);
		SetShadeTex(poly,0);
		poly->x0=poly->x2=x;
		poly->x1=poly->x3=x+(sw*2);
		poly->y0=y3;
		poly->y1=y4;
		poly->y2=y1;
		poly->y3=y2;

		poly->u0=poly->u2=u+s;

// Really nasty bodge :) cos we stretch the texture we end up with an extra line of crap on the right :(
		if	(s+sw>=tex->w)
			poly->u1=poly->u3=u+s+sw-1;
		else
			poly->u1=poly->u3=u+s+sw;

		poly->v0=poly->v1=v;
		poly->v2=poly->v3=v+tex->h;
		poly->r0=rc;
		poly->g0=gc;
		poly->b0=bc;
		poly->tpage=(tex->tpage)&(~(3<<5));
		poly->clut=tex->clut;
		AddPrim(&Main_OT[1],poly);
		poly++;
		s+=sw;
		x+=sw*2;
		}

	Main_Primspace=(unsigned long *)poly;
}


////////////////////////////////////////////////////////////////////////////////
// Dump the bitmap (16-bit TIM) straight to the screen
////////////////////////////////////////////////////////////////////////////////

void Main_ShowBitmap(void)
{
	RECT r;
	struct Tim_DataHead *tim;

	tim=(struct Tim_DataHead *)((unsigned char *)BackTim+sizeof(struct PKX_Binary)+sizeof(struct Tim_FileHead));
	r.w=tim->w;
	r.h=tim->h;

	if	(Main_DB!=db)
		{
		r.x=db[0].disp.disp.x;
		r.y=db[0].disp.disp.y;
		}
	else
		{
		r.x=db[1].disp.disp.x;
		r.y=db[1].disp.disp.y;
		}

	r.x+=(Main_DisplayWidth-r.w)/2;
	r.y+=(Main_DisplayHeight-r.h);

	LoadImage(&r,(unsigned long *)BackTim+sizeof(struct PKX_Binary)/4+((sizeof(struct Tim_FileHead)+sizeof(struct Tim_DataHead))/4));
	DrawSync(0);
}