#ifndef	_MAIN_H_
#define	_MAIN_H_

extern unsigned long	*Main_Primspace;
extern unsigned long	*Main_OT;
extern int				Main_Raster;
extern int				Main_Cycles;

extern short			Main_DisplayWidth;
extern short			Main_DisplayHeight;
extern short			Main_DisplayHertz;
extern short			Main_DisplayMode;
extern unsigned long	Main_DisplayR;
extern unsigned long	Main_DisplayG;
extern unsigned long	Main_DisplayB;

extern struct console_command ConsoleCommands[];


// C/C++ Function Prototypes

#ifdef	__cplusplus
extern "C" {
#endif

void			Main_init(void);

void			Main_SwapBuffer(void);
void			Main_InitFrame(void);
void			Main_EndFrame(void);
void			Main_ResetFrame(void);

void			Main_SetDisplay(long);
void			Main_ClearVRAM(int r, int g, int b);
void			Main_ClearScreens(int r, int g, int b);

long			*Main_FindAsset(long);
void			Main_SetupFont(void);
void			Main_SetupAssets(void);
void			Main_Sprite(int,int,struct PKX_Texture *,int);
void			Main_SpriteFromAsset(int,int,long,int);

void			Main_InitConsole(void);
void			Main_Console(void);
void			Main_GotKey(char key);

void			Main_InitBobs(void);
void			Main_DoBobs(void);
void			Main_FancyLogo(void);
void			Main_ShowBitmap(void);

#ifdef	__cplusplus
}
#endif

#endif	//_MAIN_H_
