#ifndef __LIB_FX
#define __LIB_FX

#include "_shared.fx"
#include "_structs.fx"


// --------------------------------------------------------------------------
//  newton-rhapson normalization

// v is -1..1
inline half3 nrnorm( half3 v ) {
	float t = dot( v, v );
	return v * (0.5*(1-t)) + v;
}

// v is 0..1
inline half3 nrnorm01( half3 v ) {
	float t = dot( v*2-1, v*2-1 );
	return (v-0.5) * (1-t) + (v*2-1);
}


// --------------------------------------------------------------------------
//  common code

inline float gBlurFactor( float4 p, float4x4 wv )
{
	float3 poscam = mul( p, wv );
	float focalRange = fFocalDist*2.00;
	float fromFocal = poscam.z - fFocalDist;
	if( fromFocal < 0 )
		fromFocal *= 4;
	return saturate( abs( fromFocal ) / focalRange + fBlurOffset );
}

inline void gTangentLHV( SPosTansp i, float4x4 w,
	out float3 ol, out float3 oh, out float3 ov )
{
	float3 pos = mul( i.pos, w );
	
	float3 n = normalize( mul( i.normal, (float3x3)w ) );
	float3 t = normalize( mul( i.tangent, (float3x3)w ) );
	float3 b = normalize( mul( i.binorm, (float3x3)w ) );
	float3 l = -vLightDir;
	float3 v = normalize( vEye - pos );
	float3 h = normalize( l + v );
	ol = float3( dot(l,t), dot(l,b), dot(l,n) );
	ov = float3( dot(v,t), dot(v,b), dot(v,n) );
	oh = float3( dot(h,t), dot(h,b), dot(h,n) );
}
inline void gTangentLH( SPosTansp i, float4x4 w,
	out float3 ol, out float3 oh )
{
	float3 v;
	gTangentLHV( i, w, ol, oh, v );
}

inline void gDiffSpec( half3 n, half3 l, half3 h, out half diff, out half spec )
{
	diff = saturate( dot( n, l ) + fLightO );
	spec = pow( saturate( dot( n, h ) ), 16 ) * 0.4;
}
inline void gDiffSpec11( half3 n, half3 l, half3 h, out half diff, out half spec )
{
	diff = saturate( dot( n, l ) );
	spec = pow( saturate( dot( n, h ) ), 8 ) * 0.4;
}


// --------------------------------------------------------------------------
//  stuff

inline float4 billboardpos( float4 p ) {
	return p * float4( 2, 2, 1, 1 );
}

SPosTex vsBillboard( SPosTex i, uniform float4 fixUV ) {
    SPosTex o;
	o.pos = billboardpos( i.pos );
	o.uv = i.uv + fixUV.xy;
	return o;
}


#endif
