//
// Transparent shadow caster (transparency from texture alpha).
//
// ps1.1, FFP
// 

#include "_lib.fx"

float4x4	mWVP;
texture		tBase;


sampler2D smpBase = sampler_state {
	Texture = (tBase);
    MipFilter = Linear;	MinFilter = Linear; MagFilter = Linear;
    AddressU = Wrap; AddressV = Wrap;
};


SPosTex vsMain11( SPosTex i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv;
	o.uv.x *= 2;
	return o;
}


#ifdef ENABLE_PS11_PATH

half4 psMain11( SPosTex i ) : COLOR
{
	half a = tex2D( smpBase, i.uv ).a;
	half sh = 1-fShadow;
	return 1 - half4(sh,sh,sh,0)*a;
}

technique tecPS11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain11();
	}
	pass PLast {
	}
}

#endif

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = NULL;

		Sampler[0] = (smpBase);

		TextureFactor = ( float4( 1-fShadow,1-fShadow,1-fShadow,0.0 ) );
		ColorOp[0] = Modulate;
		ColorArg1[0] = Texture | AlphaReplicate;
		ColorArg2[0] = TFactor;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Texture;
		ColorOp[1] = SelectArg1;
		ColorArg1[1] = Current | Complement;
		AlphaOp[1] = SelectArg1;
		AlphaArg1[1] = Current | Complement;
		ColorOp[2] = Disable;
		AlphaOp[2] = Disable;
	}
	pass PLast {
	}
}
