//
// Shadow map receiver.
//
// ps1.1, FFP
// 

#include "_lib.fx"

texture tShadow;

float4x4	mWorldView;
float4x4	mWVP;
float4x4	mShadowProj;


sampler2D smpShadow = sampler_state {
    Texture   = <tShadow>;
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
    AddressU = Clamp; AddressV = Clamp;
};

SPosTex vsMain11( SPos i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	float4 uvs = mul( i.pos, mWorldView );
	uvs = mul( uvs, mShadowProj );
	o.uv = uvs.xy;
	return o;
}

#ifdef ENABLE_PS20_PATH

half4 psMain11( SPosTex i ) : COLOR
{
	return tex2D( smpShadow, i.uv );
}

technique tecPS11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = compile ps_1_1 psMain11();
		AlphaBlendEnable = True;
		SrcBlend = Zero;
		DestBlend = SrcColor;
	}
	pass PLast {
		AlphaBlendEnable = False;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}

#endif


technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11();
		PixelShader = NULL;
		AlphaBlendEnable = True;
		SrcBlend = Zero;
		DestBlend = SrcColor;

		Sampler[0] = (smpShadow);
		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Texture;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
	pass PLast {
		AlphaBlendEnable = False;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}
