// Just FFP rendering path, not complete effect.
// See terrain.fx


// 1st pass: base only

SPosTex vsMainFFa( SPosTex4 i ) {
	SPosTex o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv[3]; // base
	return o;
}

// 2nd pass: mix one detail

SPosTex2 vsMainFFb( SPosTex4 i ) {
	SPosTex2 o;
	o.pos = mul( i.pos, mWVP );
	o.uv[0] = i.uv[0]; // mix
	o.uv[1] = i.uv[2] * 320; // detail
	return o;
}

// 3rd pass: lightmap + dof

SPosTexBlurc vsMainFFc( SPosTex4 i ) {
	SPosTexBlurc o;
	o.pos = mul( i.pos, mWVP );
	o.uv = i.uv[1]; // lmap
	o.blur = gBlurFactor( i.pos, mWorldView );
	return o;
}

technique tecFFP {
	pass P0 {
		VertexShader = compile vs_1_1 vsMainFFa();
		PixelShader = NULL;

		Sampler[0] = (smpBody);

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Texture;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
	pass P1 {
		VertexShader = compile vs_1_1 vsMainFFb();
		PixelShader = NULL;
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		Sampler[0] = (smpMix);
		Sampler[1] = (smpBase2);

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Diffuse;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Texture;
		ColorOp[1] = SelectArg1;
		ColorArg1[1] = Texture;
		AlphaOp[1] = SelectArg1;
		AlphaArg1[1] = Current | Complement;
		ColorOp[2] = Disable;
		AlphaOp[2] = Disable;
	}
	pass P2 {
		VertexShader = compile vs_1_1 vsMainFFc();
		PixelShader = NULL;
		AlphaBlendEnable = True;
		SrcBlend = Zero;
		DestBlend = SrcColor;

		Sampler[0] = (smpLightMap);

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Diffuse;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
	pass PLast {
		AlphaBlendEnable = False;
	}
}

