// Just ps1.1 rendering path, not complete effect.
// See water.fx

#ifdef ENABLE_PS11_PATH

struct SWater11 {
	float4 pos		: POSITION;
	float4 uv		: TEXCOORD0;
};

SWater11 vsMain11a( SPosTex i ) {
	SWater11 o;
	o.pos = mul( i.pos, mWVP );
	o.uv = mul( i.pos, mWorldView );
	o.uv = mul( o.uv, mViewTexProj );
	return o;
}

half4 psMain11a( SWater11 i ) : COLOR
{
	half4 col = tex2D( smpRefl, i.uv );
	col.rgb *= 0.6;
	col.a = 0.7;
	return col;
}

// Blur factor pass
#include "blur_11FFpath.fx"


technique tecPS11 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain11a();
		PixelShader = compile ps_1_1 psMain11a();
		AlphaBlendEnable = True;
		SrcBlend = One;
		DestBlend = InvSrcAlpha;
		
		TextureTransformFlags[0] = Projected;
	}
	pass PBlur {
		BLUR11_PASS
		TextureTransformFlags[0] = Disable;
	}
	pass PLast {
		BLUR_RESTORE
		AlphaBlendEnable = False;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}

#endif
