// Just ps2.0 rendering path, not complete effect.
// See water.fx

#ifdef ENABLE_PS20_PATH

struct SWater20 {
	float4 pos		: POSITION;
	float4 uv		: TEXCOORD0;
	float2 uvWaves[2] : TEXCOORD1;
};

SWater20 vsMain20a( SPosTex i ) {
	SWater20 o;
	o.pos = mul( i.pos, mWVP );
	o.uv = mul( i.pos, mWorldView );
	o.uv = mul( o.uv, mViewTexProj );
	
	float2 uvWaves = i.uv * 0.3;
	o.uvWaves[0] = uvWaves + float2(  fTime * 0.05,  fTime * 0.01 );
	o.uvWaves[1] = uvWaves + float2( -fTime * 0.01, -fTime * 0.04 );
	return o;
}

half4 psMain20a( SWater20 i ) : COLOR
{
	float2 uv = i.uv.xy / i.uv.w;
	half2 t0 = tex2D( smpWaves, i.uvWaves[0] ).xy*2-1;
	half2 t1 = tex2D( smpWaves, i.uvWaves[1] ).xy*2-1;
	half2 t = (t0 + t1) * 0.01;
	half4 col = tex2D( smpRefl, uv+t );
	col *= 0.6;
	col.a = 0.7;
	return col;
}

// Blur factor pass
#include "blur_11FFpath.fx"


technique tecPS20 {
	pass P0 {
		VertexShader = compile vs_1_1 vsMain20a();
		PixelShader = compile ps_2_0 psMain20a();
		AlphaBlendEnable = True;
		SrcBlend = One;
		DestBlend = InvSrcAlpha;
	}
	pass PBlur {
		BLUR11_PASS
	}
	pass PLast {
		BLUR_RESTORE
		AlphaBlendEnable = False;
		Texture[0] = NULL;
		Texture[1] = NULL;
	}
}

#endif
