// Just FFP rendering path, not complete effect.
// See wings.fx


SPosColorTex vsMainFF( SPosTanspTex i ) {
	SPosColorTex o;
	o.pos = mul( i.pos, mWVP );
	
	float3 n = mul( i.normal, (float3x3)mWorld );
	o.color = saturate( dot( n, -vLightDir ) ) + fLightAmbient;
	o.color.a = fAlpha;

	o.uv = i.uv;
	o.uv.x *= 2;
	return o;
}

// Blur factor pass
#include "blur_11FFpath.fx"

technique tecFFP
< bool backToFront = true; >
{
	pass PBase {
		VertexShader = compile vs_1_1 vsMainFF();
		PixelShader = NULL;
		ZWriteEnable = False;
		AlphaBlendEnable = True;
		SrcBlend = One;
		DestBlend = InvSrcAlpha;

		Sampler[0] = (smpBase);

		ColorOp[0] = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = Diffuse;
		AlphaOp[0] = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = Diffuse;
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
    pass PBlur {
		BLURFF_PASS
		AlphaBlendEnable = False;
    }
	pass PLast {
		BLUR_RESTORE
	}
}

