;----------------------------------------------------------------------------;
; Cartridge information                                                      ;
;----------------------------------------------------------------------------;

IF !DEF(_HEADER_INC)
_HEADER_INC = 1

;----------------------------------------------------------------------------;
; HDR_INFO - Misc. cartridge information                                     ;
;----------------------------------------------------------------------------;

HDR_INFO: macro
SECTION "HDR_LOGO", HOME[$104]
  db    $CE,$ED,$66,$66,$CC,$0D,$00,$0B,$03,$73,$00,$83,$00,$0C,$00,$0D
  db    $00,$08,$11,$1F,$88,$89,$00,$0E,$DC,$CC,$6E,$E6,$DD,$DD,$D9,$99
  db    $BB,$BB,$67,$63,$6E,$0E,$EC,$CC,$DD,$DC,$99,$9F,$BB,$B9,$33,$3E

SECTION "HDR_TYPE", HOME[$143]
  db    $80             ; 80:CGB - 00:NON-CGB
  db    0               ; High nibble of new licensee code
  db    0               ; Low nibble of new licensee code
  db    0               ; 0:GameBoy, 3:Super GameBoy functions
  db    3               ; 0-FF:ROM - 2-3,8-9,FF:RAM - 3,6,9,FF:Battery
                        ; 1-3:MBC1 - 5-6:MBC2 - FF:HuC1
  db    0               ; ROM size: 0:32kb, 1:64kb, 2:128kb, 3:256kb, 4:512kb,
                        ;           5:1mb, 6:2mb, 52:1.1mb, 53:1.2mb, 54:1.5mb
  db	3               ; RAM size: 0:0kb, 1:2kb, 2:8kb, 3:32kb
  db    1               ; Destination code: 0:Japanese, 1:Non-Japanese
  db    $33             ; Licensee code (old), 33:see new licensee code
  db    1               ; ROM Version number
  db    $FF             ; Complement check (!)
  dw    $FFFF           ; ROM checksum
endm

;----------------------------------------------------------------------------;
; HDR_TITLE(title) - Set cartridge title                                     ;
;----------------------------------------------------------------------------;

HDR_TITLE: macro
SECTION "HDR_TITLE", HOME[$134]
  db \1
  REPT (15-STRLEN("\1"))
  db 0                  ; Fill to 15 bytes
  ENDR
endm

;----------------------------------------------------------------------------;
; HDR_START(start) - Define start address                                    ;
;----------------------------------------------------------------------------;

HDR_START: macro
SECTION "HDR_START", HOME[$100]
  nop
  jp    \1
endm

;----------------------------------------------------------------------------;

ENDC
