// MixerView.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "MixerView.h"
#include "channelmixer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMixerView

IMPLEMENT_DYNCREATE(CMixerView, CFormView)

CMixerView::CMixerView()
	: CFormView(CMixerView::IDD)
{
	//{{AFX_DATA_INIT(CMixerView)
	//}}AFX_DATA_INIT
}

CMixerView::~CMixerView()
{
}

void CMixerView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMixerView)
	DDX_Control(pDX, IDC_CHMIXER_LAYOUT, m_mixerLayout);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMixerView, CFormView)
	//{{AFX_MSG_MAP(CMixerView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMixerView diagnostics

#ifdef _DEBUG
void CMixerView::AssertValid() const
{
	CFormView::AssertValid();
}

void CMixerView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
CTrackerDoc* CMixerView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTrackerDoc)));
    return (CTrackerDoc*)m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMixerView message handlers

isSynth * CMixerView::GetSynth()
{
    CTrackerDoc *pDoc = GetDocument();
    return (pDoc->synth);
    
}
void CMixerView::OnInitialUpdate() 
{
    CFormView::OnInitialUpdate();

    
    CRect wrect;
    int h,w,i;
    isSynth *synth;
    CChannelMixer *dummy;	


    CTrackerDoc *pDoc = GetDocument();
    synth = GetSynth();
    
    

    m_mixerLayout.GetWindowRect(&wrect);
    ScreenToClient(&wrect);
    h = wrect.Height();
    w = wrect.Width();

    for (i=0;i<16;i++)
    {
        dummy = new CChannelMixer();
        dummy->Create (MAKEINTRESOURCE(IDD_DIALOG_MIXERCHANNEL),this);
        dummy->SetSynth(synth,i);
        dummy->UpdateWindow();
        dummy->ShowWindow(SW_SHOW);
        dummy->MoveWindow(&wrect);

        dummy->UpdateSynthData();
        /*
        wrect.top+=h;
        wrect.bottom+=h;
        */
        wrect.left+=w;
        wrect.right+=w;
    }
	// TODO: Add your specialized code here and/or call the base class
	
}
