// ModController.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "ModController.h"
#include "isSynth.h"
#include "isController.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define FloatIntMAX 1024
#define uFloatToInt(a) ((a)*1024)
#define sFloatToInt(a) ((a)*1024+1024)

#define uIntToFloat(a) ((a)/1024.0f)
#define sIntToFloat(a) (((a)-1024)/1024.0f)


/////////////////////////////////////////////////////////////////////////////
// CModController dialog


CModController::CModController(CWnd* pParent /*=NULL*/)
	: CModulateBaseDlg(CModController::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModController)
	//}}AFX_DATA_INIT
}


void CModController::DoDataExchange(CDataExchange* pDX)
{
	CModulateBaseDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModController)
	DDX_Control(pDX, IDC_STATIC_CUTOFFVAL, m_cutoffval);
	DDX_Control(pDX, IDC_EDIT_CNTRNR, m_cntrnr);
	DDX_Control(pDX, IDC_SLIDER_MOD_CNTR, m_cutoffslider);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CModController, CModulateBaseDlg)
	//{{AFX_MSG_MAP(CModController)
	ON_EN_MAXTEXT(IDC_EDIT_CNTRNR, OnMaxtextEditCntrnr)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModController message handlers

void CModController::OnMaxtextEditCntrnr() 
{
	// TODO: Add your control notification handler code here
    isController*cntr;
    cntr = (isController*)modulator;

    CString bla;
    m_cntrnr.GetWindowText (bla);

    cntr->controllerNumber = atoi ((LPCSTR)bla);

	
}

void CModController::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
    isController*cntr;
    cntr = (isController*)modulator;

    cntr->cutoff = uIntToFloat (m_cutoffslider.GetPos ());
    CString bla;
    bla.Format ("%5.4f",cntr->cutoff);
    m_cutoffval.SetWindowText (bla);
    
	CModulateBaseDlg::OnHScroll(nSBCode, nPos, pScrollBar);
}

BOOL CModController::OnInitDialog() 
{
	CModulateBaseDlg::OnInitDialog();
    m_cutoffslider.SetRange (0,FloatIntMAX);
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CModController::UpdateModulateData()
{
    isController*cntr;
    cntr = (isController*)modulator;
    
    m_cutoffslider.SetPos (uFloatToInt(cntr->cutoff));
    CString bla;
    bla.Format ("%d",cntr->controllerNumber);
    m_cntrnr.SetWindowText (bla);

    bla.Format ("%5.4f",cntr->cutoff);
    m_cutoffval.SetWindowText (bla);
    
}
