// TrackerScopes.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "TrackerScopes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTrackerScopes dialog

CTrackerScopes::CTrackerScopes(): CMyDialogBar()
{
	//{{AFX_DATA_INIT(CTrackerScopes)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
  numScope=0;
  hasupdate=0;
}


void CTrackerScopes::DoDataExchange(CDataExchange* pDX)
{
	CDialogBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrackerScopes)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTrackerScopes, CDialogBar)
	//{{AFX_MSG_MAP(CTrackerScopes)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTrackerScopes message handlers

void CTrackerScopes::CreateScopes(int num)
{
  CDC *dc;
  CRect rect;
  int i,xp,xp2,h,yp;

  numScope = num;
  if ((dc=GetDC ())==NULL) return;

  GetClientRect(&rect);

  if (numScope>8)
    h = (rect.Height()/2) - 2;
  else
    h = rect.Height();

  xp=0;
  yp=0;


  if (numScope>8)
  {
    num=numScope>>1;
    for (i=0;i<num;i++)  
    {
      xp = i*rect.Width()/(float)(num);
      xp2 = (i+1)*rect.Width()/(float)(num);
      dc->FillSolidRect(xp,yp,(xp2-xp)-2,h,0x0);    
    }
    yp = (rect.Height()/2);
    
  }

  for (i=0;i<num;i++)  
  {
    xp = i*rect.Width()/(float)(num);
    xp2 = (i+1)*rect.Width()/(float)(num);
    dc->FillSolidRect(xp,yp,(xp2-xp)-2,h,0);    
  }
}
void CTrackerScopes::PrepareUpdate(int _idx, float *_buffer,DWORD _bufsize)
{
  idx=_idx;
  buffer=_buffer;
  bufsize=_bufsize;
  hasupdate=1; 
}
static int count=0;
void CTrackerScopes::Update()
{
  CDC *dc;
  CRect rect;
  int i,xp,xp2,h,yp,w,oxp,oyp;
  DWORD pos,step;
  COLORREF cr;
  CGdiObject *old;

  if (!hasupdate) return;
  
  if ((dc=GetDC ())==NULL) return;  
  GetClientRect(&rect);
  
  w=rect.Width()/(float)numScope;

  xp = idx * w;
  xp2 = (idx+1) * w;
  h = rect.Height();

  pos = 0;
  step = (bufsize<<16) / w;
  oxp=xp;
  oyp=h/2;

  yp=0;
  dc->FillSolidRect(xp,yp,(xp2-xp)-2,h,0x0);    
  
  old = dc->SelectStockObject(WHITE_PEN);
// debug break special
  if (count>20)
    h=h;
  count++;

  CString str;
  str.Format("bufsize:%d\n",bufsize);
  OutputDebugString(str);

  cr = RGB (255,255,0);
  for (i=xp;i<xp2-4;i++)
  {
    yp=(-buffer[pos>>16] - 0.5) * h * 0.99 + h;
    
    dc->MoveTo(oxp,oyp);
    dc->LineTo(i,yp);
    oxp=i;
    oyp=yp;

    pos+=step;
  }


  dc->MoveTo(oxp,oyp);
  dc->LineTo(xp2-3,h/2);

  
  dc->SelectObject(old);
  ReleaseDC(dc);
  
  hasupdate=0; 
}


void CTrackerScopes::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
  Update ();
	
	// Do not call CDialogBar::OnPaint() for painting messages
}
