/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isChorus_h
#define __isChorus_h

#include "isStereoFX.h "

class isChorus : public isStereoFX
{
public:
	isChorus();
	virtual ~isChorus();

	void Save(isFile *f);
	void Load(isFile *f);
	
	void Play(float *leftIn, float *rightIn, float *leftOut, float *rightOut);
	void SetBufferSize(unsigned int length);
	
	// variables
	float speed;		// 0..1
	float depth;		// 0..1
	float spread;		// 0..1
	float feedback;	// -1..1
	float volume;		// -1..1
	float dryMix;		// -1..1
	bool hifi;			// better sound. more cpu

private:
	unsigned int myBufferLength;
	unsigned long int bufferCnt;
	float count;
	float *left,*right; // internal buffers

	inline float Wave(float cnt);
};

#endif