/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isFile_h
#define __isFile_h

#include <stdio.h>
#include <windows.h>

#define BUFSIZE 100	

class isFile
{
public:
	isFile(HANDLE file, bool mem); // only binary file write supported, read supports ascii and binary
	virtual ~isFile();
	
	// read
	int ReadInt(int bytes);
	float ReadFloat();
	char *ReadStr();
	
	// write
	void WriteInt(long val, int bytes);
	void WriteFloat(float val);
	void WriteString(char *str);
    DWORD GetPos();

private:
	void SkipComment();
	HANDLE f; // the file we're working with (if not reading from mem)
    BYTE *orgptr;
	DWORD num; // for the WriteFile (holds the last amount of written bytes)
	// binary or ascii?
	bool bin;
	// file or buffer in memory? memory is always bin
	bool mem;
	void *buffer; // the mem we're working with (if not reading from file)
	unsigned long header;
	char buf[BUFSIZE];
};

#endif

