// trackerView.cpp : implementation of the CPatternView class
//
/*

TODO:
    Copy/paste buggen
    Fixa distortion volume
    Ta bort fula dialog boxen
    Bttre CPU mtare
    Se till att man kan stnga Scopes fnstret 
    Effektivisera scopes fnstret...
    Effekt kedjor (ned prioriterat, frn min sida, jag har inte grepp om hur jag ska lgga upp det )

*/

#include "stdafx.h"
#include "tracker.h"

#include "mainfrm.h"
#include "gtkformat.h"
#include "trackerDoc.h"
#include "trackerView.h"
#include "Globals.h"
#include "MIDIInput.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SETHIBYTE(a,b) ((a)=((a)&0x0f)|(((b)<<4)&0xf0));
#define SETLOWBYTE(a,b) ((a)=((a)&0xf0)|((b)&0x0f));
//			posPtr->fx = (posPtr->fx & 0x0f) | ((val << 4) & 0xf0);

/////////////////////////////////////////////////////////////////////////////
// CPatternView

IMPLEMENT_DYNCREATE(CPatternView, CDblBuffView)

BEGIN_MESSAGE_MAP(CPatternView, CDblBuffView)
	//{{AFX_MSG_MAP(CPatternView)
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
	ON_COMMAND(ID_ACTION_PLAY, OnActionPlay)
	ON_COMMAND(ID_ACTION_STOP, OnActionStop)
	ON_WM_HSCROLL()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CDblBuffView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CDblBuffView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CDblBuffView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPatternView construction/destruction

CPatternView::CPatternView()
{
	// TODO: add construction code here
	seqpatscr = 0;


}

CPatternView::~CPatternView()
{
	g_midi_input->endmsgdest( m_hWnd );
}

BOOL CPatternView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
/*
	isTrkEdit = 0;
	trackPtr = NULL;
*/
	seqCursor.num = 0;
	seqCursor.pos = 0;
	seqCursor.col = 0;
	seqCursor.rowcol = 0;
	patCursor.num = 0;
	patCursor.pos = 0;
	patCursor.col = 0;
	patCursor.rowcol = 0;

	isPatternEdit = 0;
	seqPos = 0;
	patternPos = 0;


	return CDblBuffView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CPatternView drawing
void CPatternView::OnDraw(CDC* pDC)
{
  CMainFrame *mf;

  mf = (CMainFrame *)AfxGetMainWnd();
  if (mf->m_trackerControls.m_scrollData)
  {
    DrawPattern (pDC);
    DrawSequencer (pDC);
  }
    
/*
	CTrackerDoc *pDoc = GetDocument ();
	char buffer[256];
	sprintf(buffer, "Tick=%02d Seqpos=%02d Pattern=%02d Patternrow=%02d",0,pDoc->play_seqpos,pDoc->play_pattern,pDoc->play_patternrow);
	pDC->TextOut (0,0,buffer);
*/
}

/////////////////////////////////////////////////////////////////////////////
// CPatternView printing

BOOL CPatternView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CPatternView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CPatternView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CPatternView diagnostics

#ifdef _DEBUG
void CPatternView::AssertValid() const
{
	CDblBuffView::AssertValid();
}

void CPatternView::Dump(CDumpContext& dc) const
{
	CDblBuffView::Dump(dc);
}

CTrackerDoc* CPatternView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTrackerDoc)));
	return (CTrackerDoc*)m_pDocument;
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CPatternView message handlers

BOOL CPatternView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	
    // Set brush to desired background color.
    return TRUE;
}
static int legal_note_num[]=
{
	1,2,3,4,5,6,7,8,9,10,11,12,13,14,
	12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29
};
static char *legal_note_char="ZSXDCVGBHNJM,L.Q2W3ER5T6Y7UI9O0P";
static char *legal_trkctrl_char="KCV";
static char *legal_num_char="0123456789ABCDEF";


void CPatternView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	CTrackerDoc *pDoc = GetDocument ();

	switch (nChar)
	{
		case VK_F7 :
			OnActionPlay ();
			break;
		case VK_F8 :
			OnActionStop ();
			break;
/*
		case VK_CONTROL :
			if (pDoc->playing)
				OnActionStop ();
			else
				OnActionPlay ();
			break;	
*/
		default :
			if (isPatternEdit) ProcessPatternKey (nChar,nRepCnt,nFlags);
			else ProcessSequencerKey (nChar, nRepCnt,nFlags);

	}
	

	CDblBuffView::OnKeyDown(nChar, nRepCnt, nFlags);
}


/*
void CPatternView::OnFileOpen() 
{
	// TODO: Add your command handler code here
	
}
*/


static void WINAPI UpdateCallback(LPVOID passed)
{
	float cpu;
	DWORD buflen;
	float *bufpek;
	char buffer[128];
	CPatternView *pv = (CPatternView *)passed;
	CMainFrame *mf;

	CTrackerDoc* pDoc = pv->GetDocument();
	int chn=pv->seqCursor.col;

	pDoc->pl->GetCurrentTick();
	pDoc->pl->GetCurrentPosition( chn, pDoc->play_seqpos, pDoc->play_pattern, pDoc->play_patternrow );  
	pv->InvalidateRect (NULL,FALSE);

	cpu=pDoc->synth->GetCPUUsage();
	sprintf (buffer,"%f%",cpu);
	mf=(CMainFrame *)AfxGetMainWnd();
	mf=(CMainFrame *)AfxGetApp()->GetMainWnd();

	if (mf && mf->IsKindOf(RUNTIME_CLASS(CMainFrame)))
	{
		mf->SendMessage(WM_USER+10,0,(LPARAM)buffer);
		bufpek=pDoc->pl->GetLeftPlayingBuffer(&buflen);
		mf->m_trackerScopes.PrepareUpdate(0,bufpek,buflen);
		mf->m_trackerScopes.Update();
		bufpek=pDoc->pl->GetRightPlayingBuffer(&buflen);
		mf->m_trackerScopes.PrepareUpdate(1,bufpek,buflen);
		mf->m_trackerScopes.Update();
		//  mf->m_trackerScopes.Invalidate(FALSE);
	}
}

void CPatternView::OnActionPlay() 
{
	// TODO: Add your command handler code here
	CTrackerDoc* pDoc = GetDocument();

	if (!pDoc->playing)
	{
        CMainFrame *mfrm;
        mfrm = (CMainFrame *)AfxGetMainWnd();
        mfrm->m_trackerScopes.CreateScopes(2);
//  	    pDoc->pl->Start (pDoc->gtk);
        if (pDoc->gtk != NULL)
        {
            pDoc->pl->Start (pDoc->gtk, seqCursor.pos );
            pDoc->pl->SetUpdateCallback (UpdateCallback,(LPVOID)this);
            pDoc->playing = 1;
        }
	}
}

void CPatternView::OnActionStop() 
{
	// TODO: Add your command handler code here
	CTrackerDoc* pDoc = GetDocument();

  CMainFrame *mfrm;
  mfrm = (CMainFrame *)AfxGetMainWnd();
  mfrm->m_trackerScopes.CreateScopes(2);
  
	if (pDoc->playing)
	{
		pDoc->pl->Stop ();
	}

	pDoc->playing = 0;
}
void CPatternView::OnSize(UINT nType, int cx, int cy) 
{
	CDblBuffView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	if (seqpatscr)
	{
		CRect rect;
		seqScroller.GetWindowRect (&rect);
		ScreenToClient (&rect);
		rect.right=cx;	
		seqScroller.MoveWindow (&rect);

		patScroller.GetWindowRect (&rect);
		ScreenToClient (&rect);
		rect.right=cx;	
	 	rect.top = cy-12;
		rect.bottom = cy;
		patScroller.MoveWindow (&rect);
	}

}

void CPatternView::OnInitialUpdate() 
{
	CDblBuffView::OnInitialUpdate();


	CRect crect;
	GetClientRect (&crect);
	CRect seqRect (0,128-16,crect.Width (),128);;
	CRect patRect (0,crect.Height ()-10,crect.Width (),crect.Height ());

	
	seqScroller.Create (WS_CHILD|WS_VISIBLE|SBS_HORZ|SBS_BOTTOMALIGN,seqRect,this,0x666);
	seqScroller.SetScrollRange (0,16);
	seqScroller.SetScrollPos (0);

	patScroller.Create (WS_CHILD|WS_VISIBLE|SBS_HORZ|SBS_BOTTOMALIGN,patRect,this,0x666);	
	patScroller.SetScrollRange (0,16);
	patScroller.SetScrollPos (0);
	seqpatscr=1;

  CMainFrame *mfrm;
  mfrm = (CMainFrame *)AfxGetMainWnd();
  mfrm->m_trackerScopes.CreateScopes(2);
  
	// TODO: Add your specialized code here and/or call the base class
}

void CPatternView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default

	int ps;
	int minpos;
	int maxpos;
	pScrollBar->GetScrollRange(&minpos, &maxpos); 
	maxpos = pScrollBar->GetScrollLimit();

   // Get the current position of scroll box.
	int curpos = pScrollBar->GetScrollPos();

	if (pScrollBar != &seqScroller) ps = 1;
	else ps = 0;

	switch (nSBCode)
	{
		case SB_LEFT:      // Scroll to far left.
			curpos = minpos;
			break;

		case SB_RIGHT:      // Scroll to far right.
			curpos =maxpos;
			break;

		case SB_ENDSCROLL:   // End scroll.
			break;

		case SB_LINELEFT:      // Scroll left.
			if (curpos > minpos)
				 curpos--;

			break;

		case SB_LINERIGHT:   // Scroll right.
			if (curpos < maxpos)
				 curpos++;
			break;

		case SB_PAGELEFT:    // Scroll one page left.
		{
			// Get the page size. 
			SCROLLINFO   info;
			pScrollBar->GetScrollInfo(&info, SIF_ALL);

			if (curpos > minpos)
			curpos = max(minpos, curpos - (int) info.nPage);
		}
			break;

		case SB_PAGERIGHT:      // Scroll one page right.
		{
			// Get the page size. 
			SCROLLINFO   info;
			pScrollBar->GetScrollInfo(&info, SIF_ALL);

			if (curpos < maxpos)
				 curpos = min(maxpos, curpos + (int) info.nPage);
		}
			break;

		case SB_THUMBPOSITION: // Scroll to absolute position. nPos is the position
			curpos = nPos;      // of the scroll box at the end of the drag operation.
			break;

		case SB_THUMBTRACK:   // Drag scroll box to specified position. nPos is the
			curpos = nPos;     // position that the scroll box has been dragged to.
			break;
	}

   // Set the new position of the thumb (scroll box).
	pScrollBar->SetScrollPos(curpos);

//	if (!ps) SetSequencerCursor (curpos,2);


	CTrackerDoc* pDoc = GetDocument();
  pDoc->UpdateAllViews (NULL);
  

	CDblBuffView::OnHScroll(nSBCode, nPos, pScrollBar);
  
}

void CPatternView::OnEditCopy() 
{
	// TODO: Add your command handler code here
  CTrackerDoc* pDoc = GetDocument();
  if (pDoc->editData.state == GTK_EDITSTATE_PATTERNSELECT)
  {
    CopyPatternBlock();
    pDoc->editData.state = GTK_EDITSTATE_DEFAULT;
    pDoc->UpdateAllViews(NULL);
  }
    
	
}

void CPatternView::OnEditPaste() 
{
	// TODO: Add your command handler code here
	
  CTrackerDoc* pDoc = GetDocument();
  if (pDoc->editData.copybuffer.hasdata)
  {
    PastePatternBlock();
    pDoc->editData.state = GTK_EDITSTATE_DEFAULT;
    pDoc->UpdateAllViews(NULL);
  }
}

LRESULT CPatternView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	MIDIReceptor::FilterMidiMsg( message, wParam, lParam );
	return CDblBuffView::WindowProc(message, wParam, lParam);
}

void CPatternView::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDblBuffView::OnShowWindow(bShow, nStatus);
	// TODO: Add your message handler code here

	g_midi_input->setmsgdest( m_hWnd );
	
}

void CPatternView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (TRUE == bActivate) {
		g_midi_input->setmsgdest( m_hWnd );
	} else {
		g_midi_input->endmsgdest( m_hWnd );
	}	
	CDblBuffView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}
