/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ProjectLCDCanvas
extends Canvas
implements CommandListener,
Runnable {
    private static final int TIME_INTROEND = 12500;
    private static final int TIME_LINES = 12500;
    private static final int TIME_TWISTER = 15000;
    private static final int TIME_MOVIE = 17000;
    private static final int TIME_ARC = 12000;
    private static final int TIME_CITY = 16000;
    private static final int TIME_END = 1000;
    private static final int CLIP_NONE = 0;
    private static final int CLIP_MIDDLE = 1;
    private static final int CLIP_LEFT = 2;
    private static final int CLIP_RIGHT = 3;
    private static final int CLIP_UP = 2;
    private static final int CLIP_DOWN = 3;
    private static boolean firstPaint = true;
    private final ProjectLCD midlet;
    private final Display display;
    private final Command exitCommand = new Command("Exit", 7, 1);
    private int width;
    private int height;
    private int xpos;
    private int ypos;
    private int totalTime = 0;
    private int deltaTime;
    private int bufTime;
    private volatile Thread animationThread;
    private Object3D spikeObj;
    private Object3D cityObj;
    private Object3D tetraObj;
    private Object3D octaObj;
    private Object3D cubeObj;
    private boolean showFPS = false;
    private Image offscreen;
    private Font myFont;
    private int fontW;
    private int fontH;
    private int fontS;
    private int[] partTime = new int[10];

    public ProjectLCDCanvas(ProjectLCD projectLCD, Display display) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        this.partTime[0] = 12500;
        this.partTime[1] = this.partTime[0] + 12500;
        this.partTime[2] = this.partTime[1] + 15000;
        this.partTime[3] = this.partTime[2] + 17000;
        this.partTime[4] = this.partTime[3] + 12000;
        this.partTime[5] = this.partTime[4] + 16000;
        this.partTime[6] = this.partTime[5] + 1000;
        this.animationThread = null;
        this.midlet = projectLCD;
        this.display = display;
        this.setCommandListener(this);
        this.addCommand(this.exitCommand);
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.height * 16 / 9 > this.width) {
            this.height = this.width * 9 / 16;
        } else {
            this.width = this.height * 16 / 9;
        }
        this.xpos = this.getWidth() > this.width ? (this.getWidth() - this.width) / 2 : 0;
        this.ypos = this.getHeight() > this.height ? (this.getHeight() - this.height) / 2 : 0;
        SdwUtil.SetupEdgeList(this.ypos, this.height);
        this.myFont = Font.getFont((int)64, (int)0, (int)16);
        if (10 * this.myFont.charWidth('W') > this.width) {
            this.myFont = Font.getFont((int)64, (int)0, (int)0);
        }
        if (10 * this.myFont.charWidth('W') > this.width) {
            this.myFont = Font.getFont((int)64, (int)0, (int)8);
        }
        this.fontW = this.myFont.charWidth('W');
        if (this.fontW * 10 > this.width) {
            this.fontW = this.width / 10;
        }
        this.fontH = this.myFont.getHeight();
        this.fontS = (this.width - 10 * this.fontW) / 2;
        this.spikeObj = new Object3D(128, 0);
        for (n3 = 0; n3 < 64; ++n3) {
            int n5;
            if (n3 < 32) {
                n2 = 0;
                n5 = 128;
            } else {
                n2 = 256;
                n5 = -128;
            }
            n = n3 * 32;
            this.spikeObj.x[n4] = 1800 * SdwUtil.CosCalc(SdwUtil.SinCalc(256, n), n2);
            this.spikeObj.y[n4] = 1800 * SdwUtil.SinCalc(SdwUtil.SinCalc(256, n), n2);
            this.spikeObj.z[n4] = 1800 * SdwUtil.CosCalc(256, n);
            this.spikeObj.x[n4 + 64] = 1800 * SdwUtil.CosCalc(SdwUtil.SinCalc(256 + n5, n), n2);
            this.spikeObj.y[n4 + 64] = 1800 * SdwUtil.SinCalc(SdwUtil.SinCalc(256 + n5, n), n2);
            this.spikeObj.z[n4 + 64] = 1800 * SdwUtil.CosCalc(256 + n5, n);
            ++n4;
        }
        this.cityObj = new Object3D(36, 0);
        n4 = 0;
        for (n2 = -1; n2 <= 1; ++n2) {
            for (n = -1; n <= 1; ++n) {
                int n6 = n2 * 500000;
                int n7 = n * 500000;
                n6 = n6 + SdwUtil.Rand() % 100000 - 50000;
                n7 = n7 + SdwUtil.Rand() % 100000 - 50000;
                int n8 = 100000 + SdwUtil.Rand() % 25000;
                int n9 = SdwUtil.Rand() % 500000 - 100000;
                this.cityObj.x[n4] = n6 - n8;
                this.cityObj.y[n4] = -n9;
                this.cityObj.z[n4] = n7 - n8;
                this.cityObj.x[n4 + 1] = n6 + n8;
                this.cityObj.y[n4 + 1] = -n9;
                this.cityObj.z[n4 + 1] = n7 - n8;
                this.cityObj.x[n4 + 2] = n6 + n8;
                this.cityObj.y[n4 + 2] = -n9;
                this.cityObj.z[n4 + 2] = n7 + n8;
                this.cityObj.x[n4 + 3] = n6 - n8;
                this.cityObj.y[n4 + 3] = -n9;
                this.cityObj.z[n4 + 3] = n7 + n8;
                n4 += 4;
            }
        }
        this.tetraObj = new Object3D(4, 17);
        this.tetraObj.x[0] = 664000;
        this.tetraObj.y[0] = 0;
        this.tetraObj.z[0] = -469000;
        this.tetraObj.x[1] = 0;
        this.tetraObj.y[1] = -664000;
        this.tetraObj.z[1] = 469000;
        this.tetraObj.x[2] = 0;
        this.tetraObj.y[2] = 664000;
        this.tetraObj.z[2] = 469000;
        this.tetraObj.x[3] = -664000;
        this.tetraObj.y[3] = 0;
        this.tetraObj.z[3] = -469000;
        n3 = 0;
        this.tetraObj.faceList[n3++] = 3;
        this.tetraObj.faceList[n3++] = 2;
        this.tetraObj.faceList[n3++] = 1;
        this.tetraObj.faceList[n3++] = 0;
        this.tetraObj.faceList[n3++] = 3;
        this.tetraObj.faceList[n3++] = 3;
        this.tetraObj.faceList[n3++] = 0;
        this.tetraObj.faceList[n3++] = 1;
        this.tetraObj.faceList[n3++] = 3;
        this.tetraObj.faceList[n3++] = 2;
        this.tetraObj.faceList[n3++] = 0;
        this.tetraObj.faceList[n3++] = 3;
        this.tetraObj.faceList[n3++] = 3;
        this.tetraObj.faceList[n3++] = 3;
        this.tetraObj.faceList[n3++] = 1;
        this.tetraObj.faceList[n3++] = 2;
        this.tetraObj.faceList[n3++] = -1;
        this.octaObj = new Object3D(6, 33);
        this.octaObj.x[0] = 0;
        this.octaObj.y[0] = -575000;
        this.octaObj.z[0] = 575000;
        this.octaObj.x[1] = 0;
        this.octaObj.y[1] = -575000;
        this.octaObj.z[1] = -575000;
        this.octaObj.x[2] = 0;
        this.octaObj.y[2] = 575000;
        this.octaObj.z[2] = 575000;
        this.octaObj.x[3] = 813000;
        this.octaObj.y[3] = 0;
        this.octaObj.z[3] = 0;
        this.octaObj.x[4] = -813000;
        this.octaObj.y[4] = 0;
        this.octaObj.z[4] = 0;
        this.octaObj.x[5] = 0;
        this.octaObj.y[5] = 575000;
        this.octaObj.z[5] = -575000;
        n3 = 0;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 2;
        this.octaObj.faceList[n3++] = 0;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 1;
        this.octaObj.faceList[n3++] = 5;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 0;
        this.octaObj.faceList[n3++] = 1;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 5;
        this.octaObj.faceList[n3++] = 2;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 5;
        this.octaObj.faceList[n3++] = 4;
        this.octaObj.faceList[n3++] = 2;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 1;
        this.octaObj.faceList[n3++] = 0;
        this.octaObj.faceList[n3++] = 4;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 4;
        this.octaObj.faceList[n3++] = 5;
        this.octaObj.faceList[n3++] = 1;
        this.octaObj.faceList[n3++] = 3;
        this.octaObj.faceList[n3++] = 0;
        this.octaObj.faceList[n3++] = 2;
        this.octaObj.faceList[n3++] = 4;
        this.octaObj.faceList[n3++] = -1;
        this.cubeObj = new Object3D(8, 62);
        this.cubeObj.x[0] = -983040;
        this.cubeObj.y[0] = -983040;
        this.cubeObj.z[0] = -983040;
        this.cubeObj.x[1] = 983040;
        this.cubeObj.y[1] = -983040;
        this.cubeObj.z[1] = -983040;
        this.cubeObj.x[2] = 983040;
        this.cubeObj.y[2] = 983040;
        this.cubeObj.z[2] = -983040;
        this.cubeObj.x[3] = -983040;
        this.cubeObj.y[3] = 983040;
        this.cubeObj.z[3] = -983040;
        this.cubeObj.x[4] = -983040;
        this.cubeObj.y[4] = -983040;
        this.cubeObj.z[4] = 983040;
        this.cubeObj.x[5] = 983040;
        this.cubeObj.y[5] = -983040;
        this.cubeObj.z[5] = 983040;
        this.cubeObj.x[6] = 983040;
        this.cubeObj.y[6] = 983040;
        this.cubeObj.z[6] = 983040;
        this.cubeObj.x[7] = -983040;
        this.cubeObj.y[7] = 983040;
        this.cubeObj.z[7] = 983040;
        n3 = 0;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 2;
        this.cubeObj.faceList[n3++] = 0;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 2;
        this.cubeObj.faceList[n3++] = 1;
        this.cubeObj.faceList[n3++] = 0;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 4;
        this.cubeObj.faceList[n3++] = 5;
        this.cubeObj.faceList[n3++] = 7;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 5;
        this.cubeObj.faceList[n3++] = 6;
        this.cubeObj.faceList[n3++] = 7;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 5;
        this.cubeObj.faceList[n3++] = 1;
        this.cubeObj.faceList[n3++] = 6;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 1;
        this.cubeObj.faceList[n3++] = 2;
        this.cubeObj.faceList[n3++] = 6;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 0;
        this.cubeObj.faceList[n3++] = 4;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 4;
        this.cubeObj.faceList[n3++] = 7;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 0;
        this.cubeObj.faceList[n3++] = 1;
        this.cubeObj.faceList[n3++] = 4;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 1;
        this.cubeObj.faceList[n3++] = 5;
        this.cubeObj.faceList[n3++] = 4;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 2;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 6;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 3;
        this.cubeObj.faceList[n3++] = 7;
        this.cubeObj.faceList[n3++] = 6;
        this.cubeObj.faceList[n3++] = -1;
        if (!this.isDoubleBuffered()) {
            this.offscreen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        }
    }

    void startAnimation() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    void stopAnimation() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l;
        int n = 10;
        Thread thread = Thread.currentThread();
        long l2 = l = System.currentTimeMillis();
        this.totalTime = 0;
        try {
            while (thread == this.animationThread) {
                Runnable runnable;
                l2 = System.currentTimeMillis();
                this.repaint(0, 0, this.getWidth(), this.getHeight());
                this.serviceRepaints();
                long l3 = System.currentTimeMillis() - l2;
                if (l3 < (long)n) {
                    runnable = this;
                    synchronized (runnable) {
                        this.wait((long)n - l3);
                    }
                } else {
                    runnable = thread;
                    Thread.yield();
                }
                l2 = this.totalTime;
                this.totalTime = 0 + (int)(System.currentTimeMillis() - l);
                this.deltaTime = this.totalTime - (int)l2;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void SquaresBackground(Graphics graphics) {
        for (int i = 0; i < 10; ++i) {
            int n = (i << 13) - (this.totalTime << 4 & 0x3FFF);
            int n2 = -16384 + (i << 13) + (this.totalTime << 4 & 0x3FFF);
            int n3 = 0;
            int n4 = 8192;
            int n5 = 3072 + 4096 * (i & 1);
            int n6 = 36864 - n5;
            graphics.setGrayScale(192);
            graphics.fillRect(this.xpos + (n * this.width >> 16), this.ypos + (n3 * this.width >> 16), 1 + (n4 * this.width >> 16), 1 + (n5 * this.width >> 16));
            graphics.setGrayScale(128);
            graphics.fillRect(this.xpos + (n2 * this.width >> 16), this.ypos + (n6 * this.width >> 16), 1 + (n4 * this.width >> 16), 1 + (n5 * this.width >> 16));
        }
    }

    void VectorLineEffect(Graphics graphics) {
        graphics.setGrayScale(0);
        this.spikeObj.RotateMatrix(this.totalTime / 8, this.totalTime / 5, this.totalTime / 10);
        this.spikeObj.RotateObject();
        this.spikeObj.ProjectObject(64, 10000, this.width, this.width);
        for (int i = 0; i < 64; ++i) {
            graphics.drawLine(this.xpos + this.width / 3 + this.spikeObj.prx[i * 2], this.ypos + this.height / 2 + this.spikeObj.pry[i * 2], this.xpos + this.width / 3 + this.spikeObj.prx[i * 2 + 1], this.ypos + this.height / 2 + this.spikeObj.pry[i * 2 + 1]);
        }
    }

    void ScrollSquares(Graphics graphics, int n) {
        graphics.setGrayScale(0);
        for (int i = 0; i < 8; ++i) {
            int n2 = (i & 1) == 1 ? 4608 : 1792;
            int n3 = n2 * 3 >> 1;
            int n4 = i * 6144 - (this.totalTime << 2) % 12288;
            int n5 = n - n3 / 2;
            graphics.fillRect(this.xpos + (n5 * this.width >> 16), this.ypos + ((n4 -= n2 / 2) * this.width >> 16), 1 + (n3 * this.width >> 16), 1 + (n2 * this.width >> 16));
        }
    }

    void RandomSquares(Graphics graphics) {
        int n;
        SdwUtil.Seed(4659);
        int n2 = n = 3072;
        for (int i = 0; i < 6; ++i) {
            int n3 = i * 4096;
            for (int j = 0; j < 9; ++j) {
                int n4 = (i + 1) * (14 - j) * 8;
                if (n4 >= 255) continue;
                graphics.setGrayScale(n4);
                int n5 = j * 4096;
                graphics.fillRect(this.xpos + (n3 * this.width >> 16), this.ypos + (n5 * this.width >> 16), 1 + (n * this.width >> 16), 1 + (n2 * this.width >> 16));
            }
        }
    }

    void SnurkelBackground(Graphics graphics, int n, int n2, int n3) {
        int n4 = n + n3 * 0;
        int n5 = n2 + n3 * 0;
        int n6 = n3 * 7;
        int n7 = n3 * 1;
        graphics.fillRect(this.xpos + (n4 * this.width >> 16), this.ypos + (n5 * this.width >> 16), 1 + (n6 * this.width >> 16), 1 + (n7 * this.width >> 16));
        n4 = n + n3 * 6;
        n5 = n2 + n3 * 1;
        n6 = n3 * 1;
        n7 = n3 * 6;
        graphics.fillRect(this.xpos + (n4 * this.width >> 16), this.ypos + (n5 * this.width >> 16), 1 + (n6 * this.width >> 16), 1 + (n7 * this.width >> 16));
        n4 = n + n3 * 0;
        n5 = n2 + n3 * 6;
        n6 = n3 * 6;
        n7 = n3 * 1;
        graphics.fillRect(this.xpos + (n4 * this.width >> 16), this.ypos + (n5 * this.width >> 16), 1 + (n6 * this.width >> 16), 1 + (n7 * this.width >> 16));
        n4 = n + n3 * 0;
        n5 = n2 + n3 * 2;
        n6 = n3 * 1;
        n7 = n3 * 4;
        graphics.fillRect(this.xpos + (n4 * this.width >> 16), this.ypos + (n5 * this.width >> 16), 1 + (n6 * this.width >> 16), 1 + (n7 * this.width >> 16));
        n4 = n + n3 * 1;
        n5 = n2 + n3 * 2;
        n6 = n3 * 4;
        n7 = n3 * 1;
        graphics.fillRect(this.xpos + (n4 * this.width >> 16), this.ypos + (n5 * this.width >> 16), 1 + (n6 * this.width >> 16), 1 + (n7 * this.width >> 16));
        n4 = n + n3 * 4;
        n5 = n2 + n3 * 3;
        n6 = n3 * 1;
        n7 = n3 * 2;
        graphics.fillRect(this.xpos + (n4 * this.width >> 16), this.ypos + (n5 * this.width >> 16), 1 + (n6 * this.width >> 16), 1 + (n7 * this.width >> 16));
        n4 = n + n3 * 2;
        n5 = n2 + n3 * 4;
        n6 = n3 * 2;
        n7 = n3 * 1;
        graphics.fillRect(this.xpos + (n4 * this.width >> 16), this.ypos + (n5 * this.width >> 16), 1 + (n6 * this.width >> 16), 1 + (n7 * this.width >> 16));
    }

    void IntroText(Graphics graphics) {
        graphics.setFont(this.myFont);
        if (this.totalTime < 6000) {
            int n;
            int n2;
            String string = "Shadow of";
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (this.totalTime < 3500) {
                    n = 512 + 10 * n2 - (this.totalTime >> 2);
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                } else {
                    n = -10 * n2 + (this.totalTime - 3500 >> 2);
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                }
                graphics.setGrayScale(n);
                graphics.drawString("" + string.charAt(n2), this.xpos + this.fontS + this.fontW / 2 + n2 * this.fontW, this.ypos + this.height / 3 - this.fontH / 2, 20);
            }
            string = "Noice";
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (this.totalTime < 3500) {
                    n = 768 + 10 * n2 - (this.totalTime >> 2);
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                } else {
                    n = -10 * n2 + (this.totalTime - 4500 >> 2);
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                }
                graphics.setGrayScale(n);
                graphics.drawString("" + string.charAt(n2), this.xpos + this.fontS + this.fontW * 5 / 2 + n2 * this.fontW, this.ypos + 2 * this.height / 3 - this.fontH / 2, 20);
            }
        } else if (this.totalTime < 9000) {
            String string = "presents";
            for (int i = 0; i < string.length(); ++i) {
                int n;
                if (this.totalTime < 7500) {
                    n = 512 + 10 * i - (this.totalTime - 5000 >> 2);
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                } else {
                    n = -10 * i + (this.totalTime - 7500 >> 2);
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                }
                graphics.setGrayScale(n);
                graphics.drawString("" + string.charAt(i), this.xpos + this.fontS + this.fontW + i * this.fontW, this.ypos + this.height / 2 - this.fontH / 2, 20);
            }
        } else {
            String string = "ProjectLCD";
            for (int i = 0; i < string.length(); ++i) {
                int n;
                if (this.totalTime < 11000) {
                    n = 512 + 10 * i - (this.totalTime - 8000 >> 2);
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                } else {
                    n = -10 * i + (this.totalTime - 11000 >> 2);
                    if (n > 255) {
                        n = 255;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                }
                graphics.setGrayScale(n);
                graphics.drawString("" + string.charAt(i), this.xpos + this.fontS + i * this.fontW, this.ypos + this.height / 2 - this.fontH / 2, 20);
            }
        }
    }

    void TwisterEffect(Graphics graphics) {
        for (int i = this.ypos; i < this.ypos + this.height; ++i) {
            int n = (i - this.ypos) * 36864 / this.height;
            int n2 = 8192 + SdwUtil.SinCalc(16384, (n >> 8) + (this.totalTime >> 3)) + this.totalTime;
            int n3 = 32768 + SdwUtil.CosCalc(8192, (n >> 7) + (this.totalTime >> 3)) + SdwUtil.SinCalc(3072, (n >> 6) + (this.totalTime >> 2));
            int n4 = (n2 &= 0x3FFF) / 64;
            graphics.setGrayScale(n4);
            graphics.drawLine(this.xpos + (n3 * this.width >> 16), i, this.xpos + ((n2 + n3) * this.width >> 16), i);
            n4 = (16383 - n2) / 64;
            graphics.setGrayScale(n4);
            graphics.drawLine(this.xpos + ((n2 + n3) * this.width >> 16), i, this.xpos + ((n3 + 16383) * this.width >> 16), i);
        }
    }

    void DrawHouse(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 65535;
        int n10 = 65535;
        int n11 = n;
        int n12 = n2;
        int n13 = n;
        int n14 = n2;
        if (n3 < n11) {
            n11 = n3;
            n12 = n4;
        }
        if (n5 < n11) {
            n11 = n5;
            n12 = n6;
        }
        if (n7 < n11) {
            n11 = n7;
            n12 = n8;
        }
        if (n3 > n13) {
            n13 = n3;
            n14 = n4;
        }
        if (n5 > n13) {
            n13 = n5;
            n14 = n6;
        }
        if (n7 > n13) {
            n13 = n7;
            n14 = n8;
        }
        if (!(n2 > n10 || n == n11 && n2 == n12 || n == n13 && n2 == n14)) {
            n10 = n2;
            n9 = n;
        }
        if (!(n4 > n10 || n3 == n11 && n4 == n12 || n3 == n13 && n4 == n14)) {
            n10 = n4;
            n9 = n3;
        }
        if (!(n6 > n10 || n5 == n11 && n6 == n12 || n5 == n13 && n6 == n14)) {
            n10 = n6;
            n9 = n5;
        }
        if (!(n8 > n10 || n7 == n11 && n8 == n12 || n7 == n13 && n8 == n14)) {
            n10 = n8;
            n9 = n7;
        }
        if (n9 == 65535) {
            n9 = n;
            n10 = n2;
        }
        SdwUtil.DrawTriangle(graphics, n9, n10, n11, n12, n13, n14);
        if (n12 > n14) {
            SdwUtil.DrawTriangle(graphics, n11, n12, n13, n14, n13, n12);
            graphics.fillRect(n11, n12, n13 - n11, this.height - (n12 - this.ypos));
        } else {
            SdwUtil.DrawTriangle(graphics, n11, n12, n13, n14, n11, n14);
            graphics.fillRect(n11, n14, n13 - n11, this.height - (n14 - this.ypos));
        }
    }

    void SkylineBackground(Graphics graphics) {
        int n = 0x800000;
        int n2 = 0x800000 / (this.height / 2);
        for (int i = this.ypos; i < this.ypos + this.height / 2; ++i) {
            int n3 = n >> 16;
            n += n2;
            graphics.setGrayScale(n3);
            graphics.drawLine(this.xpos, i, this.xpos + this.width, i);
        }
    }

    void CityEffect(Graphics graphics) {
        graphics.setGrayScale(0);
        this.cityObj.RotateMatrix(0, this.totalTime / 15, 0);
        this.cityObj.RotateObject();
        this.cityObj.ProjectObject(384, 10000, this.width, this.width);
        for (int i = 0; i < 9; ++i) {
            this.DrawHouse(graphics, this.xpos + this.width / 2 + this.cityObj.prx[i * 4 + 0], this.ypos + this.height / 2 + this.cityObj.pry[i * 4 + 0], this.xpos + this.width / 2 + this.cityObj.prx[i * 4 + 1], this.ypos + this.height / 2 + this.cityObj.pry[i * 4 + 1], this.xpos + this.width / 2 + this.cityObj.prx[i * 4 + 2], this.ypos + this.height / 2 + this.cityObj.pry[i * 4 + 2], this.xpos + this.width / 2 + this.cityObj.prx[i * 4 + 3], this.ypos + this.height / 2 + this.cityObj.pry[i * 4 + 3]);
        }
    }

    void MovieEffect(Graphics graphics) {
        int n;
        graphics.setGrayScale(128);
        int n2 = 15872;
        int n3 = 0;
        int n4 = 33792;
        int n5 = 36864;
        graphics.fillRect(this.xpos + (n2 * this.width >> 16), this.ypos + (n3 * this.width >> 16), 1 + (n4 * this.width >> 16), 1 + (n5 * this.width >> 16));
        graphics.setGrayScale(0);
        n2 = 12800;
        n3 = 0;
        n4 = 3072;
        n5 = 36864;
        graphics.fillRect(this.xpos + (n2 * this.width >> 16), this.ypos + (n3 * this.width >> 16), 1 + (n4 * this.width >> 16), 1 + (n5 * this.width >> 16));
        n2 = 49664;
        graphics.fillRect(this.xpos + (n2 * this.width >> 16), this.ypos + (n3 * this.width >> 16), 1 + (n4 * this.width >> 16), 1 + (n5 * this.width >> 16));
        n2 = 15872;
        n4 = 33792;
        n5 = 512;
        for (n = 0; n < 3; ++n) {
            n3 = n * 24576 - (this.totalTime << 2) % 24576;
            graphics.fillRect(this.xpos + (n2 * this.width >> 16), this.ypos + (n3 * this.width >> 16), 1 + (n4 * this.width >> 16), 1 + (n5 * this.width >> 16));
        }
        graphics.setGrayScale(255);
        n4 = 1536;
        n5 = 1024;
        for (n = 0; n < 8; ++n) {
            n2 = 13568;
            n3 = n * 6144 - (this.totalTime << 2) % 6144;
            graphics.fillRect(this.xpos + (n2 * this.width >> 16), this.ypos + (n3 * this.width >> 16), 1 + (n4 * this.width >> 16), 1 + (n5 * this.width >> 16));
            n2 = 50432;
            graphics.fillRect(this.xpos + (n2 * this.width >> 16), this.ypos + (n3 * this.width >> 16), 1 + (n4 * this.width >> 16), 1 + (n5 * this.width >> 16));
        }
        this.tetraObj.RotateMatrix(this.totalTime / 8, this.totalTime / 5, this.totalTime / 10);
        this.tetraObj.RotateObject();
        this.tetraObj.ProjectObject(64, 20000, this.width, this.width);
        n3 = 61440 - (this.totalTime << 2) % 73728;
        this.tetraObj.DrawSolidShaded(graphics, this.xpos + (32768 * this.width >> 16), this.ypos + (n3 * this.width >> 16));
        this.octaObj.RotateMatrix(this.totalTime / 6, this.totalTime / 9, this.totalTime / 7);
        this.octaObj.RotateObject();
        this.octaObj.ProjectObject(64, 21000, this.width, this.width);
        n3 = 61440 - ((this.totalTime << 2) + 24576) % 73728;
        this.octaObj.DrawSolidShaded(graphics, this.xpos + (32768 * this.width >> 16), this.ypos + (n3 * this.width >> 16));
        this.cubeObj.RotateMatrix(this.totalTime / 12, this.totalTime / 9, this.totalTime / 5);
        this.cubeObj.RotateObject();
        this.cubeObj.ProjectObject(64, 38000, this.width, this.width);
        n3 = 61440 - ((this.totalTime << 2) + 49152) % 73728;
        this.cubeObj.DrawSolidShaded(graphics, this.xpos + (32768 * this.width >> 16), this.ypos + (n3 * this.width >> 16));
    }

    void ArcEffect(Graphics graphics) {
        graphics.setGrayScale(0);
        for (int i = 0; i < 10; ++i) {
            int n;
            int n2 = (i & 1) == 1 ? SdwUtil.SinCalc(12288, this.totalTime >> 1) : SdwUtil.CosCalc(12288, this.totalTime >> 1);
            int n3 = 10240 + SdwUtil.CosCalc(8192, this.totalTime >> 3) + (n2 >> 1);
            int n4 = 4096 + SdwUtil.SinCalc(6144, this.totalTime >> 3) + (n2 >> 1);
            int n5 = n = 28672 - n2;
            graphics.fillArc(this.xpos + (n3 * this.width >> 16), this.ypos + (n4 * this.width >> 16), 1 + (n * this.width >> 16), 1 + (n5 * this.width >> 16), (36 * i + SdwUtil.SinCalc(90, this.totalTime >> 2)) % 360, 18);
        }
    }

    public void FadeClip(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n) {
            case 0: {
                n4 = 0;
                n6 = 65536;
                break;
            }
            case 1: {
                n4 = 32768 - n3 * 33;
                n6 = n3 * 66;
                break;
            }
            case 2: {
                n4 = 0;
                n6 = n3 * 66;
                break;
            }
            case 3: {
                n4 = 65536 - n3 * 66;
                n6 = n3 * 66;
            }
        }
        switch (n2) {
            case 0: {
                n5 = 0;
                n7 = 36864;
                break;
            }
            case 1: {
                n5 = 18432 - n3 * 19;
                n7 = n3 * 38;
                break;
            }
            case 2: {
                n5 = 0;
                n7 = n3 * 38;
                break;
            }
            case 3: {
                n5 = 36864 - n3 * 38;
                n7 = n3 * 38;
            }
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 > 65536) {
            n4 = 65536;
        }
        if (n5 > 36864) {
            n5 = 36864;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n7 > 36864) {
            n7 = 36864;
        }
        if (n6 > 65536) {
            n6 = 65536;
        }
        graphics.setClip(this.xpos + (n4 * this.width >> 16), this.ypos + (n5 * this.width >> 16), n6 * this.width >> 16, n7 * this.width >> 16);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2;
        Graphics graphics3 = graphics2 = this.offscreen == null ? graphics : this.offscreen.getGraphics();
        if (firstPaint) {
            graphics2.setGrayScale(0);
            graphics2.setClip(0, 0, this.getWidth(), this.getHeight());
            graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
            firstPaint = false;
        }
        graphics2.setGrayScale(255);
        graphics2.setClip(this.xpos, this.ypos, this.width, this.height);
        graphics2.fillRect(this.xpos, this.ypos, this.width, this.height);
        if (this.totalTime < this.partTime[0]) {
            this.IntroText(graphics2);
        } else if (this.totalTime < this.partTime[1]) {
            if (this.totalTime < this.partTime[0] + 2000) {
                int n = (this.totalTime - this.partTime[0]) / 2;
                this.FadeClip(graphics2, 1, 1, n);
            } else if (this.totalTime > this.partTime[1] - 2000) {
                int n = (this.totalTime - (this.partTime[1] - 2000)) / 2;
                this.FadeClip(graphics2, 1, 1, 1000 - n);
            } else {
                graphics2.setClip(this.xpos, this.ypos, this.width, this.height);
            }
            this.SquaresBackground(graphics2);
            this.VectorLineEffect(graphics2);
            this.ScrollSquares(graphics2, 53248);
        } else if (this.totalTime < this.partTime[2]) {
            if (this.totalTime < this.partTime[1] + 2000) {
                int n = (this.totalTime - this.partTime[1]) / 2;
                this.FadeClip(graphics2, 0, 2, n);
            } else if (this.totalTime > this.partTime[2] - 2000) {
                int n = (this.totalTime - (this.partTime[2] - 2000)) / 2;
                this.FadeClip(graphics2, 0, 3, 1000 - n);
            } else {
                graphics2.setClip(this.xpos, this.ypos, this.width, this.height);
            }
            this.RandomSquares(graphics2);
            this.TwisterEffect(graphics2);
        } else if (this.totalTime < this.partTime[3]) {
            if (this.totalTime < this.partTime[2] + 4000) {
                int n = (this.totalTime - this.partTime[2]) / 4;
                this.FadeClip(graphics2, 1, 0, n);
            } else if (this.totalTime > this.partTime[3] - 4000) {
                int n = (this.totalTime - (this.partTime[3] - 4000)) / 4;
                this.FadeClip(graphics2, 1, 0, 1000 - n);
            } else {
                graphics2.setClip(this.xpos, this.ypos, this.width, this.height);
            }
            this.MovieEffect(graphics2);
        } else if (this.totalTime < this.partTime[4]) {
            if (this.totalTime < this.partTime[3] + 2000) {
                int n = (this.totalTime - this.partTime[3]) / 2;
                this.FadeClip(graphics2, 2, 2, n);
            } else if (this.totalTime > this.partTime[4] - 2000) {
                int n = (this.totalTime - (this.partTime[4] - 2000)) / 2;
                this.FadeClip(graphics2, 3, 3, 1000 - n);
            } else {
                graphics2.setClip(this.xpos, this.ypos, this.width, this.height);
            }
            graphics2.setGrayScale(128);
            this.SnurkelBackground(graphics2, 19456, 5120, 4096);
            graphics2.setGrayScale(192);
            this.SnurkelBackground(graphics2, 17408, 3072, 4096);
            this.ArcEffect(graphics2);
        } else if (this.totalTime < this.partTime[5]) {
            if (this.totalTime < this.partTime[4] + 2000) {
                int n = (this.totalTime - this.partTime[4]) / 2;
                this.FadeClip(graphics2, 1, 0, n);
            } else if (this.totalTime > this.partTime[5] - 2000) {
                int n = (this.totalTime - (this.partTime[5] - 2000)) / 2;
                this.FadeClip(graphics2, 1, 0, 1000 - n);
            }
            this.SkylineBackground(graphics2);
            this.CityEffect(graphics2);
        } else if (this.totalTime >= this.partTime[6]) {
            this.stopAnimation();
            this.midlet.exitRequested();
        }
        if (this.bufTime > 0) {
            this.bufTime -= this.deltaTime;
            graphics2.setClip(this.xpos, this.ypos, this.width, this.height);
            graphics2.setFont(Font.getFont((int)32, (int)0, (int)0));
            graphics2.setGrayScale(0);
            if (this.offscreen == null) {
                graphics2.drawString("SW Buf: OFF", this.xpos, this.ypos, 20);
            } else {
                graphics2.drawString("SW Buf: ON", this.xpos, this.ypos, 20);
            }
        } else if (this.deltaTime > 0 && this.showFPS) {
            graphics2.setClip(this.xpos, this.ypos, this.width, this.height);
            graphics2.setFont(Font.getFont((int)32, (int)0, (int)0));
            graphics2.setGrayScale(0);
            graphics2.drawString("" + 1000 / this.deltaTime + " fps", this.xpos, this.ypos, 20);
        }
        if (this.offscreen != null) {
            graphics.drawImage(this.offscreen, 0, 0, 20);
        }
    }

    public void keyPressed(int n) {
        if (n == 48) {
            boolean bl = this.showFPS = !this.showFPS;
        }
        if (n == 42) {
            if (this.offscreen == null) {
                this.offscreen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
                firstPaint = true;
                this.bufTime = 1000;
            } else {
                this.offscreen = null;
                firstPaint = true;
                this.bufTime = 1000;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.stopAnimation();
            this.midlet.exitRequested();
        }
    }
}

