/*--------------------------------------------------------------------
 * File: poly.c
 * Version: SAGA 4.0
 *
 * Written by: Fredrik Kling, 1997-05-11
 * Description: First layout for rendring routines...
 *
 * Updates:
 * -- Date -- | --- Name ---- |-- Did what....
 * 1997-05-11 | Fredrik Kling | Implementation
 *
 * Todo:
 *    Se ver parametrarna...
 *	  Material support!!!
 *
 *
 *------------------------------------------------------------------------*/
#include "render/polydraw.h"
#include "drivers/drv8.h"
#include "objects/object.h"
#include "formats/v3o.h"
#include "misc/col.h"


extern palette[];
//extern DRV *drv;		// Graphics driver... used by our little engine...


void wire_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
	p1.l=32;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
	p2.l=32;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
	p3.l=32;
/*
	drv->line (p1,p2,255);		// Always white...
	drv->line (p2,p3,255);
	drv->line (p3,p1,255);
*/
}
void flat_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,int c,float l)
{
	XYZ p1,p2,p3;
/*
  if (l >= LIGHTLEVELS) l = LIGHTLEVELS - 1;
	else if (l<0) l=0;
*/

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
  p1.z=v[sf->v1].z;
	p1.l=l;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
  p2.z=v[sf->v2].z;
	p2.l=l;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
  p3.z=v[sf->v3].z;
	p3.l=l;

	//if ((p1.z<0) && (p2.z<0) && (p3.z<0))
	drv->poly ( p1, p2, p3, (BYTE)c);
}
void gourade_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,int c,float l1,float l2,float l3)
{
	XYZ p1,p2,p3;
/*
 	if (l1 >= LIGHTLEVELS) l1 = LIGHTLEVELS-1;
	 else if (l1<0) l1=0;
  if (l2 >= LIGHTLEVELS) l2 = LIGHTLEVELS-1;
	 else if (l2<0) l2=0;
  if (l3 >= LIGHTLEVELS) l3 = LIGHTLEVELS-1;
	 else if (l3<0) l3=0;
*/
	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
  p1.z=v[sf->v1].z;
	p1.l=l1;


	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
  p2.z=v[sf->v2].z;
	p2.l=l2;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
  p3.z=v[sf->v3].z;
	p3.l=l3;

	//drv->poly( p1, p2, p3, (BYTE)c);
}
void texture_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,V3OTEXTURE *tex)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
  p1.tx=sf->tx1;
  p1.ty=sf->ty1;
	p1.l = 63;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
  p2.tx=sf->tx2;
  p2.ty=sf->ty2;
	p2.l = 63;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
  p3.tx=sf->tx3;
  p3.ty=sf->ty3;
	p3.l = 63;

	drv->tpoly (p1,p2,p3,tex->image->image8);
}
void texture_flat_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,float l,V3OTEXTURE *tex)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
  p1.tx=sf->tx1;
  p1.ty=sf->ty1;
	p1.l = l;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
  p2.tx=sf->tx2;
  p2.ty=sf->ty2;
	p2.l = l;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
  p3.tx=sf->tx3;
  p3.ty=sf->ty3;
	p3.l = l;

	drv->tpoly (p1,p2,p3,tex->image->image8);
}
void texture_gourade_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,float l1, float l2, float l3,V3OTEXTURE *tex)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
  p1.tx=sf->tx1;
  p1.ty=sf->ty1;
	p1.l = l1;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
  p2.tx=sf->tx2;
  p2.ty=sf->ty2;
	p2.l = l2;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
  p3.tx=sf->tx3;
  p3.ty=sf->ty3;
	p3.l = l3;

	drv->tpoly (p1,p2,p3,tex->image->image8);
}












