/*--------------------------------------------------------------------------
 * File: dpmi.c
 * Written by: Alexander Boczar, 1997-05-12
 * Description: DPMI functions (x86 only)
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-xx-xx | Alexander Boczar |
 *
 -------------------------------------------------------------------------------*/

#include "system/xstring.h"
#include "system/xstdlib.h"
#include "system/dpmi.h"
#include <i86.h>

int _dpmi_dosalloc( DWORD length, WORD *selector, WORD *segment)
{
  union REGS r;
  struct SREGS s;

	memset( &r, 0, sizeof( r));
	memset( &s, 0, sizeof( s));

  r.w.ax = 0x0100;
  r.w.bx = (length + 15) >> 4;
  int386x( 0x31, &r, &r, &s);
	if( r.w.cflag)
		return( FALSE);

  *segment = r.w.ax;
  *selector = r.w.dx;

	return( TRUE);
}

void _dpmi_dosfree( WORD selector)
{
  union REGS r;
  struct SREGS s;

	memset( &r, 0, sizeof( r));
	memset( &s, 0, sizeof( s));

  r.w.ax = 0x0101;
  r.w.dx = selector;
  int386x( 0x31, &r, &r, &s);
}

void *_dpmi_mapmem( void *pointer, DWORD length)
{
  union REGS r;
  struct SREGS s;

	memset( &r, 0, sizeof( r));
	memset( &s, 0, sizeof( s));

  r.w.ax = 0x0800;
  r.w.bx = ((DWORD)pointer) >> 16;
  r.w.cx = ((DWORD)pointer) & 0xffff;
  r.w.si = length >> 16;
  r.w.di = length & 0xffff;
  int386x( 0x31, &r, &r, &s);
	return( (void *)((DWORD)(r.w.bx << 16) + r.w.cx));
}

void _dpmi_realmodeint( BYTE intnum, RMREGS *regs)
{
  union REGS r;
  struct SREGS s;

	memset( &r, 0, sizeof( r));
	memset( &s, 0, sizeof( s));

  r.w.ax = 0x0300;
  r.h.bl = intnum;
  r.h.bh = 0;
  r.w.cx = 0;
  s.es = FP_SEG(regs);
  r.x.edi = FP_OFF(regs);
  int386x( 0x31, &r, &r, &s );
}

