#pragma once

//#ifndef __XMATH_H
//#define __XMATH_H

#ifdef __WATCOMC__
#pragma library("system.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif
//---------------------------------------------------------------------------//

#include "system/xstddef.h"
#include <math.h>
#include <float.h>

#if !defined(M_PI)
#define M_PI 3.1415926535897932384
#endif

#define SQR(__v) ((__v)*(__v))

#if defined(__X86__)
extern double fpchop_magic;
extern double fpchop_temp;
extern WORD ffrac_control;
extern float ffrac_temp;
extern float fchop_temp;
#endif

#if defined(__WATCOMC__)

float ffrac( float);
#pragma aux ffrac "*" =\
  "fstcw ffrac_control"\
  "push ffrac_control"\
  "and ffrac_control,0f0ffh"\
  "or ffrac_control,00e00h"\
  "fldcw ffrac_control"\
  "fld st(0)"\
  "fistp ffrac_temp"\
  "fild ffrac_temp"\
	"fsubp st(1),st"\
  "pop ffrac_control"\
  "fldcw ffrac_control"\
  parm [8087] value[8087];

int fchop( float);
#pragma aux fchop "*" =\
  "fistp fchop_temp"\
  "mov eax,fchop_temp"\
	parm [8087] value[eax];

int fpchop( float);
#pragma aux fpchop "*" =\
	"fadd fpchop_magic"\
  "fstp fpchop_temp"\
  "mov eax,dword ptr fpchop_temp"\
  "add eax,80000000h"\
	parm [8087] value[eax];

#elif defined(__X86__)

__inline float ffrac( float f)
{
	float r;
	__asm
	{
		fld f
		fistp r
		fild r
		fsubrp st(1),st(0)
		fstp r
	}
	return( r);
}

__inline int fchop( float f)
{
	int r;
	__asm
	{
		fld f
		fistp r
	}
	return( r);
}

_inline DWORD fpchop( float f)
{
	DWORD r[2];
	__asm
	{
		fadd fpchop_magic
		fstp qword ptr r
	}
	return( r[0]);
}

#else

#define ffrac(x) (float)(x - (int)x)
#define fchop(x) (int)x
#define fpchop(x) (DWORD)x

#endif


//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif
//#endif
