/*--------------------------------------------------------------------------
 * File: 2vio.c
 * Written by: Alexander Boczar & Fredrik Kling..
 * Description: GIF/Targa/PCX/TIF/SCX/PPM/BMP to VIO converter
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-12-12 | Fredrik Kling    | Stuff....
 * 1997-xx-xx | Alexander Boczar |
 *
 *
 * Todo:
 *
 -------------------------------------------------------------------------------*/

#include "system/xstddef.h"
#include "formats/vio.h"
#include "formats/gif.h"
#include "formats/tga.h"
#include "formats/pcx.h"

void usage (void)
{
	printf ("usage: 2vio -<switches> [input] [output]\n");
	printf ("Input images can be in: .gif, .tif, .pcx, .scx, .bmp, .ppm\n");
	printf ("Output only in .vio\n");
	printf ("switches:\n");
	printf ("  8/16/24/32 : number of bits in output!\n");
	printf ("	 -s         : strip vio-file from data\n");
	printf ("  h,?        : this screen\n");
	printf ("  x<size>    : new x-size \n");
	printf ("  y<size>    : new y-size \n");
	exit (1);
}
int main( int argc, char *argv[])
{
	VIO *image;
	char input[128],output[128];
	int in,out,xsize,ysize,bits,i,strip,sbits;

	strip = in = out = FALSE;
	xsize = ysize = bits = sbits = -1;


	printf ("argc:%i\n",argc);
	if (argc<2) usage ();

	for (i=1;i<argc;i++)
	{
		printf ("arg: %i, %s\n",i,argv[i]);
		if ((argv[i][0]=='-') || (argv[i][0]=='/'))
		{
			switch (argv[i][1])
			{
				case 'h' :
				case '?' : usage (); break;
				case 's' : strip = TRUE; sbits = atoi (argv[i+1]); i++; break;
				case 'x' : xsize = atoi (argv[i+1]); i++; break;
				case 'y' : ysize = atoi (argv[i+1]); i++; break;
				default : bits = atoi (&argv[i][1]); break;
			}
		} else
			{
				if (in!=TRUE)
				{
					sprintf (input,"%s",argv[i]);
					in = TRUE;
				} else if (out!=TRUE)
					{
						sprintf (output,"%s",argv[i]);
						out = TRUE;
					} else
						{
							printf ("[!] Unable to handle multiple files.. (sorry)\n");
							usage ();
						}
			}
	} // for

	if (in!=TRUE)
	{
		printf ("[Error] No input image.\n");
		usage();
	}
	printf ("Converting..\n");
  image = vio_load( input);
  if( image == NULL) image = gif_load( input);
	if( image == NULL) image = pcx_load( input);
  if( image == NULL) image = tga_load( input);
  if( image != NULL)
  {
    printf("- Loaded %dx%dx%d image\n", image->width, image->height, (image->flags&VIOFLAG_8BIT)?8:(image->flags&VIOFLAG_24BIT)?24:(image->flags&VIOFLAG_16BIT)?16:24);
		if (out!=TRUE)
		{
			printf ("[Warning] No output file specified, using: \"output.vio\"");
			sprintf (output,"output.vio");
		}

		if (bits!=-1)
		{
			switch (bits)
			{
				case 8 : vio_make8bit (image); break;
				case 16 : printf ("Converting to 16 bits!\n");
									if (vio_make16bit (image)!=TRUE)
											printf ("[Error] Unable to convert to 16 bits!\n");
									break;
				case 24 : printf ("[sorry] No yet supported!\n"); /* vio_make24bit (image); */ break;
				case 32 : printf ("Converting to 32 bits!\n");
									if (vio_make32bit (image)!=TRUE)
											printf ("[Error] unable to convert to 32 bits!\n");
									break;
				default : printf ("[Error] Unknown output bit-format only (8,16,24,32 bits)\n"); usage (); break;
			}
			printf ("- Output fileformat: %i\n",bits);
		}
		if (strip)
		{
			switch (sbits)
			{
				case 8 :
						if (image->flags & VIOFLAG_8BIT) image->flags = image->flags ^ VIOFLAG_8BIT;
						break;
				case 16 :
						if (image->flags & VIOFLAG_16BIT) image->flags = image->flags ^ VIOFLAG_16BIT;
						break;
				case 24 :
						if (image->flags & VIOFLAG_24BIT) image->flags = image->flags ^ VIOFLAG_24BIT;
						break;
				case 32 :
						if (image->flags & VIOFLAG_32BIT) image->flags = image->flags ^ VIOFLAG_32BIT;
						break;
				default :
						printf ("[Error] Unknown strip-bit format only (8,16,24,32 bit supported)\n");

			}
		}

    vio_save(output, image);
    printf("- Saved VIO file to %s\n", output);
  }
	else printf("[Error] Failed while loading %s\n", input);

  return( 0);
}
