#pragma once

#ifdef __WATCOMC__
#pragma library("vgui.lib")
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include "drivers/drv8.h"
#include "vgui/vguiwin.h"
#include "vgui/vguigad.h"
#include "vgui/vguidbox.h"

/*---------------------------------------------------------------------------//
 *
 * This file contains all defines for functions and messages handled by vgui
 *
 *---------------------------------------------------------------------------*/

#define MAXMESSAGE 512

typedef struct s_VGUICLIST VGUICLIST;
typedef struct s_fontofs FONTOFS;
typedef short int FONT;

typedef struct s_VGUIMESSAGE VGUIMESSAGE;
typedef struct s_applist APPLIST;

typedef enum
{
 	APPFLAG_DIALOG = 1 << 0,
	APPFLAG_NORMAL = 1 << 1

} APPFLAGS;

struct s_applist
{
	int flags;
	VGUIWIN  *win;
	APPLIST *next,*prev;
};

struct s_fontofs
{
	short int width,yoffs,rows,cols;
	char data[];
};

struct s_VGUICLIST
{
	int ci[256];
};

struct s_VGUIMESSAGE
{
	int handle;
	int message;
	int p1,p2,p3;
};
// Messages

#define VG_COMMAND 	1000
#define VG_HSCROLL	1002
#define VG_VSCROLL 	1003
#define VG_GADGET  	1004
#define VG_MENUBAR 	1005
#define VG_KEYDOWN 	1006
#define VG_KEYUP   	1007
#define VG_KEYPRESS 1008
#define VG_MPOS 	 	1009
#define VG_MPRESS 	1010
#define VG_MRELEASE	1011
#define VG_SIZE			1012
#define VG_HELLOW   1013

#define VG_CBACK		0
#define VG_CBLACK		0
#define VG_CDARK		1
#define VG_CMEDIUM	2
#define VG_CLIGHT		3
#define VG_CMBLUE   4
#define VG_CDBLUE   5
#define VG_CLGREEN	7
#define VG_CMGREEN	8
#define VG_CDGREEN	9
#define VG_CLYELLOW 10
#define VG_CMYELLOW 11
#define VG_CDYELLOW 12
#define VG_CLRED		13
#define VG_CMRED		13
#define VG_CDRED		13

#define VG_CWHITE   255

#define VG_COLINACTIVE VG_CDGREEN
#define VG_COLACTIVE VG_CDBLUE


#define VGS_EXIT		6000
#define VGS_UPDATE	6001
#define VGS_CLEAR	  6002
#define VGS_REDRAW  6003
#define VGS_COMMAND 6004
#define VGS_SWITCHAPP	6005
#define VGS_GADREDRAW 6006
#define VGS_GADUPDATE 6007

#define VGC_MBAR    8000
#define VGC_BUTTON	8001
#define VGC_LISTBOX	8002
#define VGC_SLIDE		8003
#define VGC_CHECK		8004
#define VGC_SBOX  	8005

#define VG_ID_OK			7000
#define VG_ID_NO	  	7001
#define VG_ID_CANCLE  7002
#define VG_ID_YES			7003
#define VG_ID_GOAT		7004

#define VG_XKEYSHBSPACE 15
#define VG_XKEYUP		72
#define VG_XKEYDOWN	80
#define VG_XKEYLEFT	75
#define VG_XKEYRIGHT	77
#define VG_XKEYF1		59
#define VG_XKEY_ALT_TAB 165

// Key defines for ALT+key (only trap alphapet!!)

#define VG_XALT_A		30
#define VG_XALT_B		48
#define VG_XALT_C		46
#define VG_XALT_D		32
#define VG_XALT_E		18
#define VG_XALT_F		33
#define VG_XALT_G		34
#define VG_XALT_H		35
#define VG_XALT_I		23
#define VG_XALT_J		36
#define VG_XALT_K		37
#define VG_XALT_L		38
#define VG_XALT_M		50
#define VG_XALT_N		49
#define VG_XALT_O		24
#define VG_XALT_P		25
#define VG_XALT_Q		16
#define VG_XALT_R		19
#define VG_XALT_S		31
#define VG_XALT_T		20
#define VG_XALT_U		22
#define VG_XALT_V		13	// MISSED!!
#define VG_XALT_W		17
#define VG_XALT_X		45
#define VG_XALT_Y		21
#define VG_XALT_Z		44


#define VG_KEYBSPACE 8
#define VG_KEYTAB    9
#define VG_KEYESC		27
#define VG_KEYENTER	13
#define VG_KEYSPACE 32



#define VG_INIT			2000
// Functions

void vgui_zapmbox (void);
int vgui_postmessage (int, int, int, int);
int vgui_peekmessage (int, int *,int *,int *,int *);
int vgui_spawnmessagebox (void);
int vgui_init (DRV *, int);
int vgui_getcol (int);
FONT *vgui_loadfont (char *);

int vgui_charwidth (char);
int vgui_strlen (char *);
int vgui_putchxy (int,int,int,char);
int vgui_printfxy (int,int,char *,...);
int vgui_printfxyc (int,int,int,char *,...);
int vgui_getsxyc (int , int , int, int, int , char *);
int vgui_outstrxy (int,int,int,char *);
void vgui_line (int x1,int y1,int x2,int y2,int c);
void vgui_copybuff (int, int);
void vgui_xcopybuff (int x1, int y1, int x2, int y2);
void vgui_xmovebuff (int x1, int y1, int x2, int y2,int c);
void vgui_bar (int x1, int y1, int x2, int y2,int c);

int vgui_register (VGUIWIN *);
int vgui_registerdbox (VGUIDBOX *dbox);
VGUIWIN *vgui_activewin (void);
int vgui_main (void);
APPLIST *app_dboxfrmhand (int handle);
APPLIST *app_getcurrent (int *status);
void app_setcurrent (APPLIST *app,int status);


void vgui_checkkeys (void);



int vgui_kbhit (void);
int vgui_getkey (void);

KEYL *vgui_setxkeylist (KEYL *keyl,int num);
KEYL *vgui_clearxkeylist (void);
void vgui_addtabstop (int mess, int p1, int p2, int p3);
DRV *vgui_getdriver (void);


//---------------------------------------------------------------------------//
#ifdef __cplusplus
}
#endif


