/*****************************************************************************
 *
 * File: vguidab.c, Fredrik Kling 1997
 * Desc: Just a simple gadget for borders...
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-12 | Fredrik Kling    | Implementation
 *
 ****************************************************************************/
#include "vgui/vgui.h"
#include "vgui/vguidab.h"

BUFF *vguidab_init (DRV *drv,int x1, int y1, int x2, int y2)
{
	BUFF *buff;
	int w,h;

	w = x2 - x1;
	h = y2 - y1;

	buff = drv->createbuff (w,h);
	buff -> lighttab = NULL;
	buff -> transtab = NULL;
//	buff -> zbuffer = NULL;
	return buff;

}
void vguidab_draw (DRV *drv,BUFF *buff,int x1, int y1)
{
	BUFF *old;
	old = drv->activebuff;
	drv->setbuff (buff);
	drv->copybuff (x1,y1);
	drv->setbuff (old);
}
void vguidab_redraw (DRV *drv, BUFF *buff,int x1, int y1)
{
	BUFF *old;
	old = drv->activebuff;
	drv->setbuff (buff);
	drv->movebuff (x1,y1,VG_CBLACK);
	drv->setbuff (old);
}
void vguidab_clear (DRV *drv, BUFF *buff)
{
	BUFF *old;
	old = drv->activebuff;
	drv->setbuff (buff);
	drv->clearbuff (VG_CBLACK);
	drv->setbuff (old);
}


