/*****************************************************************************
 *
 * File: vguidbox.c, Fredrik Kling 1997
 * Desc: Dialog box routines...  handling and so on...
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-16 | Fredrik Kling    | Implementation
 *
 * Todo:
 *
 ****************************************************************************/
#include "system/xstdio.h"
#include "system/xstdlib.h"
#include "system/xstring.h"
#include "vgui/vgui.h"
#include "vgui/vguidbox.h"

VGUIDBOX *vguidbox_create (int x1, int y1, int x2, int y2, char *caption,int handle)
{
	VGUIDBOX *dbox;

	dbox = (VGUIDBOX *)xmalloc (sizeof (VGUIDBOX));

	dbox -> x1 = x1;
	dbox -> y1 = y1;
	dbox -> x2 = x2;
	dbox -> y2 = y2;
	dbox -> handle = handle;

	dbox -> caption = NULL;
	dbox -> mbar = NULL;
	dbox -> gadgetlist = NULL;

	dbox -> id = dbox -> numgadget = dbox -> xkeynum = dbox->tabnum = 0;


	if (caption!=NULL)
	{
		dbox -> caption = (char *) xmalloc (strlen (caption)+1);
		sprintf (dbox->caption,"%s",caption);

	} else dbox->caption = NULL;



	vgui_registerdbox (dbox);

	return dbox;
}
int vguidbox_run (int handle)
{
	APPLIST *old;
	APPLIST *dbox;

	int q=FALSE;
	int status;

	dbox = app_dboxfrmhand (handle);

	old = app_getcurrent (&status);
	app_setcurrent (dbox,APPFLAG_DIALOG);

	vgui_postmessage (VG_HELLOW,0,0,0);
	vgui_postmessage (VGS_REDRAW,0,0,0);

	while (!q)
	{
		vgui_checkkeys ();
		if (!vgui_spawnmessagebox ()) q=TRUE;
	}

	app_setcurrent (old,status);
	vgui_postmessage (VGS_REDRAW,0,0,0);

	return TRUE;
}



