/*****************************************************************************
 *
 * File: vguimbar.c, Fredrik Kling 1997
 * Desc: This file holds all main gui handling routines... (font,drivers,devices etc).
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-03 | Fredrik Kling    | Implementation
 *
 ****************************************************************************/

#include "vgui/vgui.h"
#include "vgui/vguiwin.h"
#include "system/xstdlib.h"
#include "system/xstdio.h"
#include <malloc.h>

/************************************************************************
 * Func: vguimbar_create
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Skapar en menybar
 *
 ************************************************************************/
VGUIMBAR *vguimbar_create (void)
{
	VGUIMBAR *mbar;

	mbar = (VGUIMBAR *) xmalloc (sizeof (VGUIMBAR));
	mbar -> numitem = 0;
	mbar -> handle = 0;
	mbar -> list = NULL;

	return mbar;
}
/************************************************************************
 * Func: vguimbar_insertbaritem
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Lgger in en tom meny i baren.
 *
 ************************************************************************/

int vguimbar_insertbaritem (VGUIMBAR *mbar, int handle,char *caption)
{
	VGUIMBARITEM *b_new;
	int ofs,s;


	ofs = mbar->numitem;
	mbar->numitem++;

	if (mbar->list==NULL)	mbar->list = (VGUIMBARITEM *) xmalloc (sizeof (VGUIMBARITEM) * mbar->numitem);
	else
	{
		s = sizeof (VGUIMBARITEM) * mbar->numitem;
 		if ((b_new = realloc (mbar->list,s))==NULL)	return FALSE;
		mbar->list = b_new;
	}
	mbar->list[ofs].handle = handle;
	sprintf (mbar->list[ofs].caption,"%s",caption);
	mbar->list[ofs].numitem = 0;
	mbar->list[ofs].list = NULL;
	return TRUE;
}
/************************************************************************
 * Func: vguimbar_insertlistitem
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Lgger in ett val i en meny p baren.
 *
 ************************************************************************/
int vguimbar_insertlistitem (VGUIMBAR *mbar,int itemhandle, int handle, char *caption, int spec)
{
	VGUIMBARITEMLIST *b_new;

	int ofs=0,s,lp;

	while ((mbar->list[ofs].handle!=itemhandle) && (ofs<mbar->numitem)) ofs++;

	if (ofs>=mbar->numitem) return FALSE;

	lp = mbar->list[ofs].numitem;
	mbar->list[ofs].numitem++;

	if (mbar->list[ofs].list==NULL) mbar->list[ofs].list = (VGUIMBARITEMLIST *) xmalloc (sizeof (VGUIMBARITEMLIST) * mbar->list[ofs].numitem);
	else
	{
		s = sizeof (VGUIMBARITEMLIST) * mbar->list[ofs].numitem;
		if ((b_new = realloc (mbar->list[ofs].list,s))==NULL) return FALSE;
		mbar->list[ofs].list = b_new;
	}
	mbar->list[ofs].list[lp].handle = handle;
	sprintf (mbar->list[ofs].list[lp].caption,"%s",caption);
	if (spec!=0) mbar->list[ofs].list[lp].flags=spec;
	  else mbar->list[ofs].list[lp].flags=VGUIMBAR_NORMAL;
	mbar->list[ofs].list[lp].sublist=NULL;

	return TRUE;

}
/************************************************************************
 * Func: vguimbar_dispose
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Ska ta bort en meny...
 *
 ************************************************************************/
VGUIMBAR *vguimbar_dispose (VGUIMBAR *mbar)
{
	xfree (mbar);
	return NULL;
}
/************************************************************************
 * Func: vguimbar_choice
 * Auth: Fredrik Kling
 * Date: 1997-08-04 - Implementation
 *
 * Desc: Lgger i dvala...
 *
 ************************************************************************/
int vguimbar_ofsfrmhand (int handle)
{
	VGUIWIN *win = vgui_activewin ();
	int ofs=0;

	while ((win->mbar->list[ofs].handle!=handle) && (ofs<win->mbar->numitem)) 	ofs++;

	return ofs;
}
int vguimbar_getitemhandle (int handle, int sel)
{
	VGUIWIN *win = vgui_activewin ();
	int ofs;

	ofs = 0;

	while ((win->mbar->list[ofs].handle!=handle) && (ofs<win->mbar->numitem))	ofs++;
	return (win->mbar->list[ofs].list[sel].handle);
}
int vguimbar_nextbaritem (int handle)
{
	VGUIWIN *win = vgui_activewin ();
	int ofs;
	ofs = 0;
	while ((win->mbar->list[ofs].handle!=handle) && (ofs<win->mbar->numitem))	ofs++;
	ofs++;
	if (ofs>=win->mbar->numitem) return win->mbar->list[0].handle;
	return win->mbar->list[ofs].handle;
}
int vguimbar_prevbaritem (int handle)
{
	VGUIWIN *win = vgui_activewin ();
	int ofs;
	ofs = 0;
	if (win->mbar->list->numitem<0) return handle;
	while ((win->mbar->list[ofs].handle!=handle) && (ofs<win->mbar->numitem))	ofs++;

	ofs-=1;
	if (ofs<0) return (win->mbar->list[win->mbar->numitem-1].handle);
	return win->mbar->list[ofs].handle;
}
void vguimbar_choice (int handle)
{
	int k1,k2,q,sel,d=0,np,rd,ofs;

	q=np=rd=FALSE;

	vguiwin_mbarpulldown (handle);
	sel = vguiwin_mbarselect (handle,0);

	vgui_copybuff (0,0);

	sel = 0;

	while (!q)
	{
		while (vgui_kbhit())
		{
			k2 = 0;
			switch (k1=vgui_getkey())
			{
				case 0 :
					switch (k2 = vgui_getkey())
					{
						case VG_XKEYDOWN :	sel++;
															  ofs = vguimbar_ofsfrmhand (handle);
														    if (vgui_activewin()->mbar->list[ofs].list[sel].flags & VGUIMBAR_SEPARATOR) sel++;
															  d=1;
																break;
					 	case VG_XKEYUP : sel--;
													   ofs = vguimbar_ofsfrmhand (handle);
												     if (vgui_activewin()->mbar->list[ofs].list[sel].flags & VGUIMBAR_SEPARATOR) sel--;
													   d=1;
														 break;
						case VG_XKEYLEFT : handle = vguimbar_prevbaritem (handle); sel = 0; d=1; rd = TRUE; break;
						case VG_XKEYRIGHT: handle = vguimbar_nextbaritem (handle); sel = 0; d=1; rd = TRUE; break;
					}
					break;

				case VG_KEYESC :
					q = TRUE;
					np = TRUE;	// Stt nopost flaggan..
					break;
				case VG_KEYENTER :
					q = TRUE;
					break;
			}
			// Process key...
		}
		if (d)
		{
			if (rd)
			{
				vguiwin_update(NULL);
				vguiwin_mbarpulldown (handle);
				sel = vguiwin_mbarselect (handle,sel);
				vgui_copybuff (0,0);
				vgui_zapmbox ();
			}
			else
			{
				sel = vguiwin_mbarselect (handle,sel);
				vgui_copybuff (0,0);
			}
			d=0;
		}
	}
	if (!np) vgui_postmessage (VG_COMMAND, VGC_MBAR, vguimbar_getitemhandle (handle,sel), 0);
	vgui_postmessage (VGS_REDRAW, 0, 0, 0);
}


