/*****************************************************************************
 *
 * File: vguibutt.c, Fredrik Kling 1997
 * Desc: This file holds all main button handling routines...
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-08-12 | Fredrik Kling    | Implementation
 *
 ****************************************************************************/
#include "vgui/vgui.h"
#include "system/xstdio.h"
#include "vgui/vguisbox.h"

void vguisbox_draw (int x1, int y1, int x2, int y2, char *caption,char *str)
{

	vgui_printfxyc (x1,y1,VG_CBLACK,"%s",caption);

	y1+=8;

	vgui_line (x1, y1,x2,y1,VG_CDARK);
	vgui_line (x1, y1,x1,y2,VG_CDARK);
	vgui_line (x1, y2,x2+1,y2,VG_CLIGHT);
	vgui_line (x2, y1,x2,y2,VG_CLIGHT);

	vgui_bar (x1+1,y1+1,x2,y2,VG_CBLACK);

	vgui_printfxyc (x1+2,y1+2,VG_CMEDIUM,"%s",str);
}

void vguisbox_highlight (int x1, int y1, int x2, int y2, char *caption,char *str)
{
	vgui_printfxyc (x1,y1,VG_CWHITE,"%s",caption);

	y1+=8;

	vgui_bar (x1+1,y1+1,x2,y2,VG_CBLACK);

	vgui_line (x1+1, y1+1,x2-1,y1+1,VG_CWHITE);
	vgui_line (x1+1, y1+1,x1+1,y2-1,VG_CWHITE);
	vgui_line (x1+1, y2-1,x2,y2-1,VG_CWHITE);
	vgui_line (x2-1, y1+1,x2-1,y2-1,VG_CWHITE);


	vgui_printfxyc (x1+2,y1+2,VG_CMEDIUM,"%s",str);
}
void vguisbox_select (int x1, int y1, int x2, int y2, char *caption, char *str)
{
	char lstr[256];
	int xp,yp;
	lstr[0]='\0';
	sprintf (lstr,"%s",str);
	y1+=8;
	vgui_line (x1+1, y1+1,x2-1,y1+1,VG_CBLACK);
	vgui_line (x1+1, y1+1,x1+1,y2-1,VG_CBLACK);
	vgui_line (x1+1, y2-1,x2,y2-1,VG_CBLACK);
	vgui_line (x2-1, y1+1,x2-1,y2-1,VG_CBLACK);
	if (!vgui_getsxyc (x1+2,y1+2,x2-2,y2-2,VG_CWHITE,lstr))
	{
		vgui_bar (x1+1,y1+1,x2,y2,VG_CBLACK);
	} else sprintf (str,"%s",lstr);
	vguisbox_highlight (x1,y1-8,x2,y2,caption,str);
}


