/*
  File: 3dmath.c
  Version: SAGA 4.0
  Written by: Fredrik Kling, 1997-03-05
  Description: System file for 3dmath lib...

  Updates: Alot, mainly fixes with the camera.
  -- Date -- | --- Name ---- |-- Did what....
  1997-05-03 | Fredrik Kling | Implementation

*/

#include "system/xmath.h"
#include "system/xstdio.h"
#include "system/xstdlib.h"
#include "system/xstring.h"
#include "vmath/vmath.h"
#include "vmath/vector.h"

float *sintable;
VECTOR X_AX={1.0,0.0,0.0};
VECTOR Y_AX={0.0,1.0,0.0};
VECTOR Z_AX={0.0,0.0,1.0};

void mathinit ()
{
  int i;
  sintable=(float *)xmalloc( sizeof(float) * (SINESIZE + SINESIZE/4));
  for( i=0; i<(SINESIZE+SINESIZE/4); i++)
    sintable[i]= (float)sin( (float)i * 2.0 * M_PI / SINESIZE );
}
void mathclose ()
{
  xfree (sintable);
}

