/*--------------------------------------------------------------------------
 * File: plot.c
 * Written by: Alexander Boczar, 1997-03-29
 * Description: Plotter for lookup color based drivers.
 *
 * Updates:
 * -- Date -- | ----- Name ----- |-- Did what....
 * 1997-04-02 | Alexander Boczar | Snabbade upp ngt med constanta varibler
 *
 -------------------------------------------------------------------------------*/

#include "drivers/drv8.h"
#include "system/xmath.h"

void plot( BUFF *buff, XYZ p, char col )
{
	int offset;
  BYTE *image;
  int *zbuffer;
  int x = fchop( p.x) , y = fchop( p.y), z;

  if ( (x < buff->minx) || (x > buff->maxx) || (y < buff->miny) || (y > buff->maxy) )
		return;

  offset = x + buff->ytab[ y];
	image = &buff->image[ offset];
	if( buff->zbuffer != NULL)
	{
    z = fchop( p.z * 65536);
    zbuffer = &buff->zbuffer[ offset];
    if ( z < *zbuffer )
		{
      *zbuffer = z;
			if( buff->lighttab != NULL)
        col = buff->lighttab[ (fpchop(p.l) << 8) + col];
			if( buff->transtab != NULL)
        col = buff->transtab[ (col << 8) + *image];
      *image = col;
		}
	}
	else
	{
		if( buff->lighttab != NULL)
      col = buff->lighttab[ (fchop(p.l) << 8) + col];
		if( buff->transtab != NULL)
      col = buff->transtab[ (col << 8) + *image];
    *image = col;
	}

}
