#include "objects/camera.h"
#include "system/xstdlib.h"
#include "vmath/vector.h"
#include "vmath/matrix.h"

CAMERA *camera_create (void)
{
	CAMERA *cam;
	int i;

	cam = (CAMERA *) xmalloc (sizeof (CAMERA));

	// Preset some defaults values...
	cam->upv.x = 0;
	cam->upv.y = 10;
	cam->upv.z = 0;
	cam->target.x = 0;
	cam->target.y = 0;
	cam->target.z = 0;
/*
	cam->position.x = 0;
	cam->position.y = 0;
	cam->position.z = -1000;
*/
	cam->focus = 400;
	cam->anim = NULL;
	cam->obj_target = NULL;

	cam->num_target = -1;


	for (i=0;i<3;i++) cam->angleadd[i]=0;

	cam->object = NULL;

	cam->flags = 0;
	cam->flags += CAMERAFLAG_ACTIVE;

	return cam;
}
void camera_dispose (CAMERA *cam)
{
	xfree ((void *)cam);
}
void camera_setfocus (CAMERA *cam, float focus)
{
	cam -> focus = focus;
}
void camera_settarget (CAMERA *cam, VECTOR *t)
{
	// switch to: cam->target = *t;
	cam -> target = *t;
}


void camera_setupv (CAMERA *cam,VECTOR *upv)
{
	// switch to: cam->upv = *upv;
	cam->upv = *upv;

}
































