/*--------------------------------------------------------------------
 * File: poly.c
 * Version: SAGA 4.0
 *
 * Written by: Fredrik Kling, 1997-05-11
 * Description: First layout for rendring routines...
 *
 * Updates:
 * -- Date -- | --- Name ---- |-- Did what....
 * 1997-05-11 | Fredrik Kling | Implementation
 * 1998-01-10 | Fredrik Kling | Conversion to TRUE-color
 *
 * Todo:
 *    Se ver parametrarna...
 *	  Material support!!!
 *
 *
 *------------------------------------------------------------------------*/
#include "render16/polydraw.h"
#include "objects/object.h"
#include "formats/v3o.h"
#include "misc/col.h"


extern palette[];
//extern DRV *drv;		// Graphics driver... used by our little engine...


void wire_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v)
{
	static RGBA white = {255,255,255};
	static XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
	p1.l=32;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
	p2.l=32;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
	p3.l=32;

	drv->line (p1,p2,white);		// Always white...
	drv->line (p2,p3,white);
	drv->line (p3,p1,white);
}
void flat_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,RGBA c,float l)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
  p1.z=v[sf->v1].z;
	p1.l=l;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
  p2.z=v[sf->v2].z;
	p2.l=l;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
  p3.z=v[sf->v3].z;
	p3.l=l;

	drv->poly ( p1, p2, p3, c);
}
void gourade_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,RGBA c,float l1,float l2,float l3)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
  p1.z=v[sf->v1].z;
	p1.l=l1;


	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
  p2.z=v[sf->v2].z;
	p2.l=l2;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
  p3.z=v[sf->v3].z;
	p3.l=l3;

	drv->poly( p1, p2, p3, c);
}
void envmap_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,VECTOR *n,V3OTEXTURE *tex)
{
	BYTE *ltab_save;
	XYZ p1,p2,p3;
	int w=tex->image->width >> 1;
	int h=tex->image->height >> 1;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
  p1.tx=n[sf->v1].x * w + w;
  p1.ty=n[sf->v1].y * h + h;
	p1.l = 32;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
  p2.tx=n[sf->v2].x * w + w;
  p2.ty=n[sf->v2].y * h + h;
	p2.l = 32;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
  p3.tx=n[sf->v3].x * w + w;
  p3.ty=n[sf->v3].y * h + h;
	p3.l = 32;

	ltab_save = drv->activebuff->lighttab;
	drv->activebuff->lighttab = NULL;
	drv->tpoly (p1,p2,p3,(BYTE *)tex->image->image32);
	drv->activebuff->lighttab = ltab_save;
}

void texture_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,V3OTEXTURE *tex)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
  p1.tx=sf->tx1;
  p1.ty=sf->ty1;
	p1.l = 63;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
  p2.tx=sf->tx2;
  p2.ty=sf->ty2;
	p2.l = 63;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
  p3.tx=sf->tx3;
  p3.ty=sf->ty3;
	p3.l = 63;

	drv->tpoly (p1,p2,p3,(BYTE *)tex->image->image32);
}
void texture_flat_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,float l,V3OTEXTURE *tex)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
  p1.tx=sf->tx1;
  p1.ty=sf->ty1;
	p1.l = l;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
  p2.tx=sf->tx2;
  p2.ty=sf->ty2;
	p2.l = l;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
  p3.tx=sf->tx3;
  p3.ty=sf->ty3;
	p3.l = l;

	drv->tpoly (p1,p2,p3,(BYTE *)tex->image->image32);
}
void texture_gourade_polygon (DRV *drv, V3OSURFACE *sf,VECTOR *v,float l1, float l2, float l3,V3OTEXTURE *tex)
{
	XYZ p1,p2,p3;

	p1.x=v[sf->v1].x;
	p1.y=v[sf->v1].y;
	p1.z=v[sf->v1].z;
  p1.tx=sf->tx1;
  p1.ty=sf->ty1;
	p1.l = l1;

	p2.x=v[sf->v2].x;
	p2.y=v[sf->v2].y;
	p2.z=v[sf->v2].z;
  p2.tx=sf->tx2;
  p2.ty=sf->ty2;
	p2.l = l2;

	p3.x=v[sf->v3].x;
	p3.y=v[sf->v3].y;
	p3.z=v[sf->v3].z;
  p3.tx=sf->tx3;
  p3.ty=sf->ty3;
	p3.l = l3;

	drv->tpoly (p1,p2,p3,(BYTE *)tex->image->image32);
}












