class GrassLine
{
  int id;
  
  int numConnections;
  int[] connectIds;
  
  float ysize;
  int numSegments;
  float segStep;
  float lineWidth;
  
  Vector3 origin;
  Vector3[] points;
  Vector3[] renderPoints;
  
//  boolean isSunflower;
  
  float leafTextureSize;
  //XTexture leafTexture;
  
  float segTextureSize;
  //XTexture segTexture;
  
  int _headTexID;


  GrassLine()
  {
    _headTexID = -1;
  }


  void init( int id, Vector3 origin, int numSegs, float ysize )
  {
//    isSunflower = false;
    
    this.id = id;
    
/*    numConnections = 1;//(int)random( 1, 5 );
    connectIds = new int[numConnections];
    for( int i=0; i<numConnections; i++ )
    {
      connectIds[i] = (int)random(1, numGrass-1 );
    }*/
    
    numSegments = numSegs;
    this.ysize = ysize;
        
//    if( id%10 == 0 )//&& id <= 10 )
//      isSunflower = true;
    
    this.origin = new Vector3( origin );

    points = new Vector3[numSegs];
    renderPoints = new Vector3[numSegs];
    
    points[0] = new Vector3( origin );
    renderPoints[0] = points[0].copy();

    for( int i=1; i<numSegments; i++ )
    {
      points[i] = new Vector3();

      float step = ((float)i/(float)numSegments) * ysize;
      segStep = step;
      points[i].x = origin.x;
      points[i].y = origin.y - step;
      points[i].z = origin.z;
      
      renderPoints[i] = points[i].copy();
    }
    
    lineWidth = 1; //random( 1, 3 );
    vgl.gl().glLineWidth( lineWidth );    
  }
  
  void setLeafTextureSize( float texsize )
  {
    leafTextureSize = texsize;
    //leafTexture = new XTexture( name );
  }

  void loadSegmentTexture( String name, float texsize )
  {
    segTextureSize = texsize;
    //segTexture = new XTexture( name );
  }

  void draw( float time )
  {
    float timeAlpha = time * 0.025; //0.1;  
    if( timeAlpha > 1.0 ) timeAlpha = 1.0;
    
    vgl.enableLighting( false );
    vgl.enableTexture( false );
    vgl.setDepthWrite( true );
    vgl.setDepthMask( false );
    vgl.setAdditiveBlend();

/*    vgl.setDepthWrite( true );
    vgl.setAdditiveBlend();
    vgl.gl().glBegin( GL.GL_LINES );

    for( int i=0; i<numConnections; i++ )
    {
      Vector3 me = grasslines[id].renderPoints[ 0 ];//grasslines[id].numSegments-1 ];
      Vector3 nb = grasslines[ connectIds[i] ].renderPoints[ 0]; //grasslines[connectIds[i]].numSegments-1 ];

      vgl.gl().glColor4f( gl._r, gl._g, gl._b, gl._a );
      vgl.gl().glVertex3f( me.x, me.y, me.z );
      vgl.gl().glVertex3f( nb.x, nb.y, nb.z );
    }
    vgl.gl().glEnd();*/


//    vgl.fill( 4*(4/255.0), 4*(10/255.0), 4*(40/255.0), 0.75*timeAlpha );//sq(ffthelper.bandmax[id%255])*5 );
    vgl.fill( 1, 0.95*timeAlpha );//sq(ffthelper.bandmax[id%255])*5 );

    // Render lines
    vgl.gl().glBegin( GL.GL_LINE_STRIP );    

    vgl.gl().glColor4f( vgl._r, vgl._g, vgl._b, 0.1*timeAlpha );
    vgl.gl().glVertex3f( renderPoints[0].x, renderPoints[0].y, renderPoints[0].z );

    for( int i=1; i<numSegments; i++ )
    {
      float newA = (1.0 - (i/(float)numSegments));
      vgl.gl().glColor4f( vgl._r, vgl._g, vgl._b, vgl._a*newA*timeAlpha );
      vgl.gl().glVertex3f( renderPoints[i].x, renderPoints[i].y, renderPoints[i].z );
      //gl._gl.glVertex3f( renderPoints[i+1].x, renderPoints[i+1].y, renderPoints[i+1].z );
    }
    vgl.gl().glEnd();


/*    // Render segment point sprites
    vgl.setAdditiveBlend();
    vgl.setDepthWrite( false );
    vgl.enableTexture( true );
    if( _headTexID > 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _headTexID );
    }
    //for( int i=0; i<numSegments; i+=2 )
    for( int i=0; i<numSegments; i++ )
    {
      vgl.pushMatrix();
      vgl.translate( renderPoints[i] );
      glReverseCamera( grassScene.eye, grassScene.target );
      vgl.quad( 0, 0, 0, leafTextureSize*(time*0.01)*((sin(time*.952+id+i*0.2))) );
      vgl.popMatrix();            
    }*/


/*
    // Render the leaf 
    vgl.enableTexture( true );
    if( _headTexID > 0 )
    {
      vgl.enableTexture( true );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _headTexID );
    }
    vgl.fill( 1, (0.1+(sin(time*.52+id)))*timeAlpha ); //random(0, 2.0 ) );
    vgl.pushMatrix();
    vgl.translate( renderPoints[numSegments-1] );
    glReverseCamera( grassScene.eye, grassScene.target );
    vgl.quad( 0, 0, 0, leafTextureSize+vgl._a*2 );
    vgl.popMatrix();*/
    
  }


  void update( float time )
  {  
    float freqmax;
    float freq;

/*    freq = sq(ffthelper.band[id%255]) * 60;

    // if its a sunflower make it grow higher
    // this applies for both sunflowers and every 10th "weed"
    if( id%10 == 0 )
    {
      freqmax = (ffthelper.bandmax[id%255]) * 60 * 1.5;
    }
    else
    {
      freqmax = sq(ffthelper.bandmax[id%255]) * 60;
    }*/
    freq = 20;
    freqmax = 21;

    for( int i=1; i<numSegments; i++ )
    {
      renderPoints[i].x = points[i].x + sin( i*.3+freqmax + time) * i;
      renderPoints[i].y = points[i].y - freqmax;

      // make sure we dont change angle for the 2 sunflowers    
//      if( isSunflower == true )
//        renderPoints[i].z = points[i].z + cos( i*.2 + time + freqmax*.5) * i * 0.5;
//      else
        renderPoints[i].z = points[i].z + cos( (numSegments-i)*.52 + time + freqmax*.5) * i * 2.5;
    }
  }
}
