class JellyScene
{
  // jellyfish sprites
  int _numFrames;
  int _animFrame;    // currframe of our animation
  float _animFramef;    // currframe of our animation (float)  
  XTexture[] _jellyAnim;
  XTexture flare2;
  XTexture flare4;
//  XTexture nebulaTex;

  int numJellys = 2;
//  int numJellys = 10;
  EmitterJelly jellyField; 
  EmitterPlankton planktonField; 

  Vector3 eye, target;
  vitamin.math.Matrix camMatrix;

  boolean sendmorefish = true;
  boolean sendmorefish2 = true;
  
  JellyScene()
  {
    _numFrames = 0;
    _jellyAnim = null;
    
    _animFrame = 0;
    _animFramef = 0.0;
  }

  void init()
  {
    randomSeed( 29 );
    
    this.eye = new Vector3();
    this.target = new Vector3();
    camMatrix = new vitamin.math.Matrix();
    
    _numFrames = 36;
    _jellyAnim = new XTexture[_numFrames];
    for( int i=0; i<_numFrames; i++ )
    {
      if( i <= 9 )
        _jellyAnim[i] = new XTexture( "jellyfish2/jellyfish000"+i+".png" );
      else
        _jellyAnim[i] = new XTexture( "jellyfish2/jellyfish00"+i+".png" );
    }

    flare2 = new XTexture( "flare2.png" );
    flare4 = new XTexture( "flare4.png" );
//    nebulaTex = new XTexture( "flare2.png" );
      
    jellyField = new EmitterJelly( new Vector3(0, 300, 0), 300 );
    while( jellyField.particles.size() < numJellys )
      jellyField.addParticle( new Vector3(random(-300, 0), random(-300, -270), random(900, 1200) ) );

    //jellyField._particleTexID = flare2.getId();
    jellyField._nebulaTexID = flare2.getId(); //nebulaTex.getId();
    jellyField._tailTexID = flare4.getId();
    
    planktonField = new EmitterPlankton( new Vector3(-100, 0, 0), 100 );
    planktonField.vel.set( random(.1, .1), random(-.2, .2), random(-.1,.3) );
//    while( planktonField.particles.size() < 300 )
//      planktonField.addParticles( 1, new Vector3(random(250, 380), random(-200, -300), random(0, 200) ) );
    planktonField._particleTexID = flare4.getId();
  }

  void draw( float time )
  {
    drawPlankton( time );
    drawJelly( time );        
  }
  
  
  void drawJelly( float time )
  {
    //
    // Draw flow particles
    //
    //  gl._gl.glDisable( GL.GL_FOG );
    vgl.enableLighting( false );
    vgl.setDepthMask( false );
    vgl.setDepthWrite( true );
    vgl.setAdditiveBlend();
    //vgl.gl().glBlendFunc( GL.GL_DST_COLOR, GL.GL_ONE );
    jellyField.draw( -1, time );
//    jellyField.draw( _jellyAnim[_animFrame].getId(), time );
  }

  void drawPlankton( float time )
  {
    //
    // Draw plankton particles
    //
    vgl.enableLighting( false );
    vgl.setDepthMask( false );
    vgl.setDepthWrite( true );
    vgl.setAdditiveBlend();
    //  gl.setAlphaBlend();

    planktonField.draw( time );
    //planktonField.drawUsingVertexArray( time );
  }

  void updatePlankton( float time )
  {
    //
    // Update plankton
    //
    if( planktonField.particles.size() < 300 )
    {
      planktonField.addParticle( new Vector3(random(250, 380), random(-200, -300), random(0, 200) ) );
//      planktonField.addParticles( 1, new Vector3(random(150, 380), random(-300, -200), random(0, 200) ) );
    }
  }


  void updateJelly( float time )
  {
    //
    // Update jellys
    //
    if( time < 180 && jellyField.particles.size() < numJellys+int(floor(time*0.42)) )
    {
      float startZ = random(eye.z-600, eye.z-300);
      jellyField.addParticle( new Vector3(random(-300, 0), random(-270, -150), startZ ) );
      jellyField.addParticle( new Vector3(random(-300, 0), random(-270, -150), random(eye.z-600, eye.z-300) ) );
      jellyField.addParticle( new Vector3(random(-300, 0), random(-270, -150), random(eye.z-600, eye.z-300) ) );
//      jellyField.addParticle( new Vector3(random(-300, 100), random(-150, -270), random(1000-1000, 1800-1000) ) );
    }
    if( time >= 90 )
    {
      if( sendmorefish )
      {
        for( int i=0; i<20; i++ )
        {
          float yy = random(-370, -150);  
          jellyField.addParticle( new Vector3(random(-300, 0), yy, random(-500, eye.z-300) ) );
        }
//          jellyField.addParticle( new Vector3(random(-300, 100), random(-150, -370), random(-400, 400) ) );
        sendmorefish = false;
      }
    }
    if( time >= 120 )
    {
      if( sendmorefish2 )
      {
        for( int i=0; i<20; i++ )
        {
          float yy = random(-370, -150);
          jellyField.addParticle( new Vector3(random(-300, 0), yy, random(-500, eye.z-300) ) );
        }
//          jellyField.addParticle( new Vector3(random(-300, 100), random(-150, -370), random(-400, 400) ) );
        sendmorefish2 = false;
      }
    }
  }


  void update( float time )
  {
    updatePlankton( time );
    updateJelly( time );
  }


  void release()
  {
    if( planktonField != null )
      planktonField = null;
    if( jellyField != null )
      jellyField = null;
  }
} // end class
