import penner.easing.*;

//import vitamin.CG;
import vitamin.math.Vector3;
import vitamin.math.Quaternion;
import vitamin.scenesimple.*;

class TactuScene 
{  
/*  SineWave wave; 

  SineWave waveCyl; 
  SineWave waveCyl2; 
  SineWave waveCyl3; 
  SineWave waveCyl4; 

  PinkNoise pnoise;

  boolean addSequencerWave = false;
  boolean addWaveCylinder1 = false;
  boolean addWaveCylinder2 = false;
  boolean addWaveCylinder3 = false;
  boolean addWaveCylinder4 = false;
  boolean addNoiseSignal = false;
*/
  float noiseAmp;
  float noiseTimeStart = 0.0;
  
//  float aspectRatio = 4.0 / 3.0;
  
//  XTexture hll4;
//  XTexture noteTex;
//  XTexture activeNoteTex;
//  XTexture flowerTex;
//  XTexture flowerAlphaTex;
  
  XTexture shadowTex;
  XTexture chapa;
  XTexture chapaPS;
  XTexture chapaV;
  XTexture chapaNNY;
  XTexture chapaKaz;
    
  //CG diffspec;
  int diffspecID;
  
  Vector4 lightPos;
  Vector3 eye, eyeEnd;
  Vector3 target, targetEnd;
  Vector3 up;
  float camSpeed;
  
  Vector4 _fogColor;
  
  //int noteCount = 0;
  //int numNotes = 5;
  //Vector4[] notePos;
  //float[] notePosAlpha;
  //Vector3 noteCenter;
  //float alphaDamp = 0.9;
  
  float lfo1 = 1.0;
  float lfo2 = 1.0;
  float lfo3 = 1.0;
    
  float time = 0.0;
  

  int numRibbons = 8;
  ArrayList ribbons;
  
  int cylsCount = 0;
  int numCyls = 25;
  CylinderRoll[] cyls;
  
  float groundLevel = -105;
  
  Sphere aquario;
  
//  XTexture zBufferTex;
//  FBO zBuffer;

  Vector3 psPos;
  Vector3 vPos;
  Vector3 nnyPos;
  Vector3 kazPos;
  int psIdx = -1;
  int vIdx = -1;
  int nnyIdx = -1;
  int kazIdx = -1;
  boolean psOn = false;
  boolean vOn = false;
  boolean nnyOn = false;
  boolean kazOn = false;
  float psTime;
  float vTime;
  float nnyTime;
  float kazTime;
  
    TactuScene()
    {
    }

    void init()
    {
      _fogColor = new Vector4( 1, 1, 1, 1 );
      lightPos = new Vector4( -600, 300, -600, 1 );

      eye = new Vector3( 0, 200, 180 );
      target = new Vector3( 0, 0, 0 );
      up = new Vector3( 0, 1, 0 );
      eyeEnd = new Vector3();
      targetEnd = new Vector3();
      camSpeed = 1.0 / 150.0;

      shadowTex = new XTexture( "particle_black.png" );
      chapa = new XTexture( "rotulo.png" );
      chapaPS = new XTexture();
      chapaPS.loadPImage( "rotulo_ps.png" );
      chapaPS.setClamp();
      chapaV = new XTexture();
      chapaV.loadPImage( "rotulo_v.png" );
      chapaV.setClamp();
      chapaNNY = new XTexture();
      chapaNNY.loadPImage( "rotulo_nny.png" );
      chapaNNY.setClamp();
      chapaKaz = new XTexture();
      chapaKaz.loadPImage( "rotulo_kaz.png" );
      chapaKaz.setClamp();

      ribbons = new ArrayList();
      for( int i=0; i<numRibbons; i++ )
      {
        RibbonTactu r = new RibbonTactu( 400, 26, 1, false );
        //r._tailWidth = 48;
        //r._headTex = rib._headTex;  // reference to texture
        r.setHead( 0, 90, 0 );
        //r._add.set( sin((i*2*PI)/(float)numRibbons), 0, cos((i*2*PI)/(float)numRibbons) );
        r.setTimeToLive( random(80, 500) );
        r._colour.set( 0, 0, 0, 1 );
        r.computeTail();
        
        ribbons.add( r );
      }

      cyls = new CylinderRoll[numCyls];
      for( int i=0; i<numCyls; i++ )
      {
        cyls[i] = new CylinderRoll();
        cyls[i].setHead( random(-30,30), 0, random(-90,90) );
        cyls[i].setTimeToLive( 4000 );
        cyls[i].setTailSize( 300 );
        cyls[i].setCylinderDetail( 4 );
        cyls[i].setCylinderRadius( (int)random(4, 10) );
        cyls[i]._add.set( random(-.01251, .01251), random(.1251, (i+1)*.51), random(-.01251, .01251) );
        cyls[i]._usePerlin = true;
        cyls[i].computeTail();
      }

      aquario = new Sphere();
      aquario.setColor( 1, 1, 1, 1 );
      aquario.buildSphere( 80, 80, 160.0 ); 

      //diffspec = new CG( vgl.gl() );
//      diffspec.loadFXFromFile( dataPath("diffusespecular.cgfx") );
      //diffspec.loadFXFromFile( dataPath("diffusespecular_notexture.cgfx") );
      diffspecID = vgl.addEffectFromFile( dataPath("diffusespecular_notexture.cgfx") );

      // compute board's positions
      float posAngle = 0;
      float offset = 400;
      float x = cos( radians(posAngle) ) * offset;
      float z = sin( radians(posAngle) ) * offset;
      psPos = new Vector3( x, groundLevel, z );
      posAngle = 90;
      x = cos( radians(posAngle) ) * offset;
      z = sin( radians(posAngle) ) * offset;      
      vPos = new Vector3( x, groundLevel, z );
      posAngle = 180;
      x = cos( radians(posAngle) ) * offset;
      z = sin( radians(posAngle) ) * offset;      
      nnyPos = new Vector3( x, groundLevel, z );
      posAngle = 270;
      x = cos( radians(posAngle) ) * offset;
      z = sin( radians(posAngle) ) * offset;      
      kazPos = new Vector3( x, groundLevel, z );

/*
      //
      // MINIM
      //
      wave = new SineWave( 10, .1, out.sampleRate() );   
      wave.portamento( 800 );
    //  out.addSignal( wave );
    
      waveCyl = new SineWave( 32, .1, out.sampleRate() );   
      out.addSignal( waveCyl );
    
      waveCyl2 = new SineWave( 100, .1, out.sampleRate() );   
      out.addSignal( waveCyl2 );
    
    //  waveCyl3 = new SineWave( 100, .2, out.sampleRate() );   
    //  out.addSignal( waveCyl3 );
    
      pnoise = new PinkNoise( 0 );*/
    }


void draw( float time)
{
  vgl.background( 1 );

  renderScene( time );
}


void renderPlants()
{
  eye.set( sin(time*.1)*1200, 450, cos(time*.1)*1200 );
  target.set( 0, 200, 0 );

  vgl.perspective( 45.0, aspectRatio, 1.0, 4000.0 );
  vgl.camera( eye, target, up );
//  vgl.camera( 0, 250, 1200, 0, 100, 0, 0, 1, 0 );

/*
//  setupPointLight( new Vector3(0, 400, 800) );
  vgl.gl().glEnable( GL.GL_LIGHTING );
  vgl.gl().glEnable( GL.GL_COLOR_MATERIAL );
  vgl.gl().glLightModelfv( GL.GL_LIGHT_MODEL_AMBIENT, new float[]{.03f,.03f,.03f, 1.f }, 0);
  vgl.gl().glColorMaterial( GL.GL_FRONT_AND_BACK,GL.GL_AMBIENT_AND_DIFFUSE );

  //////////////////////////// LIGHT 1 /////////////////////////////////
  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_AMBIENT,new float[]{0, 0, 0, 1.f }, 0 );
  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_DIFFUSE,new float[]{ 0.4, 0.4, 0.4, 1.f }, 0 );
//  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_DIFFUSE,new float[]{ 0.0, 0, 0.4, 1.f }, 0 );
  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_SPECULAR,new float[]{ .7f,.7f,.7f, 1.f  }, 0 );
  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_POSITION,new float[]{ -300, 800, 600, 1.0f }, 0 );
  vgl.gl().glEnable( GL.GL_LIGHT1 );
  ///////////////////////////////////////////////////////////////////////

  vgl.gl().glMaterialfv( GL.GL_FRONT_AND_BACK, GL.GL_SPECULAR, new float[]{1f, 1f, 1f, 1.0f}, 0 ); 
  vgl.gl().glMateriali( GL.GL_FRONT_AND_BACK,GL.GL_SHININESS, 128 );
  vgl.gl().glLightModeli( GL.GL_LIGHT_MODEL_COLOR_CONTROL, GL.GL_SEPARATE_SPECULAR_COLOR );
*/

  //
  // Draw growing distorted cylinders
  //
  
//  float growSpeed = wave.frequency() * 0.002;
  float growSpeed = (time-noiseTimeStart)*3;
  float dispSpeed = (time-noiseTimeStart)*3;


    vgl.enableLighting( false );
//    for( int i=0; i<1; i++ )
    for( int i=0; i<numCyls; i++ )
    {
      cyls[i].addHead( 2*sin(time*2), 0, 0 );
      cyls[i]._colour.set( 0, 0, 0, 1 );
      //cyls[i]._colour.set( 1, 1, 1, 1 );
      cyls[i].update( (time-noiseTimeStart) );
      cyls[i].draw( (time-noiseTimeStart) );
      cyls[i]._dispoffset = 1;// + dispSpeed;
      cyls[i]._displaces  = 0;
      cyls[i]._dispscale  = 19;//+abs(cos(wave.frequency())*.2);
    }
}


void renderScene( float time )
{ 
  /*
  if( time > 1.0 && !addSequencerWave )
//  if( time > 8.0 && !addSequencerWave )
  {
    addSequencerWave = true;
    out.addSignal( wave );
    tactu5.start();
  }
  if( time > 32.0 && !addNoiseSignal )
  {
    addNoiseSignal = true;
    out.addSignal( pnoise );
    noiseTimeStart = time;
  }
*/

/*
  vgl.gl().glEnable( GL.GL_LIGHTING );
  vgl.gl().glEnable( GL.GL_COLOR_MATERIAL );
  vgl.gl().glLightModelfv( GL.GL_LIGHT_MODEL_AMBIENT, new float[]{0.0f,0.0f,0.1f, 1.f }, 0);
  vgl.gl().glColorMaterial( GL.GL_FRONT_AND_BACK,GL.GL_AMBIENT_AND_DIFFUSE );

  //////////////////////////// LIGHT 1 /////////////////////////////////
  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_AMBIENT,new float[]{0, 0, 0.1, 1.f }, 0 );
  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_DIFFUSE,new float[]{ 0.994, 0.994, 0.994, 1.f }, 0 );
  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_SPECULAR,new float[]{ .297f,.297f,.297f, 1.f  }, 0 );
  vgl.gl().glLightfv( GL.GL_LIGHT1,GL.GL_POSITION,new float[]{ -900, -1200, 200, 1.0f }, 0 );
  vgl.gl().glEnable( GL.GL_LIGHT1 );
  ///////////////////////////////////////////////////////////////////////

  vgl.gl().glMaterialfv( GL.GL_FRONT_AND_BACK, GL.GL_SPECULAR, new float[]{1f, 1f, 1f, 1.0f}, 0 ); 
  vgl.gl().glMateriali( GL.GL_FRONT_AND_BACK,GL.GL_SHININESS, 32 );
  vgl.gl().glLightModeli( GL.GL_LIGHT_MODEL_COLOR_CONTROL, GL.GL_SEPARATE_SPECULAR_COLOR );
*/

  float camTime = 7.0;

/*
  eyeEnd.set( sin(time*.14)*1200, 450, cos(time*.14)*1200 );
  targetEnd.set( 0, 200, 0 );
  
  camSpeed = 0.006;
  this.eye.x += (eyeEnd.x-this.eye.x) * camSpeed;
  this.eye.y += (eyeEnd.y-this.eye.y) * camSpeed;
  this.eye.z += (eyeEnd.z-this.eye.z) * camSpeed;
  this.target.x += (targetEnd.x-this.target.x) * camSpeed;
  this.target.y += (targetEnd.y-this.target.y) * camSpeed;
  this.target.z += (targetEnd.z-this.target.z) * camSpeed;
*/



  // lerp to position: 205.28418, 450.0, -1182.3107
  float camDist = time;
  float camAngle = 8;//time-camTime;
  if( camDist < camTime )
  {  
    float cos0 = 100;//-157.85895; // cos(0)*160;
    float sin0 = 100;//-26.087368; // sin(0)*160;
    this.eye.set( Sine.easeInOut(camDist, sin0, (1000*sin(camAngle*.14))-sin0, camTime), //3.358-160, camTime), 
             Sine.easeIn(camDist, 160, 450-160, camTime), 
             Sine.easeInOut(camDist, cos0, (1000*cos(camAngle*.14))-cos0, camTime) ); //1199.99-160, camTime) );
    this.target.set( 0, Sine.easeInOut(camDist, 50, 200-50, camTime), 0 );             
  }
  else
  {
    this.eye.set( 1000*sin(camAngle*.14), 450, 1000*cos(camAngle*.14) );
    //println( time-camTime );
    //this.eye.debug();
    this.target.set( 0, 200, 0 );
  }

  vgl.perspective( 45.0, aspectRatio, 1.0, 4000.0 );
  vgl.camera( this.eye, this.target, up );
  vitamin.math.Matrix cameraMatrix = vgl.getTransposeViewMatrix();

  vgl.rotateY( degrees(time*0.14) );

  //
  // draw floor
  //
  vgl.enableLighting( false );
  vgl.enableTexture( false );
  vgl.gl().glDisable( GL.GL_FOG );
/*  // Setup fog
//  float[] fogCol = { 0, 0, 0, 0 };
  float[] fogCol = { 1, 1, 1, 0 };
  vgl.gl().glEnable( GL.GL_FOG );
  //gl._gl.glFogi( GL.GL_FOG_MODE, GL.GL_LINEAR );
  vgl.gl().glFogi( GL.GL_FOG_MODE, GL.GL_EXP2 );
  vgl.gl().glFogfv( GL.GL_FOG_COLOR, fogCol, 0 );
  vgl.gl().glFogf( GL.GL_FOG_DENSITY, fogDensity );*/
  
  vgl.pushMatrix();
  vgl.translate( 0, groundLevel-5, 0 );
  vgl.rotateX( 90 );
  vgl.fill( 1, 1 );
  vgl.rect( 3000, 3000 );
  vgl.popMatrix();

  

  //
  // draw credtis
  //
  vgl.enableLighting( false );
  vgl.enableTexture( true );
  vgl.setAlphaBlend();
  vgl.fill( 1.0, 1.0 );
  

  float posAngle = 0;
  //float offset = 380;
  //float x = cos( radians(posAngle) ) * offset;
  //float z = sin( radians(posAngle) ) * offset;

  // ps
//  if( !psOn )
  {
    posAngle =  0;
    chapa.enable();
    vgl.pushMatrix();
    vgl.translate( psPos ); //x, groundLevel, z );
    vgl.rotateX( 90 );
    vgl.rotateZ( 90+posAngle );
    vgl.rect( 256, 128 );
    vgl.popMatrix();
  }
//  if( !vOn )
  {
    // V
    chapa.enable();
    posAngle = 90;
    //x = cos( radians(posAngle) ) * offset;
    //z = sin( radians(posAngle) ) * offset;
    vgl.pushMatrix();
    vgl.translate( vPos ); //x, groundLevel, z );
    vgl.rotateX( 90 );
    vgl.rotateZ( 90+posAngle );
    vgl.rect( 256, 128 );
    vgl.popMatrix();
  }
//  if( !nnyOn )
  {
    // NNY
    chapa.enable();
    posAngle = 180;
    //x = cos( radians(posAngle) ) * offset;
    //z = sin( radians(posAngle) ) * offset;
    vgl.pushMatrix();
    vgl.translate( nnyPos ); //x, groundLevel, z );
    vgl.rotateX( 90 );
    vgl.rotateZ( 90+posAngle );
    vgl.rect( 256, 128 );
    vgl.popMatrix();
  }
//  if( !kazOn )
  {
    chapa.enable();
    posAngle = 270;
    //x = cos( radians(posAngle) ) * offset;
    //z = sin( radians(posAngle) ) * offset;
    vgl.pushMatrix();
    vgl.translate( kazPos ); //x, groundLevel, z );
    vgl.rotateX( 90 );
    vgl.rotateZ( 90+posAngle );
    vgl.rect( 256, 128 );
    vgl.popMatrix();
  }

  //if( !((Ribbon)ribbons.get(0))._doUpdate )
  {
    //
    // draw credtis
    //
    vgl.setAdditiveBlend();
    vgl.enableLighting( false );
    vgl.setDepthWrite( false );
    vgl.enableTexture( true );
    vgl.fill( 1.0, 1.0 );
    
    
    float psdist=0.0, vdist=0.0, nnydist=0.0, kazdist=0.0;
    for( int i=0; i<ribbons.size(); i++ )
    {
      RibbonTactu rr = (RibbonTactu)ribbons.get( i );

      Vector3 ribHead = rr._head.copy();
      psdist = Vector3.distance( psPos, ribHead );
      vdist = Vector3.distance( vPos, ribHead );
      nnydist = Vector3.distance( nnyPos, ribHead );
      kazdist = Vector3.distance( kazPos, ribHead );
      if( !psOn && psdist <= 90 )
      {
        psOn = true;
        psIdx = i;
        psTime = time;
        if( useMinim ) credits.loop();
        break;
      }
      if( !vOn && vdist < 90 )
      {
        vOn = true;
        vIdx = i;
        vTime = time;
        break;
      }
      if( !nnyOn && nnydist < 90 )
      {
        nnyOn = true;
        nnyIdx = i;
        nnyTime = time;
        break;
      }
      if( !kazOn && kazdist < 90 )
      {
        kazOn = true;
        kazIdx = i;
        kazTime = time;
        break;
      }
    }
    
    // ps
    if( psOn )
    {
      vgl.fill( 1, random( 0, (time-psTime)*0.25) );
      posAngle = 0;
      chapaPS.enable();
      vgl.pushMatrix();
      vgl.translate( psPos ); //x, groundLevel, z );
      vgl.rotateX( 90 );
      vgl.rotateZ( 90+posAngle );
      vgl.rect( 256, 128 );
      vgl.popMatrix();
    }
    
    // V
    if( vOn )
    {
      posAngle = 90;
      vgl.fill( 1, random( 0, (time-vTime)*0.25) );
      chapaV.enable();
      vgl.pushMatrix();
      vgl.translate( vPos ); //x, groundLevel, z );
      vgl.rotateX( 90 );
      vgl.rotateZ( 90+posAngle );
      vgl.rect( 256, 128 );
      vgl.popMatrix();
    }
    
    // NNY
    if( nnyOn ) 
    {
      posAngle = 180;
      vgl.fill( 1, random( 0, (time-nnyTime)*0.25) );
      chapaNNY.enable();
      vgl.pushMatrix();
      vgl.translate( nnyPos ); //x, groundLevel, z );
      vgl.rotateX( 90 );
      vgl.rotateZ( 90+posAngle );
      vgl.rect( 256, 128 );
      vgl.popMatrix();
    }
    
    // Kaz
    if( kazOn ) 
    {
      posAngle = 270;
      vgl.fill( 1, random( 0, (time-kazTime)*0.25) );
      chapaKaz.enable();
      vgl.pushMatrix();
      vgl.translate( kazPos ); //x, groundLevel, z );
      vgl.rotateX( 90 );
      vgl.rotateZ( 90+posAngle );
      vgl.rect( 256, 128 );
      vgl.popMatrix();
    }
  }

  //
  // Draw sphere's shadow
  //
  vgl.setDepthWrite( true );
  vgl.setDepthMask( false );
  vgl.setAlphaBlend();
  
  vgl.fill( .0095, .75 );
  shadowTex.enable();
  vgl.pushMatrix();
  vgl.translate( 0, groundLevel, 0 );
  vgl.rotateX( 90 );
  //vgl.rotateZ( time*10 );
  vgl.fill( 0, 1 );
  vgl.rect( 315, 315 );
  vgl.popMatrix(); 
  vgl.pushMatrix();
  vgl.translate( 0, groundLevel, 0 );
  vgl.rotateX( 90 );
  //vgl.rotateZ( time*10 );
  vgl.fill( 0, 1 );
  vgl.rect( 155, 155 );
  vgl.popMatrix(); 
  vgl.setDepthMask( true );


  if( time > camTime*0.8 )
  { 
    //
    // Draw tentacles and their shadows
    //
    vgl.setAlphaBlend();
    vgl.enableTexture( false );
    //vgl.enableLighting( false );
    
//    addSequencerWave = true;
//    if( addSequencerWave )
    {
      float freq = .1;//radians( time*.52 ) * .02; //wave.frequency() * 0.25) * 2;
      for( int i=0; i<ribbons.size(); i++ )
      {
        RibbonTactu r = (RibbonTactu)ribbons.get( i );
        
        // Change width of tail
        r._tailWidth = 12;   
        //r._colour.set( 0, 0, 0, 1 );
  
        //float rr = r._head.x*r._head.x + r._head.y*r._head.y;
        //r._head.y -= 1236*rr*exp(-10.0*rr);
        //if( i == 0 )  println( r._head.y );
        //r.addHead( freq*cos(i+time*1.06)*16, 0, freq*sin(i+time*.4)*16 );
        
        float angle = -(i*2*PI/(float)ribbons.size());
        r.addHead( freq*cos(-angle)*16, ((groundLevel-r._head.y)+r._tailWidth)*0.025, freq*sin(-angle)*16 );
    
        r.update( time );
        r.draw( time );
      //if( r.isDead() )
        //r.reset( new Vector3(0, -90, 0), random(50, 500) );
      }
      for( int i=0; i<ribbons.size(); i++ )
      {
        /*vgl.gl().glBlendFunc( GL.GL_DST_COLOR, GL.GL_ZERO );
        if( psOn ) ((RibbonTactu)ribbons.get(psIdx)).renderTail( time-psTime );
        if( vOn ) ((RibbonTactu)ribbons.get(vIdx)).renderTail( time-vTime );
        if( nnyOn ) ((RibbonTactu)ribbons.get(nnyIdx)).renderTail( time-nnyTime );
        if( kazOn ) ((RibbonTactu)ribbons.get(kazIdx)).renderTail( time-kazTime );*/
        
        vgl.setAlphaBlend();
        RibbonTactu r = (RibbonTactu)ribbons.get( i );
        r.drawCylinderRibbon( time );
      }
    }
  }


  // Draw Sphere
  vgl.enableLighting( true );
  vgl.setDepthWrite( true );
  vgl.setDepthMask( true ); 
  vgl.enableTexture( false );

  vgl.fill( 0, 0, 0.1, 1 );
  vgl.pushMatrix();
  vgl.translate( 0, groundLevel+160, 0 );
  vgl.rotateY( time*10 );

  // get world matrix
  vgl.pushMatrix();
  vgl.identity();
  vgl.translate( 0, groundLevel+160, 0 );  
  vgl.rotateY( time*10 );
  vitamin.math.Matrix localMatrix = vgl.getTransposeViewMatrix();
  vgl.popMatrix();
  //Matrix localMatrix = new Matrix();
  //localMatrix.translate( 0, groundLevel+160, 0 );
  //localMatrix.rotateY( time*10 );

  vgl.setShader( diffspecID );
  vgl.setParameter3f( "cameraPos", this.eye );
  vgl.setParameter4f( "lightPos", lightPos );
  vgl.setParameter4f( "fogColor", fogColor );
  vgl.setParameter1f( "fogDensity", 0.00008f );
  vgl.setParameter1f( "kC", kC );
  vgl.setParameter1f( "kL", kL );
  vgl.setParameter1f( "kQ", kQ );
  vgl.setParameter1f( "specularLevel", 8 );
  vgl.setParameter1f( "useSpecular", 1 );
  vgl.setMatrixParameterSemantic( "WORLDVIEWPROJECTION", ShaderSemantics.WORLDVIEWPROJECTION_MATRIX, ShaderSemantics.IDENTITY_MATRIX );
  vgl.setMatrixParameterSemantic( "MODELVIEW", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.IDENTITY_MATRIX );
  vgl.setMatrixParameterSemantic( "VIEWINVERSE", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.INVERSE_MATRIX );
  vgl.setMatrixParameterSemantic( "VIEWINVERSETRANSPOSE", ShaderSemantics.VIEW_MATRIX, ShaderSemantics.INVERSE_TRANSPOSE_MATRIX );
  vgl.setMatrixParameterSemantic( "WORLD", vitamin.math.Matrix.transpose(localMatrix).getArray() );
  vgl.setMatrixParameterSemantic( "WORLDTOCAMERA", cameraMatrix.getArray() );
  CGpass pass = ((ShaderCGFX)vgl.getActiveShader()).setFirstPass( "Technique_DiffuseSpecularNoTextureWrap" );

/*
  //diffspec.setTextureParameter( "ColorSampler", chapaNNY.getId() );
  diffspec.setParameter3f( "cameraPos", this.eye );
  diffspec.setParameter4f( "lightPos", this.lightPos.x, this.lightPos.y, this.lightPos.z, 1.0 );
  diffspec.setParameter4f( "fogColor", _fogColor );
  diffspec.setParameter1f( "fogDensity", 0.00008f );
  diffspec.setParameter1f( "kC", kC );
  diffspec.setParameter1f( "kL", kL );
  diffspec.setParameter1f( "kQ", kQ );
  diffspec.setParameter1f( "specularLevel", 8.0f );
  diffspec.setParameter1f( "useSpecular", 1 );
  diffspec.setParameter4x4fBySemantic( "WorldViewProjection", CgGL.CG_GL_MODELVIEW_PROJECTION_MATRIX, CgGL.CG_GL_MATRIX_IDENTITY );
  diffspec.setParameter4x4f( "view", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_IDENTITY );
  diffspec.setParameter4x4f( "viewI", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_INVERSE );
  diffspec.setParameter4x4f( "viewIT", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_INVERSE_TRANSPOSE );
  diffspec.setParameter4x4f( "WorldXf", vitamin.math.Matrix.transpose(localMatrix) );
  diffspec.setParameter4x4f( "W2C", cameraMatrix );
  CGpass pass;
  pass = diffspec.getTechniqueFirstPass( "Technique_DiffuseSpecularNoTextureWrap" );
  //pass = diffspec.getTechniqueFirstPass( "Technique_DiffuseSpecularNoTexture" );
*/
  CgGL.cgSetPassState( pass );

//  aquario.drawSphereTextured( 0, 0, 0 );
  aquario.drawSphere( 0, 0, 0, 1 );

  CgGL.cgResetPassState( pass );
  vgl.disableShader();

  vgl.popMatrix();



  if( psOn )
  {
    //
    // Draw the growing vines
    //
    cylsCount = (int)(time*0.5) - 2;
    
    //dirty hack shit q o vic nao gosta!!
    if (cylsCount < 0 ) cylsCount = 0;
    
    if( cylsCount >= numCyls ) cylsCount = numCyls;
    
//    addNoiseSignal = true;
    noiseAmp = random(0.0, 0.9);
//    if( addNoiseSignal )
    {
      //float growSpeed = wave.frequency() * 0.002;
      float growSpeed = (time-noiseTimeStart) * 6 * noiseAmp; //wave.frequency() * 0.0035;
      float dispSpeed = (time-noiseTimeStart) * 6 * noiseAmp * 10; //wave.frequency() * 0.002;
  /*
      //vgl.enableLighting( false );
  //  CGpass pass = diffspec.getTechniqueFirstPass( "Technique_DiffuseSpecular" );
      pass = diffspec.getTechniqueFirstPass( "Technique_DiffuseSpecularNoTexture" );
      CgGL.cgSetPassState( pass );
  
      //diffspec.setTextureParameter( "ColorSampler", chapaNNY.getId() );
      diffspec.setParameter3f( "cameraPos", this.eye );
      diffspec.setParameter4f( "lightPos", this.lightPos.x, this.lightPos.y, this.lightPos.z, 1.0 );
      diffspec.setParameter4f( "fogColor", fogColor );
      diffspec.setParameter1f( "fogDensity", 0.00008f );
      diffspec.setParameter1f( "kC", kC );
      diffspec.setParameter1f( "kL", kL );
      diffspec.setParameter1f( "kQ", kQ );
      diffspec.setParameter1f( "specularLevel", 8.0f );
      diffspec.setParameter1f( "useSpecular", 1 );
    
      diffspec.setParameter4x4fBySemantic( "WorldViewProjection", CgGL.CG_GL_MODELVIEW_PROJECTION_MATRIX, CgGL.CG_GL_MATRIX_IDENTITY );
      diffspec.setParameter4x4f( "view", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_IDENTITY );
      diffspec.setParameter4x4f( "viewI", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_INVERSE );
      diffspec.setParameter4x4f( "viewIT", CgGL.CG_GL_MODELVIEW_MATRIX, CgGL.CG_GL_MATRIX_INVERSE_TRANSPOSE );
      diffspec.setParameter4x4f( "WorldXf", Matrix.transpose(localMatrix) );
      diffspec.setParameter4x4f( "W2C", cameraMatrix );
      */
      for( int i=0; i<cylsCount; i++ )
      {
        cyls[i]._colour.set( 0, 0, 0.0, 1 );
        cyls[i].update( (time-noiseTimeStart) );
        cyls[i].draw( (time-noiseTimeStart) );
        cyls[i]._dispoffset = 1 + dispSpeed;
        cyls[i]._displaces  = 0;
        cyls[i]._dispscale  = 19;//+abs(cos(wave.frequency())*.2);
      }
  
      //CgGL.cgResetPassState( pass );
  
      vgl.enableLighting( true );
    }
  }
  
/*  
    //
    // update lfo's
    //
    lfo1 = ((sin(time*12)+1.0)*0.5)+0.25;
    lfo2 = ((sin(90+time*12)+1.0)*0.5)+0.5;

    if( addNoiseSignal )
    {
      if( random(500) < 50 )
      {
        if( cylsCount < numCyls-1 )
          cylsCount ++;
        noiseAmp = 1.0;
      }
      else  noiseAmp = 0.0;

      pnoise.setAmp( noiseAmp );
    }
    
    //waveCyl.setFreq( 32 );
  
    lfo3 = sin( random(100,500) );
    waveCyl2.setFreq( lfo3 );*/
  }


/*
    void renderMainTrail( int len, Vector3[] ribloc, float ribWidth )
    {
      float per;
      float xp, yp, zp;
      float xOff, yOff, zOff;
    
      vgl.gl().glDisable( GL.GL_CULL_FACE );
    
      //  gl.enableLighting( true );
      vgl.setDepthWrite( true );
      vgl.setDepthMask( false );
      vgl.setAlphaBlend();
      //  gl.setAdditiveBlend();
      //  gl._gl.glBlendFunc( GL.GL_DST_COLOR, GL.GL_ZERO );
    
      ///////////////////////////////////////
      ///////////////////////////////////////
    //  ribbonTexture.enable();
    //  ribbonBlack.enable();
      vgl.gl().glBegin( GL.GL_QUAD_STRIP );
      for ( int i=0; i<len-1; i++ )
    //  int hlen = (int)((len-1)*0.5);
    //  for ( int ii=-hlen; ii<hlen; ii++ )
      {
    //    int i = ii+hlen;
    //    per           = 1.0 - (((float)(abs(ii))/(float)(hlen)));    
    
        per           = (((float)i/(float)(len)));
    //    per           = 1.0-(((float)i/(float)(len-1)));
    
    //    per *= 10.0;
        if( per > 1.0 ) per = 1.0;
        if( per < 0.0 ) per = 0.0;
    
        xp            = ribloc[i].x;
        yp            = ribloc[i].y;
        zp            = ribloc[i].z;
    
        if( i < len )
        {
          //Vector3 perp0 = Vector3.sub( ploc[j][i], ploc[j][i+1] );
          Vector3 dir = Vector3.sub( ribloc[i+1], ribloc[i] );
          dir.normalize();
          Vector3 V = dir.cross( new Vector3( 0, 0, 1 ) );
    //      Vector3 V = dir.cross( new Vector3( 0, 1, 0 ) );
          V.normalize();
          Vector3 N = dir.cross( V );
          N.normalize();
          V = N.cross( dir );
          //V = dir.cross( N );
          V.normalize();
    
          xOff        = V.x * ribWidth * per * 1.5;
          yOff        = V.y * ribWidth * per * 1.5;
          zOff        = V.z * ribWidth * per * 1.5;
    
    //      vgl.gl().glColor4f( 1-per, 1-per, 1-per, per );
          vgl.gl().glColor4f( 0, 0, 0, 1 );
    //      vgl.gl().glColor4f( 1, 1, 1, 1 );
    //      vgl.gl().glColor4f( per, per, per, per );
    //      vgl.gl().glColor4f( per, per*.5, 1.5 - per, per);
    
    //      gl._gl.glNormal3f( N.x, N.y, N.z );
    //      gl._gl.glTexCoord2f( 0, 0 );
          vgl.gl().glVertex3f( xp - xOff, yp - yOff, 0 );//zp - zOff );
    //      gl._gl.glNormal3f( N.x, N.y, N.z );
    //      gl._gl.glTexCoord2f( 1, 1 );
          vgl.gl().glVertex3f( xp + xOff, yp + yOff, 0 );//zp + zOff );
        }
      }   
    }
*/

}
