/*
  Hack up texture class to load and create opengl textures..  decrepated!
  use vitamin texture loading 
*/  

import java.nio.*;
import com.sun.opengl.util.texture.TextureIO;   
import com.sun.opengl.util.texture.Texture;   

class XTexture
{
  XTexture()
  {
    _tex = null;
    _texType = GL.GL_TEXTURE_2D;
  }

  XTexture(int texType )
  {
    _tex = null;
//    _buffer = null;
//    _img = null;
    
    isLoaded = false;
    
    _texType = texType;
  }

  XTexture( String fName )
  {
    fileName = fName;
    _tex = null;
    _buffer = null;
    _texType = GL.GL_TEXTURE_2D;
    load( fName );
  }

 XTexture( String fName, int texType )
  {
    fileName = fName;
    _tex = null;
    _buffer = null;
    _img = null;
    
    isLoaded = false;
    
    _texType = texType;
    
    loadPImage( fName );
  }
  
  void bind()
  {
    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
    }
    else
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
    }
  }

  void unbind()
  {
    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, 0 );
    }
    else
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, 0 );
    }
  }

  void enable()
  {
    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glEnable( GL.GL_TEXTURE_2D );
    }
    else
    {
      vgl.gl().glEnable( GL.GL_TEXTURE_RECTANGLE_ARB );
    }    

    bind();
  }

  void disable()
  {
    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glDisable( GL.GL_TEXTURE_2D );
    }
    else
    {
      vgl.gl().glDisable( GL.GL_TEXTURE_RECTANGLE_ARB );
    }    

    unbind();
  }

  void setWrap()
  {
    if( _tex != null )
    {
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
    }
    else
    {
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
    }
  }

  void setClamp()
  {
    if( _tex != null )
    {
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
    }
    else
    {
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
    }
  }

  void setClampToEdge()
  {
    if( _tex != null )
    {
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
    }
    else
    {
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
    }
  }

  void createGL( int w, int h )
  {
     _width = w;
     _height = h;
     
     int[] id = { 0 };

    // Creating texture.
    vgl.gl().glGenTextures( 1, id, 0 );
    _id = id[0];
      println( "texture created: " + _id );
    
    vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );

//    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_R16G16, _width, _height, 0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, null );
  }
  

  void createGLDepth( int w, int h )
  {
     _width = w;
     _height = h;
     
     int[] id = { 0 };

    // Creating texture.
    vgl.gl().glGenTextures( 1, id, 0 );
    _id = id[0];
      println( "texture created: " + _id );
    
    vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_NEAREST );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_NEAREST );

    // Three next lines are necessary if we wan to use the convenient shadow2DProj function in the shader.
    // Otherwise we have to rely on texture2DProj
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_COMPARE_MODE, GL.GL_COMPARE_R_TO_TEXTURE );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_COMPARE_FUNC, GL.GL_LEQUAL );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_DEPTH_TEXTURE_MODE, GL.GL_LUMINANCE );

//    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, null );
    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_DEPTH_COMPONENT32, _width, _height, 0, GL.GL_DEPTH_COMPONENT, GL.GL_FLOAT, null );

  }

  void create( int w, int h )
  {
      _width = w;
      _height = h;
      _buffer = new BufferedImage( w, h, BufferedImage.TYPE_INT_ARGB );//_PRE );
      _tex = TextureIO.newTexture( _buffer, false );
      _id = _tex.getTextureObject();
      println( "texture created: " + _id );

//      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_R, GL.GL_REPEAT );
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
      _tex.setTexParameterf( GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
      _tex.setTexParameterf( GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
  }

  void load( String fName )//, boolean mipmap )  
  {
    //Texture tex = null;
    fileName = fName;
    try
    {
      _tex = TextureIO.newTexture( new File(dataPath(fileName)), true );  //mipmap );
      _id = _tex.getTextureObject();

      //_tex.setTexParameterf( GL.GL_TEXTURE_WRAP_R, GL.GL_REPEAT );     
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT ); 
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );  
      //tex.setTexParameteri( GL.GL_TEXTURE_WRAP_R, GL.GL_CLAMP );     
      //tex.setTexParameteri( GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP ); 
      //tex.setTexParameteri( GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );  
      _tex.setTexParameterf( GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
      _tex.setTexParameterf( GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
    }
    catch( Exception e )
    {
      println("texture error: " + e);
    }
    
    //_id = _tex.getTarget();
    //println( "Texture: '" + fileName + "' with id: '" + _id + "'" );
    //println( "Estimated Memory Size: " + _tex.getEstimatedMemorySize() / 1024 + " KBytes" );

    //return tex;
  }

void loadPImage( String fName )
  {
    fileName = fName;

    PImage _img = loadImage( fName );
    if( _img == null )
    {
      println( "couldnt load texture: " + fileName );
      return;
    }

    _width = _img.width;
    _height = _img.height;

    int[] texId = new int[1];
    vgl.gl().glGenTextures( 1, texId, 0 );
    _id = texId[0];

    if( _texType == GL.GL_TEXTURE_2D )
    {    
      //println( "texture is 2D" );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
      vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE );
      vgl.gl().glTexParameterf( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
      vgl.gl().glTexParameterf( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
      vgl.gl().glTexParameterf( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
      vgl.gl().glTexParameterf( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, 4, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
      //vgl.glu().gluBuild2DMipmaps( GL.GL_TEXTURE_2D, 3, _width, _height, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      //println( "texture is RECT" );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
//      vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
      vgl.gl().glTexParameterf( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE ); 
      vgl.gl().glTexParameterf( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );  
      vgl.gl().glTexParameterf( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameterf( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, 3, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
    }

    //_img = null;

    //println("loading texture: " + fileName + " with id= " + _id );
  }

  
void loadPImageFromMemory( PImage img )
  {
    fileName = "__";

    _width = img.width;
    _height = img.height;

    int[] texId = new int[1];

    //println( "gen tex" );
    vgl.gl().glGenTextures( 1, texId, 0 );
    _id = texId[0];
    vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
    vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
//    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, 4, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(img.pixels) ); 
//    vgl.glu().gluBuild2DMipmaps( GL.GL_TEXTURE_2D, 4, img.width, img.height, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(img.pixels) ); 

    //_img = null;

    //isLoaded = true;
    //println("loading texture: " + fileName + " with id= " + _id );
  }


  int getTarget()
  {
    return _tex.getTarget();
  }
  
  int getId()
  {
    return _id;
  }
  
  int getWidth()
  {
    return _width;
  }
  
  int getHeight()
  {
    return _height;
  }
  

	String fileName;
	Texture _tex;
        int    _id;
        
        int _texType;
        PImage _img;
  
        int _width, _height;
        
        BufferedImage  _buffer;
        boolean isLoaded;
};
