/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.AudioBuffer;
import ddf.minim.Minim;

public abstract class FourierTransform {
    public static final int NONE = 0;
    public static final int HAMMING = 1;
    protected static final int LINAVG = 2;
    protected static final int LOGAVG = 3;
    protected static final int NOAVG = 4;
    protected static final float TWO_PI = (float)Math.PI * 2;
    protected int timeSize;
    protected int sampleRate;
    protected float bandWidth;
    protected int whichWindow;
    protected float[] real;
    protected float[] imag;
    protected float[] spectrum;
    protected float[] averages;
    protected int whichAverage;
    protected int octaves;
    protected int avgPerOctave;

    FourierTransform(int ts, float sr) {
        this.timeSize = ts;
        this.sampleRate = (int)sr;
        this.bandWidth = 2.0f / (float)this.timeSize * ((float)this.sampleRate / 2.0f);
        this.noAverages();
        this.allocateArrays();
        this.whichWindow = 0;
    }

    protected abstract void allocateArrays();

    protected void setComplex(float[] r, float[] i) {
        if (this.real.length != r.length && this.imag.length != i.length) {
            Minim.error("FourierTransform.setComplex: the two arrays must be the same length as their member counterparts.");
        } else {
            System.arraycopy(r, 0, this.real, 0, r.length);
            System.arraycopy(i, 0, this.imag, 0, i.length);
        }
    }

    protected void fillSpectrum() {
        block6: {
            int i;
            block5: {
                i = 0;
                while (i < this.spectrum.length) {
                    this.spectrum[i] = (float)Math.sqrt(this.real[i] * this.real[i] + this.imag[i] * this.imag[i]);
                    ++i;
                }
                if (this.whichAverage != 2) break block5;
                int avgWidth = this.spectrum.length / this.averages.length;
                int i2 = 0;
                while (i2 < this.averages.length) {
                    float avg = 0.0f;
                    int j = 0;
                    while (j < avgWidth) {
                        int offset = j + i2 * avgWidth;
                        if (offset >= this.spectrum.length) break;
                        avg += this.spectrum[offset];
                        ++j;
                    }
                    this.averages[i2] = avg /= (float)j;
                    ++i2;
                }
                break block6;
            }
            if (this.whichAverage != 3) break block6;
            i = 0;
            while (i < this.octaves) {
                float lowFreq = i == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - i);
                float hiFreq = (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - i - 1);
                float freqStep = (hiFreq - lowFreq) / (float)this.avgPerOctave;
                float f = lowFreq;
                int j = 0;
                while (j < this.avgPerOctave) {
                    int offset = j + i * this.avgPerOctave;
                    this.averages[offset] = this.calcAvg(f, f + freqStep);
                    f += freqStep;
                    ++j;
                }
                ++i;
            }
        }
    }

    public void noAverages() {
        this.averages = new float[0];
        this.whichAverage = 4;
    }

    public void linAverages(int numAvg) {
        if (numAvg > this.spectrum.length / 2) {
            Minim.error("The number of averages for this transform can be at most " + this.spectrum.length / 2 + ".");
        } else {
            this.averages = new float[numAvg];
        }
        this.whichAverage = 2;
    }

    public void logAverages(int minBandwidth, int bandsPerOctave) {
        float nyq = (float)this.sampleRate / 2.0f;
        this.octaves = 1;
        while ((nyq /= 2.0f) > (float)minBandwidth) {
            ++this.octaves;
        }
        Minim.debug("Number of octaves = " + this.octaves);
        this.avgPerOctave = bandsPerOctave;
        this.averages = new float[this.octaves * bandsPerOctave];
        this.whichAverage = 3;
    }

    public void window(int which) {
        if (which < 0 || which > 1) {
            Minim.error("Invalid window type.");
        } else {
            this.whichWindow = which;
        }
    }

    protected void doWindow(float[] samples) {
        switch (this.whichWindow) {
            case 1: {
                this.hamming(samples);
            }
        }
    }

    protected void hamming(float[] samples) {
        int i = 0;
        while (i < samples.length) {
            int n = i;
            samples[n] = (float)((double)samples[n] * ((double)0.54f - (double)0.46f * Math.cos((float)Math.PI * 2 * (float)i / (float)(samples.length - 1))));
            ++i;
        }
    }

    public int timeSize() {
        return this.timeSize;
    }

    public int specSize() {
        return this.spectrum.length;
    }

    public float getBand(int i) {
        if (i < 0) {
            i = 0;
        }
        if (i > this.spectrum.length - 1) {
            i = this.spectrum.length - 1;
        }
        return this.spectrum[i];
    }

    public float getBandWidth() {
        return this.bandWidth;
    }

    public abstract void setBand(int var1, float var2);

    public abstract void scaleBand(int var1, float var2);

    public int freqToIndex(float freq) {
        if (freq < this.getBandWidth() / 2.0f) {
            return 0;
        }
        if (freq > (float)(this.sampleRate / 2) - this.getBandWidth() / 2.0f) {
            return this.spectrum.length - 1;
        }
        float fraction = freq / (float)this.sampleRate;
        int i = Math.round((float)this.timeSize * fraction);
        return i;
    }

    public float getFreq(float freq) {
        return this.getBand(this.freqToIndex(freq));
    }

    public void setFreq(float freq, float a) {
        this.setBand(this.freqToIndex(freq), a);
    }

    public void scaleFreq(float freq, float s) {
        this.scaleBand(this.freqToIndex(freq), s);
    }

    public int avgSize() {
        return this.averages.length;
    }

    public float getAvg(int i) {
        float ret = this.averages.length > 0 ? this.averages[i] : 0.0f;
        return ret;
    }

    public float calcAvg(float lowFreq, float hiFreq) {
        int lowBound = this.freqToIndex(lowFreq);
        int hiBound = this.freqToIndex(hiFreq);
        float avg = 0.0f;
        int i = lowBound;
        while (i <= hiBound) {
            avg += this.spectrum[i];
            ++i;
        }
        return avg /= (float)(hiBound - lowBound + 1);
    }

    public abstract void forward(float[] var1);

    public void forward(AudioBuffer buffer) {
        this.forward(buffer.toArray());
    }

    public abstract void inverse(float[] var1);

    public void inverse(AudioBuffer buffer) {
        this.inverse(buffer.toArray());
    }

    public void inverse(float[] freqReal, float[] freqImag, float[] buffer) {
        this.setComplex(freqReal, freqImag);
        this.inverse(buffer);
    }
}

